/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http.impl.client;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.util.AWSRequestMetrics;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;

@ThreadSafe
public class SdkHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    public static final SdkHttpRequestRetryHandler Singleton = new SdkHttpRequestRetryHandler();

    private SdkHttpRequestRetryHandler() {
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        AWSRequestMetrics awsRequestMetrics;
        boolean retry = super.retryRequest(exception, executionCount, context);
        if (retry && (awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.SIMPLE_NAME)) != null) {
            awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.HttpClientRetryCount);
        }
        return retry;
    }
}

