/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.snowflake.client.core.FileCacheManager;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.JsonNodeType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class CredentialManager {
    private static final SFLogger logger = SFLoggerFactory.getLogger(CredentialManager.class);
    private static final String CACHE_FILE_NAME = "temporary_credential.json";
    private static final String CACHE_DIR_PROP = "net.snowflake.jdbc.temporaryCredentialCacheDir";
    private static final String CACHE_DIR_ENV = "SF_TEMPORARY_CREDENTIAL_CACHE_DIR";
    private static final long CACHE_EXPIRATION_IN_SECONDS = 86400L;
    private static final long CACHE_FILE_LOCK_EXPIRATION_IN_SECONDS = 60L;
    private FileCacheManager fileCacheManager;
    private static CredentialManager instance;
    private final Map<String, Map<String, String>> idTokenCache = new HashMap<String, Map<String, String>>();

    private CredentialManager() {
        this.fileCacheManager = FileCacheManager.builder().setCacheDirectorySystemProperty(CACHE_DIR_PROP).setCacheDirectoryEnvironmentVariable(CACHE_DIR_ENV).setBaseCacheFileName(CACHE_FILE_NAME).setCacheExpirationInSeconds(86400L).setCacheFileLockExpirationInSeconds(60L).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CredentialManager getInstance() {
        if (instance != null) return instance;
        Class<CredentialManager> clazz = CredentialManager.class;
        synchronized (CredentialManager.class) {
            if (instance != null) return instance;
            instance = new CredentialManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    synchronized boolean fillCachedIdToken(SFLoginInput loginInput) {
        JsonNode res = this.fileCacheManager.readCacheFile();
        this.readJsonStoreCache(res);
        Map<String, String> userMap = this.idTokenCache.get(loginInput.getAccountName().toUpperCase());
        if (userMap == null) {
            return false;
        }
        String idToken = userMap.get(loginInput.getUserName().toUpperCase());
        if (idToken == null) {
            return false;
        }
        loginInput.setIdToken(idToken);
        return true;
    }

    synchronized void writeTemporaryCredential(SFLoginInput loginInput, SFLoginOutput loginOutput) {
        if (Strings.isNullOrEmpty(loginOutput.getIdToken())) {
            return;
        }
        String currentAccount = loginInput.getAccountName().toUpperCase();
        this.idTokenCache.computeIfAbsent(currentAccount, newMap -> new HashMap());
        Map<String, String> currentUserMap = this.idTokenCache.get(currentAccount);
        currentUserMap.put(loginInput.getUserName().toUpperCase(), loginOutput.getIdToken());
        ObjectNode out = StmtUtil.mapper.createObjectNode();
        for (Map.Entry<String, Map<String, String>> elem : this.idTokenCache.entrySet()) {
            String account = elem.getKey();
            Map<String, String> userMap = elem.getValue();
            ObjectNode userNode = StmtUtil.mapper.createObjectNode();
            for (Map.Entry<String, String> elem0 : userMap.entrySet()) {
                userNode.put(elem0.getKey(), elem0.getValue());
            }
            out.set(account, userNode);
        }
        this.fileCacheManager.writeCacheFile(out);
    }

    void deleteIdTokenCache() {
        this.fileCacheManager.deleteCacheFile();
    }

    private void readJsonStoreCache(JsonNode m) {
        if (m == null || !m.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            logger.debug("Invalid cache file format.");
            return;
        }
        Iterator<Map.Entry<String, JsonNode>> itr = m.fields();
        while (itr.hasNext()) {
            Map.Entry<String, JsonNode> accountMap = itr.next();
            String account = accountMap.getKey();
            if (!this.idTokenCache.containsKey(account)) {
                this.idTokenCache.put(account, new HashMap());
            }
            JsonNode userJsonNode = accountMap.getValue();
            Iterator<Map.Entry<String, JsonNode>> itr0 = userJsonNode.fields();
            while (itr0.hasNext()) {
                Map.Entry<String, JsonNode> userMap = itr0.next();
                this.idTokenCache.get(account).put(userMap.getKey(), userMap.getValue().asText());
            }
        }
    }
}

