/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaDataQueryResultSet;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaDataResultSet;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.snowflake.common.util.Wildcard;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;

public class SnowflakeDatabaseMetaData
implements DatabaseMetaData {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeDatabaseMetaData.class);
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private static final String DatabaseProductName = "Snowflake";
    private static final String DriverName = "Snowflake";
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private static final String JDBCVersion = "1.0";
    private static final String NumericFunctionsSupported = "ABS,ACOS,ASIN,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SQRT,TAN,TRUNCATE";
    private static final String StringFunctionsSupported = "ASCII,CHAR,CONCAT,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SPACE,SUBSTRING,UCASE";
    private static final String DateAndTimeFunctionsSupported = "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    private static final String SystemFunctionsSupported = "DATABASE,IFNULL,USER";
    private static final String notSQL2003Keywords = "ACCOUNT,DATABASE,SCHEMA,VIEW,ISSUE,DATE_PART,EXTRACT,POSITION,TRY_CAST,BIT,DATETIME,NUMBERC,OBJECT,BYTEINT,STRING,TEXT,TIMESTAMPLTZ,TIMESTAMPNTZ,TIMESTAMPTZ,TIMESTAMP_LTZ,TIMESTAMP_NTZ,TIMESTAMP_TZ,TINYINT,VARBINARY,VARIANT,ACCOUNTS,ACTION,ACTIVATE,ASC,AUTOINCREMENT,BEFORE,BUILTIN,BYTE,CACHE,CHANGE,CLEAREPCACHE,CLONE,CLUSTER,CLUSTERS,COLUMNS,COMMENT,COMPRESSION,CONSTRAINTS,COPY,CP,CREDENTIALS,D,DATA,DATABASES,DEFERRABLE,DEFERRED,DELIMITED,DESC,DIRECTORY,DISABLE,DUAL,ENABLE,ENFORCED,EXCLUSIVE,EXPLAIN,EXPORTED,FAIL,FIELDS,FILE,FILES,FIRST,FN,FORCE,FORMAT,FORMATS,FUNCTIONS,GRANTS,GSINSTANCE,GSINSTANCES,HELP,HIBERNATE,HINTS,HISTORY,IDENTIFIED,IMMUTABLE,IMPORTED,INCIDENT,INCIDENTS,INFO,INITIALLY,ISSUES,KEEP,KEY,KEYS,LAST,LIMIT,LIST,LOAD,LOCATION,LOCK,LOCKS,LS,MANAGE,MAP,MATCHED,MATERIALIZED,MODIFY,MONITOR,MONITORS,NAME,NETWORK,NEXT,NORELY,NOTIFY,NOVALIDATE,NULLS,OBJECTS,OFFSET,OJ,OPERATE,OPERATION,OPTION,OWNERSHIP,PARAMETERS,PARTIAL,PERCENT,PLAN,PLUS,POLICIES,POLICY,POOL,PRESERVE,PRIVILEGES,PUBLIC,PURGE,PUT,QUIESCE,READ,RECLUSTER,REFERENCE,RELY,REMOVE,RENAME,REPLACE,REPLACE_FAIL,RESOURCE,RESTART,RESTORE,RESTRICT,RESUME,REWRITE,RM,ROLE,ROLES,RULE,SAMPLE,SCHEMAS,SEMI,SEQUENCE,SEQUENCES,SERVER,SERVERS,SESSION,SETLOGLEVEL,SETS,SFC,SHARE,SHARED,SHARES,SHOW,SHUTDOWN,SIMPLE,SORT,STAGE,STAGES,STATEMENT,STATISTICS,STOP,STORED,STRICT,STRUCT,SUSPEND,SUSPEND_IMMEDIATE,SWAP,SWITCH,T,TABLES,TEMP,TEMPORARY,TRANSACTION,TRANSACTIONS,TRANSIENT,TRIGGERS,TRUNCATE,TS,TYPE,UNDROP,UNLOCK,UNSET,UPGRADE,USAGE,USE,USERS,UTC,UTCTIMESTAMP,VALIDATE,VARIABLES,VERSION,VIEWS,VOLATILE,VOLUME,VOLUMES,WAREHOUSE,WAREHOUSES,WARN,WORK,WRITE,ZONE,INCREMENT,MINUS,REGEXP,RLIKE";
    private final Connection connection;
    private final SFSession session;
    private final boolean metadataRequestUseConnectionCtx;

    SnowflakeDatabaseMetaData(Connection connection) throws SQLException {
        logger.debug("public SnowflakeDatabaseMetaData(SnowflakeConnection connection)");
        this.connection = connection;
        this.session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        this.metadataRequestUseConnectionCtx = this.session.getMetadataRequestUseConnectionCtx();
    }

    private void raiseSQLExceptionIfConnectionIsClosed() throws SQLException {
        if (this.connection.isClosed()) {
            throw new SnowflakeSQLException(ErrorCode.CONNECTION_CLOSED, new Object[0]);
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        logger.debug("public boolean allProceduresAreCallable()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        logger.debug("public boolean allTablesAreSelectable()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        logger.debug("public String getURL()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        String url = this.session.getUrl();
        return url.startsWith("http://") ? url.replace("http://", "jdbc:snowflake://") : url.replace("https://", "jdbc:snowflake://");
    }

    @Override
    public String getUserName() throws SQLException {
        logger.debug("public String getUserName()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.session.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.debug("public boolean isReadOnly()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        logger.debug("public boolean nullsAreSortedHigh()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        logger.debug("public boolean nullsAreSortedLow()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        logger.debug("public boolean nullsAreSortedAtStart()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        logger.debug("public boolean nullsAreSortedAtEnd()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        logger.debug("public String getDatabaseProductName()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "Snowflake";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        logger.debug("public String getDatabaseProductVersion()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection.unwrap(SnowflakeConnectionV1.class).getDatabaseVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        logger.debug("public String getDriverName()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "Snowflake";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        logger.debug("public String getDriverVersion()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return SnowflakeDriver.majorVersion + "." + SnowflakeDriver.minorVersion + "." + SnowflakeDriver.patchVersion;
    }

    @Override
    public int getDriverMajorVersion() {
        logger.debug("public int getDriverMajorVersion()");
        return SnowflakeDriver.majorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        logger.debug("public int getDriverMinorVersion()");
        return SnowflakeDriver.minorVersion;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        logger.debug("public boolean usesLocalFiles()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        logger.debug("public boolean usesLocalFilePerTable()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        logger.debug("public boolean supportsMixedCaseIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        logger.debug("public boolean storesUpperCaseIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        logger.debug("public boolean storesLowerCaseIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        logger.debug("public boolean storesMixedCaseIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        logger.debug("public boolean supportsMixedCaseQuotedIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        logger.debug("public boolean storesUpperCaseQuotedIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        logger.debug("public boolean storesLowerCaseQuotedIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        logger.debug("public boolean storesMixedCaseQuotedIdentifiers()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        logger.debug("public String getIdentifierQuoteString()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        logger.debug("public String getSQLKeywords()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return notSQL2003Keywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        logger.debug("public String getNumericFunctions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return NumericFunctionsSupported;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        logger.debug("public String getStringFunctions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return StringFunctionsSupported;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        logger.debug("public String getSystemFunctions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return SystemFunctionsSupported;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        logger.debug("public String getTimeDateFunctions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return DateAndTimeFunctionsSupported;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        logger.debug("public String getSearchStringEscape()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Character.toString('\\');
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        logger.debug("public String getExtraNameCharacters()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "$";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        logger.debug("public boolean supportsAlterTableWithAddColumn()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        logger.debug("public boolean supportsAlterTableWithDropColumn()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        logger.debug("public boolean supportsColumnAliasing()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        logger.debug("public boolean nullPlusNonNullIsNull()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        logger.debug("public boolean supportsConvert()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        logger.debug("public boolean supportsConvert(int fromType, int toType)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        logger.debug("public boolean supportsTableCorrelationNames()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        logger.debug("public boolean supportsDifferentTableCorrelationNames()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        logger.debug("public boolean supportsExpressionsInOrderBy()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        logger.debug("public boolean supportsOrderByUnrelated()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        logger.debug("public boolean supportsGroupBy()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        logger.debug("public boolean supportsGroupByUnrelated()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        logger.debug("public boolean supportsGroupByBeyondSelect()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        logger.debug("public boolean supportsLikeEscapeClause()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        logger.debug("public boolean supportsMultipleResultSets()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        logger.debug("public boolean supportsMultipleTransactions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        logger.debug("public boolean supportsNonNullableColumns()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        logger.debug("public boolean supportsMinimumSQLGrammar()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        logger.debug("public boolean supportsCoreSQLGrammar()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        logger.debug("public boolean supportsExtendedSQLGrammar()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        logger.debug("public boolean supportsANSI92EntryLevelSQL()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        logger.debug("public boolean supportsANSI92IntermediateSQL()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        logger.debug("public boolean supportsANSI92FullSQL()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        logger.debug("public boolean supportsIntegrityEnhancementFacility()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        logger.debug("public boolean supportsOuterJoins()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        logger.debug("public boolean supportsFullOuterJoins()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        logger.debug("public boolean supportsLimitedOuterJoins()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        logger.debug("public String getSchemaTerm()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        logger.debug("public String getProcedureTerm()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        logger.debug("public String getCatalogTerm()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        logger.debug("public boolean isCatalogAtStart()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        logger.debug("public String getCatalogSeparator()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        logger.debug("public boolean supportsSchemasInDataManipulation()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        logger.debug("public boolean supportsSchemasInProcedureCalls()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        logger.debug("public boolean supportsSchemasInTableDefinitions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        logger.debug("public boolean supportsSchemasInIndexDefinitions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        logger.debug("public boolean supportsSchemasInPrivilegeDefinitions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        logger.debug("public boolean supportsCatalogsInDataManipulation()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        logger.debug("public boolean supportsCatalogsInProcedureCalls()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        logger.debug("public boolean supportsCatalogsInTableDefinitions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        logger.debug("public boolean supportsCatalogsInIndexDefinitions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        logger.debug("public boolean supportsCatalogsInPrivilegeDefinitions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        logger.debug("public boolean supportsPositionedDelete()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        logger.debug("public boolean supportsPositionedUpdate()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        logger.debug("public boolean supportsSelectForUpdate()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        logger.debug("public boolean supportsStoredProcedures()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        logger.debug("public boolean supportsSubqueriesInComparisons()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        logger.debug("public boolean supportsSubqueriesInExists()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        logger.debug("public boolean supportsSubqueriesInIns()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        logger.debug("public boolean supportsSubqueriesInQuantifieds()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        logger.debug("public boolean supportsCorrelatedSubqueries()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        logger.debug("public boolean supportsUnion()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        logger.debug("public boolean supportsUnionAll()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        logger.debug("public boolean supportsOpenCursorsAcrossCommit()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        logger.debug("public boolean supportsOpenCursorsAcrossRollback()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        logger.debug("public boolean supportsOpenStatementsAcrossCommit()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        logger.debug("public boolean supportsOpenStatementsAcrossRollback()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        logger.debug("public int getMaxBinaryLiteralLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0x800000;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        logger.debug("public int getMaxCharLiteralLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0x1000000;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        logger.debug("public int getMaxColumnNameLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        logger.debug("public int getMaxColumnsInGroupBy()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        logger.debug("public int getMaxColumnsInIndex()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        logger.debug("public int getMaxColumnsInOrderBy()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        logger.debug("public int getMaxColumnsInSelect()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        logger.debug("public int getMaxColumnsInTable()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        logger.debug("public int getMaxConnections()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        logger.debug("public int getMaxCursorNameLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        logger.debug("public int getMaxIndexLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        logger.debug("public int getMaxSchemaNameLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        logger.debug("public int getMaxProcedureNameLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        logger.debug("public int getMaxCatalogNameLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        logger.debug("public int getMaxRowSize()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        logger.debug("public boolean doesMaxRowSizeIncludeBlobs()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        logger.debug("public int getMaxStatementLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        logger.debug("public int getMaxStatements()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        logger.debug("public int getMaxTableNameLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        logger.debug("public int getMaxTablesInSelect()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        logger.debug("public int getMaxUserNameLength()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        logger.debug("public int getDefaultTransactionIsolation()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        logger.debug("public boolean supportsTransactions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        logger.debug("public boolean supportsTransactionIsolationLevel(int level)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return level == 0 || level == 2;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        logger.debug("public boolean supportsDataDefinitionAndDataManipulationTransactions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        logger.debug("public boolean supportsDataManipulationTransactionsOnly()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        logger.debug("public boolean dataDefinitionCausesTransactionCommit()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        logger.debug("public boolean dataDefinitionIgnoredInTransactions()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        logger.debug("public ResultSet getProcedures(String catalog, String schemaPattern,String procedureNamePattern)");
        String showProcedureCommand = this.getFirstResultSetCommand(catalog, schemaPattern, procedureNamePattern, "procedures");
        if (showProcedureCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PROCEDURES, statement);
        }
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledProcedurePattern = Wildcard.toRegexPattern(procedureNamePattern, true);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showProcedureCommand, DBMetadataResultSetMetadata.GET_PROCEDURES);
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_PROCEDURES, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String catalogName = this.showObjectResultSet.getString("catalog_name");
                    String schemaName = this.showObjectResultSet.getString("schema_name");
                    String procedureName = this.showObjectResultSet.getString("name");
                    String remarks = this.showObjectResultSet.getString("description");
                    String specificName = this.showObjectResultSet.getString("arguments");
                    short procedureType = 2;
                    if (compiledProcedurePattern != null && !compiledProcedurePattern.matcher(procedureName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches()) continue;
                    logger.debug("Found a matched function:" + schemaName + "." + procedureName);
                    this.nextRow[0] = catalogName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = procedureName;
                    this.nextRow[3] = remarks;
                    this.nextRow[4] = procedureType;
                    this.nextRow[5] = specificName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        logger.debug("public ResultSet getProcedureColumns(String catalog, String schemaPattern,String procedureNamePattern,String columnNamePattern)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        boolean addAllRows = false;
        String showProcedureCommand = this.getFirstResultSetCommand(catalog, schemaPattern, procedureNamePattern, "procedures");
        if (showProcedureCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS, statement);
        }
        if (columnNamePattern == null || columnNamePattern.isEmpty() || columnNamePattern.trim().equals("%") || columnNamePattern.trim().equals(".*")) {
            addAllRows = true;
        }
        ResultSet resultSetStepOne = this.executeAndReturnEmptyResultIfNotFound(statement, showProcedureCommand, DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (resultSetStepOne.next()) {
            int i;
            String procedureNameUnparsed = resultSetStepOne.getString("arguments").trim();
            String procedureNameNoArgs = resultSetStepOne.getString("name");
            String showProcedureColCommand = this.getSecondResultSetCommand(catalog, schemaPattern, procedureNameUnparsed, "procedure");
            ResultSet resultSetStepTwo = this.executeAndReturnEmptyResultIfNotFound(statement, showProcedureColCommand, DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS);
            resultSetStepTwo.next();
            String[] params = this.parseParams(resultSetStepTwo.getString("value"));
            resultSetStepTwo.next();
            String res = resultSetStepTwo.getString("value");
            String[] paramNames = new String[params.length / 2 + 1];
            String[] paramTypes = new String[params.length / 2 + 1];
            if (params.length > 1) {
                for (i = 0; i < params.length; ++i) {
                    if (i % 2 == 0) {
                        paramNames[i / 2 + 1] = params[i];
                        continue;
                    }
                    paramTypes[i / 2 + 1] = params[i];
                }
            }
            paramNames[0] = "";
            paramTypes[0] = res;
            for (i = 0; i < paramNames.length; ++i) {
                String typeName;
                if (i != 0 && !paramNames[i].equalsIgnoreCase(columnNamePattern) && !addAllRows) continue;
                Object[] nextRow = new Object[20];
                nextRow[0] = catalog;
                nextRow[1] = schemaPattern;
                nextRow[2] = procedureNameNoArgs;
                nextRow[3] = paramNames[i];
                nextRow[4] = i == 0 ? (paramTypes[i].substring(0, 5).equalsIgnoreCase("table") ? Integer.valueOf(4) : Integer.valueOf(5)) : Integer.valueOf(1);
                String typeNameTrimmed = typeName = paramTypes[i];
                if (typeName.contains(" NOT NULL")) {
                    typeNameTrimmed = typeName.substring(0, typeName.indexOf(32));
                }
                int type = SnowflakeType.convertStringToType(typeName);
                nextRow[5] = type;
                nextRow[6] = typeNameTrimmed;
                int precision = 38;
                short scale = 0;
                if (type < 10) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        precision = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(44)));
                        scale = Short.parseShort(typeName.substring(typeName.indexOf(44) + 1, typeName.indexOf(41)));
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    } else {
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    }
                } else {
                    nextRow[7] = 0;
                    nextRow[9] = null;
                }
                nextRow[8] = 0;
                nextRow[10] = 10;
                if (typeName.toLowerCase().contains("not null")) {
                    nextRow[11] = 0;
                    nextRow[18] = "NO";
                } else if (i == 0) {
                    nextRow[11] = 1;
                    nextRow[18] = "YES";
                } else {
                    nextRow[11] = 2;
                    nextRow[18] = "";
                }
                nextRow[12] = resultSetStepOne.getString("description").trim();
                nextRow[13] = null;
                nextRow[14] = 0;
                nextRow[15] = 0;
                if (type == -2 || type == -3 || type == 1 || type == 12) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        int char_octet_len = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(41)));
                        nextRow[16] = char_octet_len;
                    } else if (type == 1 || type == 12) {
                        nextRow[16] = 0x1000000;
                    } else if (type == -2 || type == -3) {
                        nextRow[16] = 0x800000;
                    }
                } else {
                    nextRow[16] = null;
                }
                nextRow[17] = i;
                nextRow[19] = procedureNameUnparsed;
                rows.add(nextRow);
            }
        }
        Object[][] resultRows = new Object[rows.size()][20];
        for (int i = 0; i < resultRows.length; ++i) {
            resultRows[i] = (Object[])rows.get(i);
        }
        return new SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS, resultRows, statement);
    }

    private SFPair<String, String> applySessionContext(String catalog, String schemaPattern) {
        if (catalog == null && this.metadataRequestUseConnectionCtx) {
            catalog = this.session.getDatabase();
            if (schemaPattern == null) {
                schemaPattern = this.session.getSchema();
            }
        }
        return SFPair.of(catalog, schemaPattern);
    }

    private String getFirstResultSetCommand(String catalog, String schemaPattern, String name, String type) {
        SFPair<String, String> resPair = this.applySessionContext(catalog, schemaPattern);
        catalog = (String)resPair.left;
        schemaPattern = (String)resPair.right;
        String showProcedureCommand = "show /* JDBC:DatabaseMetaData.getProcedures() */ " + type;
        if (!(name == null || name.isEmpty() || name.trim().equals("%") || name.trim().equals(".*"))) {
            showProcedureCommand = showProcedureCommand + " like '" + name + "'";
        }
        if (catalog == null) {
            showProcedureCommand = showProcedureCommand + " in account";
        } else {
            if (catalog.isEmpty()) {
                return "";
            }
            if (schemaPattern == null || Wildcard.isWildcardPatternStr(schemaPattern)) {
                showProcedureCommand = showProcedureCommand + " in database \"" + catalog + "\"";
            } else {
                if (schemaPattern.isEmpty()) {
                    return "";
                }
                schemaPattern = schemaPattern.replace("\\", "");
                showProcedureCommand = showProcedureCommand + " in schema \"" + catalog + "\".\"" + schemaPattern + "\"";
            }
        }
        logger.debug("sql command to get column metadata: {}", showProcedureCommand);
        return showProcedureCommand;
    }

    private String getSecondResultSetCommand(String catalog, String schemaPattern, String name, String type) {
        String procedureName = name.substring(0, name.indexOf(" RETURN"));
        String showProcedureColCommand = catalog != null && schemaPattern != null ? "desc " + type + " " + catalog + "." + schemaPattern + "." + procedureName : (schemaPattern != null ? "desc " + type + " " + schemaPattern + "." + procedureName : "desc " + type + " " + procedureName);
        return showProcedureColCommand;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean tableOnly;
        logger.debug("public ResultSet getTables(String catalog={}, String schemaPattern={}, String tableNamePattern={}, String[] types={})", catalog, schemaPattern, tableNamePattern, () -> Arrays.toString(types));
        this.raiseSQLExceptionIfConnectionIsClosed();
        HashSet<String> supportedTableTypes = new HashSet<String>();
        ResultSet resultSet = this.getTableTypes();
        while (resultSet.next()) {
            supportedTableTypes.add(resultSet.getString("TABLE_TYPE"));
        }
        resultSet.close();
        ArrayList<String> inputValidTableTypes = new ArrayList<String>();
        if (types != null) {
            for (String t : types) {
                if (!supportedTableTypes.contains(t)) continue;
                inputValidTableTypes.add(t);
            }
        } else {
            inputValidTableTypes = new ArrayList(supportedTableTypes);
        }
        Statement statement = this.connection.createStatement();
        if (inputValidTableTypes.size() == 0) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_TABLES, statement);
        }
        SFPair<String, String> resPair = this.applySessionContext(catalog, schemaPattern);
        catalog = (String)resPair.left;
        schemaPattern = (String)resPair.right;
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledTablePattern = Wildcard.toRegexPattern(tableNamePattern, true);
        String showCommand = null;
        final boolean viewOnly = inputValidTableTypes.size() == 1 && "VIEW".equalsIgnoreCase((String)inputValidTableTypes.get(0));
        boolean bl = tableOnly = inputValidTableTypes.size() == 1 && "TABLE".equalsIgnoreCase((String)inputValidTableTypes.get(0));
        showCommand = viewOnly ? "show /* JDBC:DatabaseMetaData.getTables() */ views" : (tableOnly ? "show /* JDBC:DatabaseMetaData.getTables() */ tables" : "show /* JDBC:DatabaseMetaData.getTables() */ objects");
        if (!(tableNamePattern == null || tableNamePattern.isEmpty() || tableNamePattern.trim().equals("%") || tableNamePattern.trim().equals(".*"))) {
            showCommand = showCommand + " like '" + tableNamePattern + "'";
        }
        if (catalog == null) {
            showCommand = showCommand + " in account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_TABLES, statement);
            }
            if (schemaPattern == null || Wildcard.isWildcardPatternStr(schemaPattern)) {
                showCommand = showCommand + " in database \"" + catalog + "\"";
            } else {
                if (schemaPattern.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_TABLES, statement);
                }
                schemaPattern = schemaPattern.replace("\\", "");
                showCommand = showCommand + " in schema \"" + catalog + "\".\"" + schemaPattern + "\"";
            }
        }
        logger.debug("sql command to get table metadata: {}", showCommand);
        resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showCommand, DBMetadataResultSetMetadata.GET_TABLES);
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_TABLES, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String comment;
                    String kind;
                    String schemaName;
                    String dbName;
                    String tableName = this.showObjectResultSet.getString(2);
                    if (viewOnly) {
                        dbName = this.showObjectResultSet.getString(4);
                        schemaName = this.showObjectResultSet.getString(5);
                        kind = "VIEW";
                        comment = this.showObjectResultSet.getString(7);
                    } else {
                        dbName = this.showObjectResultSet.getString(3);
                        schemaName = this.showObjectResultSet.getString(4);
                        kind = this.showObjectResultSet.getString(5);
                        comment = this.showObjectResultSet.getString(6);
                    }
                    if (compiledTablePattern != null && !compiledTablePattern.matcher(tableName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches()) continue;
                    this.nextRow[0] = dbName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = tableName;
                    this.nextRow[3] = kind;
                    this.nextRow[4] = comment;
                    this.nextRow[5] = null;
                    this.nextRow[6] = null;
                    this.nextRow[7] = null;
                    this.nextRow[8] = null;
                    this.nextRow[9] = null;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        logger.debug("public ResultSet getSchemas()");
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        logger.debug("public ResultSet getCatalogs()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        String showDB = "show /* JDBC:DatabaseMetaData.getCatalogs() */ databases in account";
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_CATALOGS, statement.executeQuery(showDB), statement){

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                if (this.showObjectResultSet.next()) {
                    String dbName = this.showObjectResultSet.getString(2);
                    this.nextRow[0] = dbName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        logger.debug("public ResultSet getTableTypes()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Collections.singletonList("TABLE_TYPE"), Collections.singletonList("TEXT"), Collections.singletonList(12), new Object[][]{{"TABLE"}, {"VIEW"}}, statement);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern, false);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, final boolean extendedSet) throws SQLException {
        logger.debug("public ResultSet getColumns(String catalog={}, String schemaPattern={}String tableNamePattern={}, String columnNamePattern={}, boolean extendedSet={}", catalog, schemaPattern, tableNamePattern, columnNamePattern, extendedSet);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        SFPair<String, String> resPair = this.applySessionContext(catalog, schemaPattern);
        catalog = (String)resPair.left;
        schemaPattern = (String)resPair.right;
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledTablePattern = Wildcard.toRegexPattern(tableNamePattern, true);
        final Pattern compiledColumnPattern = Wildcard.toRegexPattern(columnNamePattern, true);
        String showColumnCommand = "show /* JDBC:DatabaseMetaData.getColumns() */ columns";
        if (!(columnNamePattern == null || columnNamePattern.isEmpty() || columnNamePattern.trim().equals("%") || columnNamePattern.trim().equals(".*"))) {
            showColumnCommand = showColumnCommand + " like '" + columnNamePattern + "'";
        }
        if (catalog == null) {
            showColumnCommand = showColumnCommand + " in account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, statement);
            }
            if (schemaPattern == null || Wildcard.isWildcardPatternStr(schemaPattern)) {
                showColumnCommand = showColumnCommand + " in database \"" + catalog + "\"";
            } else {
                if (schemaPattern.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, statement);
                }
                schemaPattern = schemaPattern.replace("\\", "");
                if (tableNamePattern == null || Wildcard.isWildcardPatternStr(tableNamePattern)) {
                    showColumnCommand = showColumnCommand + " in schema \"" + catalog + "\".\"" + schemaPattern + "\"";
                } else {
                    if (tableNamePattern.isEmpty()) {
                        return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, statement);
                    }
                    tableNamePattern = tableNamePattern.replace("\\", "");
                    showColumnCommand = showColumnCommand + " in table \"" + catalog + "\".\"" + schemaPattern + "\".\"" + tableNamePattern + "\"";
                }
            }
        }
        logger.debug("sql command to get column metadata: {}", showColumnCommand);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showColumnCommand, extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS);
        return new SnowflakeDatabaseMetaDataQueryResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, resultSet, statement){
            int ordinalPosition;
            String currentTableName;
            {
                super(metadataType, resultSet, statement);
                this.ordinalPosition = 0;
                this.currentTableName = null;
            }

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    int internalColumnType;
                    JsonNode jsonNode;
                    String tableName = this.showObjectResultSet.getString(1);
                    String schemaName = this.showObjectResultSet.getString(2);
                    String columnName = this.showObjectResultSet.getString(3);
                    String dataTypeStr = this.showObjectResultSet.getString(4);
                    String defaultValue = this.showObjectResultSet.getString(6);
                    String comment = this.showObjectResultSet.getString(9);
                    String catalogName = this.showObjectResultSet.getString(10);
                    String autoIncrement = this.showObjectResultSet.getString(11);
                    if (compiledTablePattern != null && !compiledTablePattern.matcher(tableName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches() || compiledColumnPattern != null && !compiledColumnPattern.matcher(columnName).matches()) continue;
                    logger.debug("Found a matched column:" + tableName + "." + columnName);
                    if (!tableName.equals(this.currentTableName)) {
                        this.ordinalPosition = 1;
                        this.currentTableName = tableName;
                    } else {
                        ++this.ordinalPosition;
                    }
                    try {
                        jsonNode = mapper.readTree(dataTypeStr);
                    }
                    catch (Exception ex) {
                        logger.error("Exeception when parsing column result", ex);
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "error parsing data type: " + dataTypeStr);
                    }
                    logger.debug("data type string: {}", dataTypeStr);
                    SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata(jsonNode, SnowflakeDatabaseMetaData.this.session.isJdbcTreatDecimalAsInt());
                    logger.debug("nullable: {}", columnMetadata.isNullable());
                    this.nextRow[0] = catalogName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = tableName;
                    this.nextRow[3] = columnName;
                    int externalColumnType = internalColumnType = columnMetadata.getType();
                    if (internalColumnType == 50000 || internalColumnType == 50001) {
                        externalColumnType = 93;
                    }
                    this.nextRow[4] = externalColumnType;
                    this.nextRow[5] = columnMetadata.getTypeName();
                    int columnSize = 0;
                    if (columnMetadata.getType() == 12 || columnMetadata.getType() == 1 || columnMetadata.getType() == -2) {
                        columnSize = columnMetadata.getLength();
                    } else if (columnMetadata.getType() == 3 || columnMetadata.getType() == -5 || columnMetadata.getType() == 92 || columnMetadata.getType() == 93) {
                        columnSize = columnMetadata.getPrecision();
                    }
                    this.nextRow[6] = columnSize;
                    this.nextRow[7] = null;
                    this.nextRow[8] = columnMetadata.getScale();
                    this.nextRow[9] = null;
                    this.nextRow[10] = columnMetadata.isNullable() ? 1 : 0;
                    logger.debug("returning nullable: {}", this.nextRow[10]);
                    this.nextRow[11] = comment;
                    this.nextRow[12] = defaultValue;
                    this.nextRow[13] = externalColumnType;
                    this.nextRow[14] = null;
                    this.nextRow[15] = columnMetadata.getType() == 12 || columnMetadata.getType() == 1 ? Integer.valueOf(columnMetadata.getLength()) : null;
                    this.nextRow[16] = this.ordinalPosition;
                    this.nextRow[17] = columnMetadata.isNullable() ? "YES" : "NO";
                    this.nextRow[18] = null;
                    this.nextRow[19] = null;
                    this.nextRow[20] = null;
                    this.nextRow[21] = null;
                    this.nextRow[22] = "".equals(autoIncrement) ? "NO" : "YES";
                    this.nextRow[23] = "NO";
                    if (extendedSet) {
                        this.nextRow[24] = columnMetadata.getBase().name();
                    }
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        logger.debug("public ResultSet getColumnPrivileges(String catalog, String schema,String table, String columnNamePattern)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"), Arrays.asList("TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT"), Arrays.asList(12, 12, 12, 12, 12, 12, 12, 12), new Object[0][], statement);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        logger.debug("public ResultSet getTablePrivileges(String catalog, String schemaPattern,String tableNamePattern)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"), Arrays.asList("TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT"), Arrays.asList(12, 12, 12, 12, 12, 12, 12), new Object[0][], statement);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        logger.debug("public ResultSet getBestRowIdentifier(String catalog, String schema,String table, int scope,boolean nullable)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        logger.debug("public ResultSet getVersionColumns(String catalog, String schema, String table)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        logger.debug("public ResultSet getPrimaryKeys(String catalog={}, String schema={}, String table={})", catalog, schema, table);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        String showPKCommand = "show /* JDBC:DatabaseMetaData.getPrimaryKeys() */ primary keys in ";
        SFPair<String, String> resPair = this.applySessionContext(catalog, schema);
        catalog = (String)resPair.left;
        schema = (String)resPair.right;
        if (catalog == null) {
            showPKCommand = showPKCommand + "account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, statement);
            }
            if (schema == null) {
                showPKCommand = showPKCommand + "database \"" + catalog + "\"";
            } else {
                if (schema.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, statement);
                }
                if (table == null) {
                    showPKCommand = showPKCommand + "schema \"" + catalog + "\".\"" + schema + "\"";
                } else {
                    if (table.isEmpty()) {
                        return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, statement);
                    }
                    showPKCommand = showPKCommand + "table \"" + catalog + "\".\"" + schema + "\".\"" + table + "\"";
                }
            }
        }
        final String catalogIn = catalog;
        final String schemaIn = schema;
        final String tableIn = table;
        logger.debug("sql command to get primary key metadata: {}", showPKCommand);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showPKCommand, DBMetadataResultSetMetadata.GET_PRIMARY_KEYS);
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String table_cat = this.showObjectResultSet.getString(2);
                    String table_schem = this.showObjectResultSet.getString(3);
                    String table_name = this.showObjectResultSet.getString(4);
                    String column_name = this.showObjectResultSet.getString(5);
                    int key_seq = this.showObjectResultSet.getInt(6);
                    String pk_name = this.showObjectResultSet.getString(7);
                    if (catalogIn != null && !catalogIn.equals(table_cat) || schemaIn != null && !schemaIn.equals(table_schem) || tableIn != null && !tableIn.equals(table_name)) continue;
                    this.nextRow[0] = table_cat;
                    this.nextRow[1] = table_schem;
                    this.nextRow[2] = table_name;
                    this.nextRow[3] = column_name;
                    this.nextRow[4] = key_seq;
                    this.nextRow[5] = pk_name;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    private ResultSet getForeignKeys(final String client, String parentCatalog, String parentSchema, final String parentTable, final String foreignCatalog, final String foreignSchema, final String foreignTable) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        StringBuilder commandBuilder = new StringBuilder();
        SFPair<String, String> resPair = this.applySessionContext(parentCatalog, parentSchema);
        parentCatalog = (String)resPair.left;
        parentSchema = (String)resPair.right;
        if (client.equals("export") || client.equals("cross")) {
            commandBuilder.append("show /* JDBC:DatabaseMetaData.getForeignKeys() */ exported keys in ");
        } else if (client.equals("import")) {
            commandBuilder.append("show /* JDBC:DatabaseMetaData.getForeignKeys() */ imported keys in ");
        }
        if (parentCatalog == null) {
            commandBuilder.append("account");
        } else {
            if (parentCatalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, statement);
            }
            if (parentSchema == null) {
                commandBuilder.append("database \"" + parentCatalog + "\"");
            } else {
                if (parentSchema.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, statement);
                }
                if (parentTable == null) {
                    commandBuilder.append("schema \"" + parentCatalog + "\".\"" + parentSchema + "\"");
                } else {
                    if (parentTable.isEmpty()) {
                        return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, statement);
                    }
                    commandBuilder.append("table \"" + parentCatalog + "\".\"" + parentSchema + "\".\"" + parentTable + "\"");
                }
            }
        }
        final String finalParentCatalog = parentCatalog;
        final String finalParentSchema = parentSchema;
        String command = commandBuilder.toString();
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, command, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String pktable_cat = this.showObjectResultSet.getString(2);
                    String pktable_schem = this.showObjectResultSet.getString(3);
                    String pktable_name = this.showObjectResultSet.getString(4);
                    String pkcolumn_name = this.showObjectResultSet.getString(5);
                    String fktable_cat = this.showObjectResultSet.getString(6);
                    String fktable_schem = this.showObjectResultSet.getString(7);
                    String fktable_name = this.showObjectResultSet.getString(8);
                    String fkcolumn_name = this.showObjectResultSet.getString(9);
                    int key_seq = this.showObjectResultSet.getInt(10);
                    short updateRule = SnowflakeDatabaseMetaData.this.getForeignKeyConstraintProperty("update", this.showObjectResultSet.getString(11));
                    short deleteRule = SnowflakeDatabaseMetaData.this.getForeignKeyConstraintProperty("delete", this.showObjectResultSet.getString(12));
                    String fk_name = this.showObjectResultSet.getString(13);
                    String pk_name = this.showObjectResultSet.getString(14);
                    short deferrability = SnowflakeDatabaseMetaData.this.getForeignKeyConstraintProperty("deferrability", this.showObjectResultSet.getString(15));
                    boolean passedFilter = false;
                    if (client.equals("import")) {
                        if (!(finalParentCatalog != null && !finalParentCatalog.equals(fktable_cat) || finalParentSchema != null && !finalParentSchema.equals(fktable_schem) || parentTable != null && !parentTable.equals(fktable_name))) {
                            passedFilter = true;
                        }
                    } else if (client.equals("export")) {
                        if (!(finalParentCatalog != null && !finalParentCatalog.equals(pktable_cat) || finalParentSchema != null && !finalParentSchema.equals(pktable_schem) || parentTable != null && !parentTable.equals(pktable_name))) {
                            passedFilter = true;
                        }
                    } else if (!(!client.equals("cross") || finalParentCatalog != null && !finalParentCatalog.equals(pktable_cat) || finalParentSchema != null && !finalParentSchema.equals(pktable_schem) || parentTable != null && !parentTable.equals(pktable_name) || foreignCatalog != null && !foreignCatalog.equals(fktable_cat) || foreignSchema != null && !foreignSchema.equals(fktable_schem) || foreignTable != null && !foreignTable.equals(fktable_name))) {
                        passedFilter = true;
                    }
                    if (!passedFilter) continue;
                    this.nextRow[0] = pktable_cat;
                    this.nextRow[1] = pktable_schem;
                    this.nextRow[2] = pktable_name;
                    this.nextRow[3] = pkcolumn_name;
                    this.nextRow[4] = fktable_cat;
                    this.nextRow[5] = fktable_schem;
                    this.nextRow[6] = fktable_name;
                    this.nextRow[7] = fkcolumn_name;
                    this.nextRow[8] = key_seq;
                    this.nextRow[9] = updateRule;
                    this.nextRow[10] = deleteRule;
                    this.nextRow[11] = fk_name;
                    this.nextRow[12] = pk_name;
                    this.nextRow[13] = deferrability;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    private short getForeignKeyConstraintProperty(String property_name, String property) {
        int result = 0;
        block5 : switch (property_name) {
            case "update": 
            case "delete": {
                switch (property) {
                    case "NO ACTION": {
                        result = 3;
                        break;
                    }
                    case "CASCADE": {
                        result = 0;
                        break;
                    }
                    case "SET NULL": {
                        result = 2;
                        break;
                    }
                    case "SET DEFAULT": {
                        result = 4;
                        break;
                    }
                    case "RESTRICT": {
                        result = 1;
                    }
                }
                break;
            }
            case "deferrability": {
                switch (property) {
                    case "INITIALLY DEFERRED": {
                        result = 5;
                        break block5;
                    }
                    case "INITIALLY IMMEDIATE": {
                        result = 6;
                        break block5;
                    }
                    case "NOT DEFERRABLE": {
                        result = 7;
                    }
                }
            }
        }
        return (short)result;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        logger.debug("public ResultSet getImportedKeys(String catalog={}, String schema={}, String table={})", catalog, schema, table);
        SFPair<String, String> resPair = this.applySessionContext(catalog, schema);
        catalog = (String)resPair.left;
        schema = (String)resPair.right;
        return this.getForeignKeys("import", catalog, schema, table, null, null, null);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        logger.debug("public ResultSet getExportedKeys(String catalog={}, String schema={}, String table={})", catalog, schema, table);
        SFPair<String, String> resPair = this.applySessionContext(catalog, schema);
        catalog = (String)resPair.left;
        schema = (String)resPair.right;
        return this.getForeignKeys("export", catalog, schema, table, null, null, null);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        logger.debug("public ResultSet getCrossReference(String parentCatalog={}, String parentSchema={}, String parentTable={}, String foreignCatalog={}, String foreignSchema={}, String foreignTable={})", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        SFPair<String, String> resPair = this.applySessionContext(parentCatalog, parentSchema);
        parentCatalog = (String)resPair.left;
        parentSchema = (String)resPair.right;
        return this.getForeignKeys("cross", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        logger.debug("public ResultSet getTypeInfo()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"), Arrays.asList("TEXT", "INTEGER", "INTEGER", "TEXT", "TEXT", "TEXT", "SHORT", "BOOLEAN", "SHORT", "BOOLEAN", "BOOLEAN", "BOOLEAN", "TEXT", "SHORT", "SHORT", "INTEGER", "INTEGER", "INTEGER"), Arrays.asList(12, 4, 4, 12, 12, 12, 5, 16, 5, 16, 16, 16, 12, 5, 5, 4, 4, 4), new Object[][]{{"NUMBER", 3, 38, null, null, null, 1, false, 3, false, true, true, null, 0, 37, -1, -1, -1}, {"INTEGER", 4, 38, null, null, null, 1, false, 3, false, true, true, null, 0, 0, -1, -1, -1}, {"DOUBLE", 8, 38, null, null, null, 1, false, 3, false, true, true, null, 0, 37, -1, -1, -1}, {"VARCHAR", 12, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"DATE", 91, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"TIME", 92, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"TIMESTAMP", 93, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"BOOLEAN", 16, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}}, statement);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        logger.debug("public ResultSet getIndexInfo(String catalog, String schema, String table,boolean unique, boolean approximate)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"), Arrays.asList("TEXT", "TEXT", "TEXT", "BOOLEAN", "TEXT", "TEXT", "SHORT", "SHORT", "TEXT", "TEXT", "INTEGER", "INTEGER", "TEXT"), Arrays.asList(12, 12, 12, 16, 12, 12, 5, 5, 12, 12, 4, 4, 12), new Object[0][], statement);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        logger.debug("public boolean supportsResultSetType(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        logger.debug("public boolean supportsResultSetConcurrency(int type, int concurrency)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        logger.debug("public boolean ownUpdatesAreVisible(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        logger.debug("public boolean ownDeletesAreVisible(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        logger.debug("public boolean ownInsertsAreVisible(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        logger.debug("public boolean othersUpdatesAreVisible(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        logger.debug("public boolean othersDeletesAreVisible(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        logger.debug("public boolean othersInsertsAreVisible(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        logger.debug("public boolean updatesAreDetected(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        logger.debug("public boolean deletesAreDetected(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        logger.debug("public boolean insertsAreDetected(int type)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        logger.debug("public boolean supportsBatchUpdates()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        logger.debug("public ResultSet getUDTs(String catalog, String schemaPattern,String typeNamePattern, int[] types)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"), Arrays.asList("TEXT", "TEXT", "TEXT", "TEXT", "INTEGER", "TEXT", "SHORT"), Arrays.asList(12, 12, 12, 12, 4, 12, 5), new Object[0][], statement);
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.debug("public Connection getConnection()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        logger.debug("public boolean supportsSavepoints()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        logger.debug("public boolean supportsNamedParameters()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        logger.debug("public boolean supportsMultipleOpenResults()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        logger.debug("public boolean supportsGetGeneratedKeys()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        logger.debug("public ResultSet getSuperTypes(String catalog, String schemaPattern,String typeNamePattern)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        logger.debug("public ResultSet getSuperTables(String catalog, String schemaPattern,String tableNamePattern)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        logger.debug("public ResultSet getAttributes(String catalog, String schemaPattern,String typeNamePattern,String attributeNamePattern)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        logger.debug("public boolean supportsResultSetHoldability(int holdability)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        logger.debug("public int getResultSetHoldability()");
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        logger.debug("public int getDatabaseMajorVersion()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection.unwrap(SnowflakeConnectionV1.class).getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        logger.debug("public int getDatabaseMinorVersion()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection.unwrap(SnowflakeConnectionV1.class).getDatabaseMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        logger.debug("public int getJDBCMajorVersion()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Integer.parseInt(JDBCVersion.split("\\.", 2)[0]);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        logger.debug("public int getJDBCMinorVersion()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Integer.parseInt(JDBCVersion.split("\\.", 2)[1]);
    }

    @Override
    public int getSQLStateType() throws SQLException {
        logger.debug("public int getSQLStateType()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        logger.debug("public boolean locatorsUpdateCopy()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        logger.debug("public boolean supportsStatementPooling()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        logger.debug("public RowIdLifetime getRowIdLifetime()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        logger.debug("public ResultSet getSchemas(String catalog={}, String schemaPattern={})", catalog, schemaPattern);
        this.raiseSQLExceptionIfConnectionIsClosed();
        SFPair<String, String> resPair = this.applySessionContext(catalog, schemaPattern);
        catalog = (String)resPair.left;
        schemaPattern = (String)resPair.right;
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        String showSchemas = "show /* JDBC:DatabaseMetaData.getSchemas() */ schemas";
        Statement statement = this.connection.createStatement();
        if (!(schemaPattern == null || schemaPattern.isEmpty() || schemaPattern.trim().equals("%") || schemaPattern.trim().equals(".*"))) {
            showSchemas = showSchemas + " like '" + schemaPattern + "'";
        }
        if (catalog == null) {
            showSchemas = showSchemas + " in account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_SCHEMAS, statement);
            }
            showSchemas = showSchemas + " in database \"" + catalog + "\"";
        }
        logger.debug("sql command to get schemas metadata: {}", showSchemas);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showSchemas, DBMetadataResultSetMetadata.GET_SCHEMAS);
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_SCHEMAS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String schemaName = this.showObjectResultSet.getString(2);
                    String dbName = this.showObjectResultSet.getString(5);
                    if (compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches()) continue;
                    this.nextRow[0] = schemaName;
                    this.nextRow[1] = dbName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        logger.debug("public boolean supportsStoredFunctionsUsingCallSyntax()");
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        logger.debug("public boolean autoCommitFailureClosesAllResultSets()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        logger.debug("public ResultSet getClientInfoProperties()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        logger.debug("public ResultSet getFunctions(String catalog={}, String schemaPattern={}, String functionNamePattern={}", catalog, schemaPattern, functionNamePattern);
        String showFunctionCommand = this.getFirstResultSetCommand(catalog, schemaPattern, functionNamePattern, "functions");
        if (showFunctionCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FUNCTIONS, statement);
        }
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledFunctionPattern = Wildcard.toRegexPattern(functionNamePattern, true);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showFunctionCommand, DBMetadataResultSetMetadata.GET_FUNCTIONS);
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_FUNCTIONS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.debug("public boolean next()");
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String catalogName = this.showObjectResultSet.getString(11);
                    String schemaName = this.showObjectResultSet.getString(3);
                    String functionName = this.showObjectResultSet.getString(2);
                    String remarks = this.showObjectResultSet.getString(10);
                    int functionType = "Y".equals(this.showObjectResultSet.getString(12)) ? 2 : 1;
                    String specificName = functionName;
                    if (compiledFunctionPattern != null && !compiledFunctionPattern.matcher(functionName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches()) continue;
                    logger.debug("Found a matched function:" + schemaName + "." + functionName);
                    this.nextRow[0] = catalogName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = functionName;
                    this.nextRow[3] = remarks;
                    this.nextRow[4] = functionType;
                    this.nextRow[5] = specificName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    private String[] parseParams(String args) {
        String chopped = args.substring(args.indexOf(40) + 1, args.lastIndexOf(41));
        String[] params = chopped.split("\\s+|, ");
        return params;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        logger.debug("public ResultSet getFunctionColumns(String catalog, String schemaPattern,String functionNamePattern,String columnNamePattern)");
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        boolean addAllRows = false;
        String showFunctionCommand = this.getFirstResultSetCommand(catalog, schemaPattern, functionNamePattern, "functions");
        if (showFunctionCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS, statement);
        }
        if (columnNamePattern == null || columnNamePattern.isEmpty() || columnNamePattern.trim().equals("%") || columnNamePattern.trim().equals(".*")) {
            addAllRows = true;
        }
        ResultSet resultSetStepOne = this.executeAndReturnEmptyResultIfNotFound(statement, showFunctionCommand, DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (resultSetStepOne.next()) {
            int i;
            String functionNameUnparsed = resultSetStepOne.getString("arguments").trim();
            String functionNameNoArgs = resultSetStepOne.getString("name");
            String showFunctionColCommand = this.getSecondResultSetCommand(catalog, schemaPattern, functionNameUnparsed, "function");
            ResultSet resultSetStepTwo = this.executeAndReturnEmptyResultIfNotFound(statement, showFunctionColCommand, DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS);
            resultSetStepTwo.next();
            String[] params = this.parseParams(resultSetStepTwo.getString("value"));
            resultSetStepTwo.next();
            String res = resultSetStepTwo.getString("value");
            String[] paramNames = new String[params.length / 2 + 1];
            String[] paramTypes = new String[params.length / 2 + 1];
            if (params.length > 1) {
                for (i = 0; i < params.length; ++i) {
                    if (i % 2 == 0) {
                        paramNames[i / 2 + 1] = params[i];
                        continue;
                    }
                    paramTypes[i / 2 + 1] = params[i];
                }
            }
            paramNames[0] = "";
            paramTypes[0] = res;
            for (i = 0; i < paramNames.length; ++i) {
                if (i != 0 && !paramNames[i].equalsIgnoreCase(columnNamePattern) && !addAllRows) continue;
                Object[] nextRow = new Object[17];
                nextRow[0] = catalog;
                nextRow[1] = schemaPattern;
                nextRow[2] = functionNameNoArgs;
                nextRow[3] = paramNames[i];
                nextRow[4] = i == 0 ? (paramTypes[i].substring(0, 5).equalsIgnoreCase("table") ? Integer.valueOf(3) : Integer.valueOf(4)) : Integer.valueOf(1);
                String typeName = paramTypes[i];
                int type = SnowflakeType.convertStringToType(typeName);
                nextRow[5] = type;
                nextRow[6] = typeName;
                int precision = 38;
                short scale = 0;
                if (type < 10) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        precision = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(44)));
                        scale = Short.parseShort(typeName.substring(typeName.indexOf(44) + 1, typeName.indexOf(41)));
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    } else if (type == 6) {
                        nextRow[7] = 0;
                        nextRow[9] = null;
                    } else {
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    }
                } else {
                    nextRow[7] = 0;
                    nextRow[9] = null;
                }
                nextRow[8] = 0;
                nextRow[10] = 10;
                nextRow[11] = 2;
                nextRow[12] = resultSetStepOne.getString("description").trim();
                if (type == -2 || type == -3 || type == 1 || type == 12) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        int char_octet_len = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(41)));
                        nextRow[13] = char_octet_len;
                    } else if (type == 1 || type == 12) {
                        nextRow[13] = 0x1000000;
                    } else if (type == -2 || type == -3) {
                        nextRow[13] = 0x800000;
                    }
                } else {
                    nextRow[13] = null;
                }
                nextRow[14] = i;
                nextRow[15] = "";
                nextRow[16] = functionNameUnparsed;
                rows.add(nextRow);
            }
        }
        Object[][] resultRows = new Object[rows.size()][17];
        for (int i = 0; i < resultRows.length; ++i) {
            resultRows[i] = (Object[])rows.get(i);
        }
        return new SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS, resultRows, statement);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        logger.debug("public ResultSet getPseudoColumns(String catalog, String schemaPattern,String tableNamePattern,String columnNamePattern)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        logger.debug("public boolean generatedKeyAlwaysReturned()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)");
        throw new SQLFeatureNotSupportedException();
    }

    private ResultSet executeAndReturnEmptyResultIfNotFound(Statement statement, String sql, DBMetadataResultSetMetadata metadataType) throws SQLException {
        ResultSet resultSet;
        try {
            resultSet = statement.executeQuery(sql);
        }
        catch (SnowflakeSQLException e) {
            if (e.getSQLState().equals("02000") || e.getSQLState().equals("42S02")) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(metadataType, statement);
            }
            throw e;
        }
        return resultSet;
    }
}

