/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http.conn;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.snowflake.client.jdbc.internal.amazonaws.http.conn.Wrapped;
import net.snowflake.client.jdbc.internal.amazonaws.metrics.AwsSdkMetrics;
import net.snowflake.client.jdbc.internal.amazonaws.metrics.ServiceLatencyProvider;
import net.snowflake.client.jdbc.internal.amazonaws.metrics.ServiceMetricCollector;
import net.snowflake.client.jdbc.internal.amazonaws.util.AWSServiceMetrics;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.ConnectionRequest;

class ClientConnectionRequestFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionRequestFactory.class);
    private static final Class<?>[] interfaces = new Class[]{ConnectionRequest.class, Wrapped.class};

    ClientConnectionRequestFactory() {
    }

    static ConnectionRequest wrap(ConnectionRequest orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        return (ConnectionRequest)Proxy.newProxyInstance(ClientConnectionRequestFactory.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final ConnectionRequest orig;

        Handler(ConnectionRequest orig) {
            this.orig = orig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!"get".equals(method.getName())) return method.invoke((Object)this.orig, args);
            ServiceLatencyProvider latencyProvider = new ServiceLatencyProvider(AWSServiceMetrics.HttpClientGetConnectionTime);
            try {
                Object object = method.invoke((Object)this.orig, args);
                ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(latencyProvider.endTiming());
                return object;
            }
            catch (Throwable throwable) {
                try {
                    ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(latencyProvider.endTiming());
                    throw throwable;
                }
                catch (InvocationTargetException e) {
                    log.debug("", e);
                    throw e.getCause();
                }
            }
        }
    }
}

