/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.CredentialManager;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.core.SessionUtilKeyPair;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.message.BasicHeader;
import net.snowflake.client.jdbc.internal.apache.http.message.HeaderGroup;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.org.jsoup.Jsoup;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Document;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Element;
import net.snowflake.client.jdbc.internal.org.jsoup.select.Elements;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnDTO;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnParameter;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SessionUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SessionUtil.class);
    private static final String SF_QUERY_DATABASE = "databaseName";
    private static final String SF_QUERY_SCHEMA = "schemaName";
    private static final String SF_QUERY_WAREHOUSE = "warehouse";
    private static final String SF_QUERY_ROLE = "roleName";
    private static final String SF_PATH_LOGIN_REQUEST = "/session/v1/login-request";
    private static final String SF_PATH_TOKEN_REQUEST = "/session/token-request";
    protected static final String SF_PATH_AUTHENTICATOR_REQUEST = "/session/authenticator-request";
    public static final String SF_QUERY_SESSION_DELETE = "delete";
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_BASIC_AUTHTYPE = "Basic";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    public static final String CLIENT_STORE_TEMPORARY_CREDENTIAL = "CLIENT_STORE_TEMPORARY_CREDENTIAL";
    public static final String SERVICE_NAME = "SERVICE_NAME";
    public static final String CLIENT_IN_BAND_TELEMETRY_ENABLED = "CLIENT_TELEMETRY_ENABLED";
    public static final String CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED = "CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED";
    public static final String CLIENT_RESULT_COLUMN_CASE_INSENSITIVE = "CLIENT_RESULT_COLUMN_CASE_INSENSITIVE";
    public static final String JDBC_RS_COLUMN_CASE_INSENSITIVE = "JDBC_RS_COLUMN_CASE_INSENSITIVE";
    public static final String CLIENT_RESULT_CHUNK_SIZE_JVM = "net.snowflake.jdbc.clientResultChunkSize";
    public static final String CLIENT_RESULT_CHUNK_SIZE = "CLIENT_RESULT_CHUNK_SIZE";
    public static final String CLIENT_MEMORY_LIMIT_JVM = "net.snowflake.jdbc.clientMemoryLimit";
    public static final String CLIENT_MEMORY_LIMIT = "CLIENT_MEMORY_LIMIT";
    public static final String CLIENT_PREFETCH_THREADS_JVM = "net.snowflake.jdbc.clientPrefetchThreads";
    public static final String CLIENT_PREFETCH_THREADS = "CLIENT_PREFETCH_THREADS";
    public static final String CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE_JVM = "net.snowflake.jdbc.clientEnableConservativeMemoryUsage";
    public static final String CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE = "CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE";
    public static final String CACHE_FILE_NAME = "temporary_credential.json";
    public static final String OCSP_FAIL_OPEN_JVM = "net.snowflake.jdbc.ocspFailOpen";
    public static final String OCSP_FAIL_OPEN = "ocspFailOpen";
    public static final String CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY = "CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY";
    public static final String CLIENT_SFSQL = "CLIENT_SFSQL";
    static final String SF_HEADER_SERVICE_NAME = "X-Snowflake-Service";
    private static final String SF_PATH_SESSION = "/session";
    public static long DEFAULT_CLIENT_MEMORY_LIMIT = 1536L;
    public static int DEFAULT_CLIENT_PREFETCH_THREADS = 4;
    public static int DEFAULT_CLIENT_CHUNK_SIZE = 160;
    public static int MIN_CLIENT_CHUNK_SIZE = 48;
    public static int MAX_CLIENT_CHUNK_SIZE = 160;
    public static Map<String, String> JVM_PARAMS_TO_PARAMS = Stream.of({"net.snowflake.jdbc.clientResultChunkSize", "CLIENT_RESULT_CHUNK_SIZE"}, {"net.snowflake.jdbc.clientMemoryLimit", "CLIENT_MEMORY_LIMIT"}, {"net.snowflake.jdbc.clientPrefetchThreads", "CLIENT_PREFETCH_THREADS"}, {"net.snowflake.jdbc.ocspFailOpen", "ocspFailOpen"}, {"net.snowflake.jdbc.clientEnableConservativeMemoryUsage", "CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    private static ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private static int DEFAULT_HEALTH_CHECK_INTERVAL = 45;
    private static Set<String> STRING_PARAMS = new HashSet<String>(Arrays.asList("TIMEZONE", "TIMESTAMP_OUTPUT_FORMAT", "TIMESTAMP_NTZ_OUTPUT_FORMAT", "TIMESTAMP_LTZ_OUTPUT_FORMAT", "TIMESTAMP_TZ_OUTPUT_FORMAT", "DATE_OUTPUT_FORMAT", "TIME_OUTPUT_FORMAT", "BINARY_OUTPUT_FORMAT", "CLIENT_TIMESTAMP_TYPE_MAPPING", "SERVICE_NAME"));
    private static final Set<String> INT_PARAMS = new HashSet<String>(Arrays.asList("CLIENT_RESULT_PREFETCH_SLOTS", "CLIENT_RESULT_PREFETCH_THREADS", "CLIENT_PREFETCH_THREADS", "CLIENT_MEMORY_LIMIT", "CLIENT_RESULT_CHUNK_SIZE", "CLIENT_STAGE_ARRAY_BINDING_THRESHOLD", "CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY"));
    private static final Set<String> BOOLEAN_PARAMS = new HashSet<String>(Arrays.asList("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", "CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ", "CLIENT_DISABLE_INCIDENTS", "CLIENT_SESSION_KEEP_ALIVE", "CLIENT_TELEMETRY_ENABLED", "CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED", "CLIENT_STORE_TEMPORARY_CREDENTIAL", "JDBC_USE_JSON_PARSER", "AUTOCOMMIT", "JDBC_EFFICIENT_CHUNK_STORAGE", "JDBC_RS_COLUMN_CASE_INSENSITIVE", "CLIENT_RESULT_COLUMN_CASE_INSENSITIVE", "CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX", "JDBC_TREAT_DECIMAL_AS_INT", "JDBC_ENABLE_COMBINED_DESCRIBE", "CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE"));

    private static ClientAuthnDTO.AuthenticatorType getAuthenticator(SFLoginInput loginInput) {
        if (loginInput.getAuthenticator() != null) {
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name())) {
                return ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER;
            }
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.OAUTH.name())) {
                return ClientAuthnDTO.AuthenticatorType.OAUTH;
            }
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT.name())) {
                return ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT;
            }
            if (!loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.name())) {
                return ClientAuthnDTO.AuthenticatorType.OKTA;
            }
        }
        return loginInput.getPrivateKey() != null ? ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT : ClientAuthnDTO.AuthenticatorType.SNOWFLAKE;
    }

    public static SFLoginOutput openSession(SFLoginInput loginInput) throws SFException, SnowflakeSQLException {
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for opening session");
        AssertUtil.assertTrue(loginInput.getAppId() != null, "missing app id for opening session");
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for opening session");
        ClientAuthnDTO.AuthenticatorType authenticator = SessionUtil.getAuthenticator(loginInput);
        if (!authenticator.equals((Object)ClientAuthnDTO.AuthenticatorType.OAUTH)) {
            AssertUtil.assertTrue(loginInput.getUserName() != null, "missing user name for opening session");
        }
        if (authenticator.equals((Object)ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER)) {
            loginInput.getSessionParameters().put(CLIENT_STORE_TEMPORARY_CREDENTIAL, true);
        } else {
            Object value = loginInput.getSessionParameters().get(CLIENT_STORE_TEMPORARY_CREDENTIAL);
            if (value != null) {
                loginInput.getSessionParameters().put(CLIENT_STORE_TEMPORARY_CREDENTIAL, SessionUtil.asBoolean(value));
            }
        }
        boolean isClientStoreTemporaryCredential = SessionUtil.asBoolean(loginInput.getSessionParameters().get(CLIENT_STORE_TEMPORARY_CREDENTIAL));
        if (isClientStoreTemporaryCredential && CredentialManager.getInstance().fillCachedIdToken(loginInput)) {
            try {
                return SessionUtil.issueSession(loginInput);
            }
            catch (SnowflakeReauthenticationRequest ex) {
                logger.debug("The token expired. errorCode. Reauthenticating...");
            }
        }
        return SessionUtil.newSession(loginInput);
    }

    private static boolean asBoolean(Object value) {
        if (value == null) {
            return false;
        }
        switch (value.getClass().getName()) {
            case "java.lang.Boolean": {
                return (Boolean)value;
            }
            case "java.lang.String": {
                return Boolean.valueOf((String)value);
            }
        }
        return false;
    }

    private static SFLoginOutput newSession(SFLoginInput loginInput) throws SFException, SnowflakeSQLException {
        Map<String, Object> commonParams;
        String sessionWarehouse;
        String sessionRole;
        String sessionSchema;
        String sessionDatabase;
        long masterTokenValidityInSeconds;
        String idToken;
        String masterToken;
        String sessionToken;
        URI loginURI;
        String tokenOrSamlResponse = null;
        String samlProofKey = null;
        boolean consentCacheIdToken = true;
        String databaseVersion = null;
        int databaseMajorVersion = 0;
        int databaseMinorVersion = 0;
        String newClientForUpgrade = null;
        int healthCheckInterval = DEFAULT_HEALTH_CHECK_INTERVAL;
        int httpClientSocketTimeout = loginInput.getSocketTimeout();
        ClientAuthnDTO.AuthenticatorType authenticator = SessionUtil.getAuthenticator(loginInput);
        try {
            Object s;
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            if (loginInput.getDatabaseName() != null) {
                uriBuilder.addParameter(SF_QUERY_DATABASE, loginInput.getDatabaseName());
            }
            if (loginInput.getSchemaName() != null) {
                uriBuilder.addParameter(SF_QUERY_SCHEMA, loginInput.getSchemaName());
            }
            if (loginInput.getWarehouse() != null) {
                uriBuilder.addParameter(SF_QUERY_WAREHOUSE, loginInput.getWarehouse());
            }
            if (loginInput.getRole() != null) {
                uriBuilder.addParameter(SF_QUERY_ROLE, loginInput.getRole());
            }
            if (authenticator == ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER) {
                s = SessionUtilExternalBrowser.createInstance(loginInput);
                ((SessionUtilExternalBrowser)s).authenticate();
                tokenOrSamlResponse = ((SessionUtilExternalBrowser)s).getToken();
                samlProofKey = ((SessionUtilExternalBrowser)s).getProofKey();
                consentCacheIdToken = ((SessionUtilExternalBrowser)s).isConsentCacheIdToken();
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.OKTA) {
                tokenOrSamlResponse = SessionUtil.getSamlResponseUsingOkta(loginInput);
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT) {
                s = new SessionUtilKeyPair(loginInput.getPrivateKey(), loginInput.getAccountName(), loginInput.getUserName());
                loginInput.setToken(((SessionUtilKeyPair)s).issueJwtToken());
            }
            uriBuilder.addParameter("requestId", UUID.randomUUID().toString());
            uriBuilder.setPath(SF_PATH_LOGIN_REQUEST);
            loginURI = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            logger.error("Exception when building URL", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:1");
        }
        if (loginInput.getServerUrl().indexOf(".privatelink.snowflakecomputing.com") > 0) {
            try {
                URL url = new URL(loginInput.getServerUrl());
                String host = url.getHost();
                logger.debug("HOST: {}", host);
                String ocspCacheServerUrl = String.format("http://ocsp%s/%s", host.substring(host.indexOf(46)), "ocsp_response_cache.json");
                logger.debug("OCSP Cache Server for Privatelink: {}", ocspCacheServerUrl);
                SFTrustManager.resetOCSPResponseCacherServerURL(ocspCacheServerUrl);
            }
            catch (IOException ex) {
                throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URL syntax exception");
            }
        }
        HttpPost postRequest = null;
        try {
            String clientInfoJSONStr;
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), loginInput.getAppId());
            data.put(ClientAuthnParameter.LOGIN_NAME.name(), loginInput.getUserName());
            if (authenticator == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE) {
                data.put(ClientAuthnParameter.PASSWORD.name(), loginInput.getPassword());
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER) {
                data.put(ClientAuthnParameter.AUTHENTICATOR.name(), ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name());
                data.put(ClientAuthnParameter.PROOF_KEY.name(), samlProofKey);
                data.put(ClientAuthnParameter.TOKEN.name(), tokenOrSamlResponse);
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.OKTA) {
                data.put(ClientAuthnParameter.RAW_SAML_RESPONSE.name(), tokenOrSamlResponse);
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.OAUTH || authenticator == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT) {
                data.put(ClientAuthnParameter.AUTHENTICATOR.name(), authenticator.name());
                data.put(ClientAuthnParameter.TOKEN.name(), loginInput.getToken());
            }
            HashMap<String, String> clientEnv = new HashMap<String, String>();
            clientEnv.put("OS", System.getProperty("os.name"));
            clientEnv.put("OS_VERSION", System.getProperty("os.version"));
            clientEnv.put("JAVA_VERSION", System.getProperty("java.version"));
            clientEnv.put("JAVA_RUNTIME", System.getProperty("java.runtime.name"));
            clientEnv.put("JAVA_VM", System.getProperty("java.vm.name"));
            clientEnv.put("OCSP_MODE", loginInput.getOCSPMode().name());
            if (loginInput.getApplication() != null) {
                clientEnv.put("APPLICATION", loginInput.getApplication());
            } else {
                String appName = System.getProperty("sun.java.command");
                if (appName != null) {
                    if (appName.indexOf(" ") > 0) {
                        appName = appName.substring(0, appName.indexOf(" "));
                    }
                    clientEnv.put("APPLICATION", appName);
                }
            }
            Properties clientInfo = loginInput.getClientInfo();
            if (clientInfo != null) {
                for (Map.Entry<Object, Object> property : clientInfo.entrySet()) {
                    if (property == null || property.getKey() == null || property.getValue() == null) continue;
                    clientEnv.put(property.getKey().toString(), property.getValue().toString());
                }
            }
            if ((clientInfoJSONStr = System.getProperty("snowflake.client.info")) != null) {
                JsonNode clientInfoJSON = null;
                try {
                    clientInfoJSON = mapper.readTree(clientInfoJSONStr);
                }
                catch (Throwable ex) {
                    logger.debug("failed to process snowflake.client.info property as JSON: {}", clientInfoJSONStr, ex);
                }
                if (clientInfoJSON != null) {
                    Iterator<Map.Entry<String, JsonNode>> fields = clientInfoJSON.fields();
                    while (fields.hasNext()) {
                        Map.Entry<String, JsonNode> field = fields.next();
                        clientEnv.put(field.getKey(), field.getValue().asText());
                    }
                }
            }
            data.put(ClientAuthnParameter.CLIENT_ENVIRONMENT.name(), clientEnv);
            Map<String, Object> sessionParameter = loginInput.getSessionParameters();
            if (sessionParameter != null) {
                data.put(ClientAuthnParameter.SESSION_PARAMETERS.name(), loginInput.getSessionParameters());
            }
            if (loginInput.getAccountName() != null) {
                data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            }
            if (loginInput.isPasscodeInPassword()) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
            } else if (loginInput.getPasscode() != null) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
                data.put(ClientAuthnParameter.PASSCODE.name(), loginInput.getPasscode());
            } else {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "push");
            }
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), loginInput.getAppVersion());
            authnData.setData(data);
            String json = mapper.writeValueAsString(authnData);
            postRequest = new HttpPost(loginURI);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, SF_HEADER_BASIC_AUTHTYPE);
            SessionUtil.setServiceNameHeader(loginInput, postRequest);
            String theString = HttpUtil.executeRequest(postRequest, loginInput.getLoginTimeout(), 0, null);
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("response = {}", theString);
                String errorCode = jsonNode.path("code").asText();
                throw new SnowflakeSQLException("08001", ErrorCode.CONNECTION_ERROR.getMessageCode(), errorCode, jsonNode.path("message").asText());
            }
            sessionToken = jsonNode.path("data").path("token").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
            idToken = SessionUtil.nullStringAsEmptyString(jsonNode.path("data").path("idToken").asText());
            masterTokenValidityInSeconds = jsonNode.path("data").path("masterValidityInSeconds").asLong();
            String serverVersion = jsonNode.path("data").path("serverVersion").asText();
            JsonNode dbNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_DATABASE);
            sessionDatabase = dbNode.isNull() ? null : dbNode.asText();
            JsonNode schemaNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_SCHEMA);
            sessionSchema = schemaNode.isNull() ? null : schemaNode.asText();
            JsonNode roleNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_ROLE);
            sessionRole = roleNode.isNull() ? null : roleNode.asText();
            JsonNode warehouseNode = jsonNode.path("data").path("sessionInfo").path("warehouseName");
            sessionWarehouse = warehouseNode.isNull() ? null : warehouseNode.asText();
            commonParams = SessionUtil.getCommonParams(jsonNode.path("data").path("parameters"));
            if (serverVersion != null) {
                logger.debug("server version = {}", serverVersion);
                databaseVersion = serverVersion.indexOf(" ") > 0 ? serverVersion.substring(0, serverVersion.indexOf(" ")) : serverVersion;
            } else {
                logger.debug("server version is null");
            }
            if (databaseVersion != null) {
                String[] components = databaseVersion.split("\\.");
                if (components != null && components.length >= 2) {
                    try {
                        databaseMajorVersion = Integer.parseInt(components[0]);
                        databaseMinorVersion = Integer.parseInt(components[1]);
                    }
                    catch (Exception ex) {
                        logger.error("Exception encountered when parsing server version: {} Exception: {}", databaseVersion, ex.getMessage());
                    }
                }
            } else {
                logger.debug("database version is null");
            }
            if (!jsonNode.path("data").path("newClientForUpgrade").isNull()) {
                newClientForUpgrade = jsonNode.path("data").path("newClientForUpgrade").asText();
                logger.debug("new client: {}", newClientForUpgrade);
            }
            int healthCheckIntervalFromGS = jsonNode.path("data").path("healthCheckInterval").asInt();
            logger.debug("health check interval = {}", healthCheckIntervalFromGS);
            if (healthCheckIntervalFromGS > 0 && healthCheckIntervalFromGS != healthCheckInterval) {
                httpClientSocketTimeout = loginInput.getSocketTimeout() + healthCheckIntervalFromGS * 1000;
                RequestConfig requestConfig = RequestConfig.copy(HttpUtil.getRequestConfigWithoutcookies()).setConnectTimeout(loginInput.getConnectionTimeout()).setSocketTimeout(httpClientSocketTimeout).build();
                HttpUtil.setRequestConfig(requestConfig);
                logger.debug("adjusted connection timeout to = {}", loginInput.getConnectionTimeout());
                logger.debug("adjusted socket timeout to = {}", httpClientSocketTimeout);
            }
        }
        catch (SnowflakeSQLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.error("IOException when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException(ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        catch (Throwable ex) {
            logger.error("Exception when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException(ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
        }
        SFLoginOutput ret = new SFLoginOutput(sessionToken, masterToken, masterTokenValidityInSeconds, idToken, databaseVersion, databaseMajorVersion, databaseMinorVersion, httpClientSocketTimeout, sessionDatabase, sessionSchema, sessionRole, sessionWarehouse, commonParams);
        ret.setUpdatedByTokenRequest(false);
        if (consentCacheIdToken) {
            CredentialManager.getInstance().writeTemporaryCredential(loginInput, ret);
        }
        return ret;
    }

    private static void setServiceNameHeader(SFLoginInput loginInput, HttpPost postRequest) {
        if (!Strings.isNullOrEmpty(loginInput.getServiceName())) {
            postRequest.setHeader(SF_HEADER_SERVICE_NAME, loginInput.getServiceName());
        }
    }

    private static String nullStringAsEmptyString(String value) {
        if (Strings.isNullOrEmpty(value) || "null".equals(value)) {
            return "";
        }
        return value;
    }

    public static void deleteIdTokenCache() {
        CredentialManager.getInstance().deleteIdTokenCache();
    }

    public static SFLoginOutput renewSession(SFLoginInput loginInput) throws SFException, SnowflakeSQLException {
        try {
            return SessionUtil.tokenRequest(loginInput, TokenRequestType.RENEW);
        }
        catch (SnowflakeReauthenticationRequest ex) {
            if (Strings.isNullOrEmpty(loginInput.getIdToken())) {
                throw ex;
            }
            return SessionUtil.tokenRequest(loginInput, TokenRequestType.ISSUE);
        }
    }

    public static SFLoginOutput issueSession(SFLoginInput loginInput) throws SFException, SnowflakeSQLException {
        return SessionUtil.tokenRequest(loginInput, TokenRequestType.ISSUE);
    }

    private static SFLoginOutput tokenRequest(SFLoginInput loginInput, TokenRequestType requestType) throws SFException, SnowflakeSQLException {
        String masterToken;
        String sessionToken;
        HttpPost postRequest;
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for tokenRequest");
        if (requestType == TokenRequestType.RENEW) {
            AssertUtil.assertTrue(loginInput.getMasterToken() != null, "missing master token for tokenRequest");
            AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for tokenRequest");
        } else if (requestType == TokenRequestType.ISSUE) {
            AssertUtil.assertTrue(loginInput.getIdToken() != null, "missing id token for tokenRequest");
        }
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for tokenRequest");
        try {
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            uriBuilder.setPath(SF_PATH_TOKEN_REQUEST);
            uriBuilder.addParameter("requestId", UUID.randomUUID().toString());
            postRequest = new HttpPost(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            logger.error("Exception when creating http request", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:3");
        }
        try {
            String headerToken;
            HashMap<String, String> payload = new HashMap<String, String>();
            if (requestType == TokenRequestType.RENEW) {
                headerToken = loginInput.getMasterToken();
                payload.put("oldSessionToken", loginInput.getSessionToken());
            } else {
                headerToken = loginInput.getIdToken();
                payload.put("idToken", loginInput.getIdToken());
            }
            payload.put("requestType", requestType.value);
            String json = mapper.writeValueAsString(payload);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + headerToken + "\"");
            SessionUtil.setServiceNameHeader(loginInput, postRequest);
            logger.debug("request type: {}, old session token: {}, master token: {}, id token: {}", requestType.value, () -> loginInput.getSessionToken() != null ? "******" : null, () -> loginInput.getMasterToken() != null ? "******" : null, () -> loginInput.getIdToken() != null ? "******" : null);
            String theString = HttpUtil.executeRequest(postRequest, loginInput.getLoginTimeout(), 0, null);
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("response = {}", theString);
                String errorCode = jsonNode.path("code").asText();
                String message = jsonNode.path("message").asText();
                EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, "SessionUtil:renewSession failure, error code=" + errorCode + ", message=" + message, true);
                SnowflakeUtil.checkErrorAndThrowExceptionIncludingReauth(jsonNode);
            }
            sessionToken = jsonNode.path("data").path("sessionToken").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
        }
        catch (IOException ex) {
            logger.error("IOException when renewing session: " + postRequest, ex);
            throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
        }
        SFLoginOutput loginOutput = new SFLoginOutput();
        loginOutput.setSessionToken(sessionToken).setMasterToken(masterToken).setUpdatedByTokenRequest(true).setUpdatedByTokenRequestIssue(requestType == TokenRequestType.ISSUE);
        return loginOutput;
    }

    public static void closeSession(SFLoginInput loginInput) throws SFException, SnowflakeSQLException {
        block4: {
            logger.debug(" public void close() throws SFException");
            AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for closing session");
            AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for closing session");
            AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "missing login timeout for closing session");
            HttpPost postRequest = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
                uriBuilder.addParameter(SF_QUERY_SESSION_DELETE, "true");
                uriBuilder.addParameter("requestId", UUID.randomUUID().toString());
                uriBuilder.setPath(SF_PATH_SESSION);
                postRequest = new HttpPost(uriBuilder.build());
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + loginInput.getSessionToken() + "\"");
                SessionUtil.setServiceNameHeader(loginInput, postRequest);
                String theString = HttpUtil.executeRequest(postRequest, loginInput.getLoginTimeout(), 0, null);
                logger.debug("connection close response: {}", theString);
                JsonNode rootNode = mapper.readTree(theString);
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("unexpected URI syntax exception", ex);
            }
            catch (IOException ex) {
                logger.error("unexpected IO exception for: " + postRequest, ex);
            }
            catch (SnowflakeSQLException ex) {
                if (ex.getErrorCode() == 390112 || ex.getErrorCode() == 390111) break block4;
                throw ex;
            }
        }
    }

    private static String federatedFlowStep4(SFLoginInput loginInput, String ssoUrl, String oneTimeToken) throws SnowflakeSQLException {
        String responseHtml = "";
        try {
            URL url = new URL(ssoUrl);
            URI oktaGetUri = new URIBuilder().setScheme(url.getProtocol()).setHost(url.getHost()).setPath(url.getPath()).setParameter("RelayState", "%2Fsome%2Fdeep%2Flink").setParameter("onetimetoken", oneTimeToken).build();
            HttpGet httpGet = new HttpGet(oktaGetUri);
            HeaderGroup headers = new HeaderGroup();
            headers.addHeader(new BasicHeader("Accept", "*/*"));
            httpGet.setHeaders(headers.getAllHeaders());
            responseHtml = HttpUtil.executeRequest(httpGet, loginInput.getLoginTimeout(), 0, null);
            String postBackUrl = SessionUtil.getPostBackUrlFromHTML(responseHtml);
            if (!SessionUtil.isPrefixEqual(postBackUrl, loginInput.getServerUrl())) {
                logger.debug("The specified authenticator {} and the destination URL in the SAML assertion {} do not match.", loginInput.getAuthenticator(), postBackUrl);
                throw new SnowflakeSQLException("08001", ErrorCode.IDP_INCORRECT_DESTINATION.getMessageCode());
            }
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return responseHtml;
    }

    private static String federatedFlowStep3(SFLoginInput loginInput, String tokenUrl) throws SnowflakeSQLException {
        String oneTimeToken = "";
        try {
            URL url = new URL(tokenUrl);
            URI tokenUri = url.toURI();
            HttpPost postRequest = new HttpPost(tokenUri);
            StringEntity params = new StringEntity("{\"username\":\"" + loginInput.getUserName() + "\",\"password\":\"" + loginInput.getPassword() + "\"}");
            postRequest.setEntity(params);
            HeaderGroup headers = new HeaderGroup();
            headers.addHeader(new BasicHeader("Accept", "application/json"));
            headers.addHeader(new BasicHeader("Content-Type", "application/json"));
            postRequest.setHeaders(headers.getAllHeaders());
            String idpResponse = HttpUtil.executeRequestWithoutCookies(postRequest, loginInput.getLoginTimeout(), 0, null);
            logger.debug("user is authenticated against {}.", loginInput.getAuthenticator());
            JsonNode jsonNode = mapper.readTree(idpResponse);
            oneTimeToken = jsonNode.get("cookieToken").asText();
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return oneTimeToken;
    }

    private static void federatedFlowStep2(SFLoginInput loginInput, String tokenUrl, String ssoUrl) throws SnowflakeSQLException {
        try {
            if (!SessionUtil.isPrefixEqual(loginInput.getAuthenticator(), tokenUrl) || !SessionUtil.isPrefixEqual(loginInput.getAuthenticator(), ssoUrl)) {
                logger.debug("The specified authenticator {} is not supported.", loginInput.getAuthenticator());
                throw new SnowflakeSQLException("08001", ErrorCode.IDP_CONNECTION_ERROR.getMessageCode());
            }
        }
        catch (MalformedURLException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
    }

    private static JsonNode federatedFlowStep1(SFLoginInput loginInput) throws SnowflakeSQLException {
        JsonNode dataNode = null;
        try {
            URIBuilder fedUriBuilder = new URIBuilder(loginInput.getServerUrl());
            fedUriBuilder.setPath(SF_PATH_AUTHENTICATOR_REQUEST);
            URI fedUrlUri = fedUriBuilder.build();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            data.put(ClientAuthnParameter.AUTHENTICATOR.name(), loginInput.getAuthenticator());
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), loginInput.getAppId());
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), loginInput.getAppVersion());
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            authnData.setData(data);
            String json = mapper.writeValueAsString(authnData);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            HttpPost postRequest = new HttpPost(fedUrlUri);
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            String gsResponse = HttpUtil.executeRequest(postRequest, loginInput.getLoginTimeout(), 0, null);
            logger.debug("authenticator-request response: {}", gsResponse);
            JsonNode jsonNode = mapper.readTree(gsResponse);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("response = {}", gsResponse);
                String errorCode = jsonNode.path("code").asText();
                throw new SnowflakeSQLException("08001", ErrorCode.CONNECTION_ERROR.getMessageCode(), errorCode, jsonNode.path("message").asText());
            }
            dataNode = jsonNode.path("data");
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return dataNode;
    }

    private static void handleFederatedFlowError(SFLoginInput loginInput, Exception ex) throws SnowflakeSQLException {
        if (ex instanceof IOException) {
            logger.error("IOException when authenticating with " + loginInput.getAuthenticator(), ex);
            throw new SnowflakeSQLException(ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        logger.error("Exception when authenticating with " + loginInput.getAuthenticator(), ex);
        throw new SnowflakeSQLException(ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
    }

    private static String getSamlResponseUsingOkta(SFLoginInput loginInput) throws SnowflakeSQLException {
        JsonNode dataNode = SessionUtil.federatedFlowStep1(loginInput);
        String tokenUrl = dataNode.path("tokenUrl").asText();
        String ssoUrl = dataNode.path("ssoUrl").asText();
        SessionUtil.federatedFlowStep2(loginInput, tokenUrl, ssoUrl);
        String oneTimeToken = SessionUtil.federatedFlowStep3(loginInput, tokenUrl);
        String responseHtml = SessionUtil.federatedFlowStep4(loginInput, ssoUrl, oneTimeToken);
        return responseHtml;
    }

    static boolean isPrefixEqual(String aUrlStr, String bUrlStr) throws MalformedURLException {
        URL aUrl = new URL(aUrlStr);
        URL bUrl = new URL(bUrlStr);
        int aPort = aUrl.getPort();
        int bPort = bUrl.getPort();
        if (aPort == -1 && "https".equals(aUrl.getProtocol())) {
            aPort = 443;
        }
        if (bPort == -1 && "https".equals(bUrl.getProtocol())) {
            bPort = 443;
        }
        return aUrl.getHost().equalsIgnoreCase(bUrl.getHost()) && aUrl.getProtocol().equalsIgnoreCase(bUrl.getProtocol()) && aPort == bPort;
    }

    private static String getPostBackUrlFromHTML(String html) {
        Document doc = Jsoup.parse(html);
        Elements e1 = doc.getElementsByTag("body");
        Elements e2 = ((Element)e1.get(0)).getElementsByTag("form");
        String postBackUrl = e2.first().attr("action");
        return postBackUrl;
    }

    public static Map<String, Object> getCommonParams(JsonNode paramsNode) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (JsonNode child : paramsNode) {
            if (!child.hasNonNull("name")) {
                logger.error("Common Parameter JsonNode encountered with no parameter name!");
                continue;
            }
            String paramName = child.path("name").asText();
            if (!child.hasNonNull("value")) {
                logger.debug("No value found for Common Parameter {}", child.path("name").asText());
                continue;
            }
            if (STRING_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asText());
            } else if (INT_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asInt());
            } else if (BOOLEAN_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asBoolean());
            } else {
                logger.debug("Unknown Common Parameter: {}", paramName);
            }
            logger.debug("Parameter {}: {}", paramName, child.path("value").asText());
        }
        return parameters;
    }

    public static void updateSfDriverParamValues(Map<String, Object> parameters, SFSession session) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            logger.debug("processing parameter {}", entry.getKey());
            if ("CLIENT_DISABLE_INCIDENTS".equalsIgnoreCase(entry.getKey())) {
                SnowflakeDriver.setDisableIncidents((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_SESSION_KEEP_ALIVE".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableHeartbeat((Boolean)entry.getValue());
                continue;
            }
            if ("AUTOCOMMIT".equalsIgnoreCase(entry.getKey())) {
                boolean autoCommit = (Boolean)entry.getValue();
                if (session == null || session.getAutoCommit() == autoCommit) continue;
                session.setAutoCommit(autoCommit);
                continue;
            }
            if (JDBC_RS_COLUMN_CASE_INSENSITIVE.equalsIgnoreCase(entry.getKey()) || CLIENT_RESULT_COLUMN_CASE_INSENSITIVE.equalsIgnoreCase(entry.getKey())) {
                if (session == null || session.isResultColumnCaseInsensitive()) continue;
                session.setResultColumnCaseInsensitive((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setMetadataRequestUseConnectionCtx((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_TIMESTAMP_TYPE_MAPPING".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setTimestampMappedType(SnowflakeType.valueOf(((String)entry.getValue()).toUpperCase()));
                continue;
            }
            if ("JDBC_TREAT_DECIMAL_AS_INT".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setJdbcTreatDecimalAsInt((Boolean)entry.getValue());
                continue;
            }
            if ("JDBC_ENABLE_COMBINED_DESCRIBE".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableCombineDescribe((Boolean)entry.getValue());
                continue;
            }
            if (CLIENT_IN_BAND_TELEMETRY_ENABLED.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientTelemetryEnabled((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setArrayBindStageThreshold((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_STORE_TEMPORARY_CREDENTIAL.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setStoreTemporaryCredential((Boolean)entry.getValue());
                continue;
            }
            if (SERVICE_NAME.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setServiceName((String)entry.getValue());
                continue;
            }
            if (CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableConservativeMemoryUsage((Boolean)entry.getValue());
                continue;
            }
            if (CLIENT_MEMORY_LIMIT.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientMemoryLimit((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_RESULT_CHUNK_SIZE.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientResultChunkSize((Integer)entry.getValue());
                continue;
            }
            if (CLIENT_PREFETCH_THREADS.equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setClientPrefetchThreads((Integer)entry.getValue());
                continue;
            }
            if (!CLIENT_OUT_OF_BAND_TELEMETRY_ENABLED.equalsIgnoreCase(entry.getKey())) continue;
            if (((Boolean)entry.getValue()).booleanValue()) {
                TelemetryService.getInstance().enable();
                continue;
            }
            TelemetryService.getInstance().disable();
        }
    }

    static enum TokenRequestType {
        RENEW("RENEW"),
        CLONE("CLONE"),
        ISSUE("ISSUE");

        private String value;

        private TokenRequestType(String value) {
            this.value = value;
        }
    }
}

