/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryOOB;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryEvent;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;

public class TelemetryService {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TelemetryService.class);
    private static ThreadLocal<TelemetryService> _threadLocal = new ThreadLocal<TelemetryService>(){

        @Override
        protected TelemetryService initialValue() {
            return new TelemetryService();
        }
    };
    private static HashSet<String> ENABLED_DEPLOYMENT = new HashSet<String>(Arrays.asList(TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.DEV), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.REG), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.QA1), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.PREPROD2)));
    private static final int DEFAULT_NUM_OF_RETRY_TO_TRIGGER_TELEMETRY = 10;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int numOfRetryToTriggerTelemetry = 10;
    private ConcurrentLinkedQueue<TelemetryEvent> queue = new ConcurrentLinkedQueue();
    private int batchSize = 100;
    private JSONObject context;
    private ExecutorService uploader = Executors.newFixedThreadPool(3);
    private TELEMETRY_SERVER_DEPLOYMENT serverDeployment;
    private boolean enabled = false;
    private boolean runFlushBeforeException = true;

    public static TelemetryService getInstance() {
        return _threadLocal.get();
    }

    private TelemetryService() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("shutdownHooks"));
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new TelemetryUploader(this, this.exportQueueToString())));
        }
        catch (SecurityException e) {
            logger.debug("Failed to add shutdown hook for telemetry service");
        }
    }

    public void resetNumOfRetryToTriggerTelemetry() {
        this.numOfRetryToTriggerTelemetry = 10;
    }

    public int getNumOfRetryToTriggerTelemetry() {
        return this.numOfRetryToTriggerTelemetry;
    }

    public void setNumOfRetryToTriggerTelemetry(int num) {
        this.numOfRetryToTriggerTelemetry = num;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean runFlushBeforeException() {
        return this.runFlushBeforeException;
    }

    public void enableRunFlushBeforeException() {
        this.runFlushBeforeException = true;
    }

    public void disableRunFlushBeforeException() {
        this.runFlushBeforeException = false;
    }

    public JSONObject getContext() {
        return this.context;
    }

    public void updateContext(Map<String, String> params) {
        Properties info = new Properties();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (val == null) continue;
            info.put(key, val);
        }
        this.updateContext(params.get("uri"), info);
    }

    public void updateContext(String url, Properties info) {
        this.configureDeployment(url, info.getProperty("account"), info.getProperty("port"));
        Enumeration<?> names = info.propertyNames();
        this.context = new JSONObject();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.compareTo("password") == 0 || name.compareTo("privateKey") == 0) continue;
            this.context.put(name, info.getProperty(name));
        }
    }

    private void configureDeployment(String url, String account, String port) {
        TELEMETRY_SERVER_DEPLOYMENT deployment = TELEMETRY_SERVER_DEPLOYMENT.PROD;
        if (url != null) {
            if (url.contains("reg") || url.contains("local")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.REG;
                if (port != null && port.compareTo("8080") == 0 || url.contains("8080")) {
                    deployment = TELEMETRY_SERVER_DEPLOYMENT.DEV;
                }
            } else if (url.contains("qa1") || account != null && account.contains("qa1")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.QA1;
            } else if (url.contains("preprod2")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.PREPROD2;
            }
        }
        this.setDeployment(deployment);
    }

    public boolean isDeploymentEnabled() {
        return ENABLED_DEPLOYMENT.contains(this.serverDeployment.name);
    }

    public TelemetryEvent peek() {
        return this.queue.peek();
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public void resetBatchSize() {
        this.batchSize = 100;
    }

    public void setDeployment(TELEMETRY_SERVER_DEPLOYMENT deployment) {
        this.serverDeployment = deployment;
    }

    public String getServerDeploymentName() {
        return this.serverDeployment.name;
    }

    public void add(TelemetryEvent event) {
        if (!this.enabled) {
            return;
        }
        this.queue.offer(event);
        if (this.queue.size() >= this.batchSize || event.containsKey("Urgent") && ((Boolean)event.get("Urgent")).booleanValue()) {
            TelemetryUploader runUpload = new TelemetryUploader(this, this.exportQueueToString());
            this.uploader.execute(runUpload);
        }
    }

    public void flush() {
        if (!this.enabled) {
            return;
        }
        if (!this.queue.isEmpty()) {
            TelemetryUploader runUpload = new TelemetryUploader(this, this.exportQueueToString());
            this.uploader.execute(runUpload);
        }
    }

    public String exportQueueToString() {
        JSONArray logs = new JSONArray();
        while (!this.queue.isEmpty()) {
            logs.add(this.queue.poll());
        }
        return SecretDetector.maskAWSSecret(logs.toString());
    }

    public int size() {
        return this.queue.size();
    }

    public void logHttpRequestTelemetryEvent(String eventName, HttpRequestBase request, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, CloseableHttpResponse response, Exception savedEx, String breakRetryReason, long retryTimeout, int retryCount, String sqlState, int errorCode) {
        if (this.enabled) {
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            JSONObject value = new JSONObject();
            value.put("request", request.toString());
            value.put("retryTimeout", retryTimeout);
            value.put("injectSocketTimeout", injectSocketTimeout);
            value.put("canceling", canceling == null ? "null" : Boolean.valueOf(canceling.get()));
            value.put("withoutCookies", withoutCookies);
            value.put("includeRetryParameters", includeRetryParameters);
            value.put("includeRequestGuid", includeRequestGuid);
            value.put("breakRetryReason", breakRetryReason);
            value.put("retryTimeout", retryTimeout);
            value.put("retryCount", retryCount);
            value.put("sqlState", sqlState);
            value.put("errorCode", errorCode);
            int responseStatusCode = -1;
            if (response != null) {
                value.put("response", response.toString());
                value.put("responseStatusLine", response.getStatusLine().toString());
                if (response.getStatusLine() != null) {
                    responseStatusCode = response.getStatusLine().getStatusCode();
                    value.put("responseStatusCode", responseStatusCode);
                }
            } else {
                value.put("response", null);
            }
            if (savedEx != null) {
                value.put("exceptionMessage", savedEx.getLocalizedMessage());
                StringWriter sw = new StringWriter();
                savedEx.printStackTrace(new PrintWriter(sw));
                value.put("exceptionStackTrace", sw.toString());
            }
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(eventName)).withValue(value).withTag("sqlState", sqlState)).withTag("errorCode", errorCode)).withTag("responseStatusCode", responseStatusCode)).build();
            this.add(log);
        }
    }

    static class TelemetryUploader
    implements Runnable {
        TelemetryService instance;
        String payload;

        public TelemetryUploader(TelemetryService _instance, String _payload) {
            this.instance = _instance;
            this.payload = _payload;
        }

        @Override
        public void run() {
            if (!this.instance.enabled) {
                return;
            }
            if (this.payload == null || this.payload.isEmpty()) {
                logger.debug("skip to run telemetry uploader for empty payload");
            } else {
                this.uploadPayload();
                logger.debug("run telemetry uploader");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadPayload() {
            boolean success;
            HttpResponse response;
            block7: {
                response = null;
                success = true;
                if (this.instance.isDeploymentEnabled()) break block7;
                logger.debug("skip the disabled deployment: " + this.instance.serverDeployment.name);
                logger.debug("Telemetry request success={} and clean the current queue", success);
                this.instance.queue.clear();
                return;
            }
            try {
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpPost post = new HttpPost(this.instance.serverDeployment.url);
                post.setEntity(new StringEntity(this.payload));
                post.setHeader("Content-type", "application/json");
                post.setHeader("x-api-key", this.instance.serverDeployment.getApiKey());
                response = httpClient.execute(post);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    logger.debug("telemetry server request success: " + response);
                } else {
                    logger.debug("telemetry server request error: " + response);
                    success = false;
                }
                logger.debug(EntityUtils.toString(response.getEntity(), "UTF-8"));
            }
            catch (IOException e) {
                try {
                    logger.debug("Telemetry request failed, IOExceptionresponse: {}, exception: {}", response, e.getMessage());
                    success = false;
                }
                catch (Throwable throwable) {
                    logger.debug("Telemetry request success={} and clean the current queue", success);
                    this.instance.queue.clear();
                    throw throwable;
                }
                logger.debug("Telemetry request success={} and clean the current queue", success);
                this.instance.queue.clear();
            }
            logger.debug("Telemetry request success={} and clean the current queue", success);
            this.instance.queue.clear();
        }
    }

    public static enum TELEMETRY_SERVER_DEPLOYMENT {
        DEV("dev", TELEMETRY_API.SFCTEST),
        REG("reg", TELEMETRY_API.SFCTEST),
        QA1("qa1", TELEMETRY_API.SFCDEV),
        PREPROD2("preprod2", TELEMETRY_API.SFCDEV),
        PROD("prod", TELEMETRY_API.US2);

        private final String name;
        private final String url;
        private final String apiKey;

        private TELEMETRY_SERVER_DEPLOYMENT(String name, TELEMETRY_API api) {
            this.name = name;
            this.url = api.url;
            this.apiKey = api.apiKey;
        }

        public String getURL() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getApiKey() {
            return this.apiKey;
        }
    }

    private static enum TELEMETRY_API {
        SFCTEST("https://lximwp8945.execute-api.us-west-2.amazonaws.com/sfctest/enqueue", "zJHB5wqSZL7JSilRbQEHB52ZUG0ajdd166gsMmKv"),
        SFCDEV("https://lol6l3j52m.execute-api.us-west-2.amazonaws.com/sfcdev/enqueue", "kyTKLWpEZSaJnrzTZ63I96QXZHKsgfqbaGmAaIWf"),
        US2("https://4yss82lml2.execute-api.us-east-1.amazonaws.com/us2/enqueue", "wLpEKqnLOW9tGNwTjab5N611YQApOb3t9xOnE1rX");

        private final String url;
        private final String apiKey;

        private TELEMETRY_API(String url, String key) {
            this.url = url;
            this.apiKey = key;
        }
    }
}

