/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.nio.ByteBuffer;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeSQLException;

public class ResultJsonParserV2 {
    private static final byte[] BNULL = new byte[]{110, 117, 108, 108};
    private State state = State.UNINITIALIZED;
    private int currentColumn;
    private int outputCurValuePosition;
    private int outputPosition;
    private ByteBuffer partialEscapedUnicode;
    private int outputDataLength;
    private SnowflakeResultChunk resultChunk;

    public void startParsing(SnowflakeResultChunk resultChunk) throws SnowflakeSQLException {
        this.resultChunk = resultChunk;
        if (this.state != State.UNINITIALIZED) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Json parser is already used!");
        }
        this.state = State.NEXT_ROW;
        this.outputPosition = 0;
        this.outputCurValuePosition = 0;
        if (this.partialEscapedUnicode == null) {
            this.partialEscapedUnicode = ByteBuffer.wrap(new byte[256]);
        } else {
            this.partialEscapedUnicode.clear();
        }
        this.currentColumn = 0;
        this.outputDataLength = resultChunk.computeCharactersNeeded();
    }

    public void endParsing() throws SnowflakeSQLException {
        if (this.partialEscapedUnicode.position() > 0) {
            this.partialEscapedUnicode.flip();
            this.continueParsingInternal(this.partialEscapedUnicode, true);
            this.partialEscapedUnicode.clear();
        }
        if (this.state != State.ROW_FINISHED) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "SFResultJsonParser2Failed: Chunk is truncated!");
        }
        this.currentColumn = 0;
        this.state = State.UNINITIALIZED;
    }

    public void continueParsing(ByteBuffer in) throws SnowflakeSQLException {
        if (this.state == State.UNINITIALIZED) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Json parser hasn't been initialized!");
        }
        if (this.partialEscapedUnicode.position() > 0) {
            int lenToCopy = Math.min(12 - this.partialEscapedUnicode.position(), in.remaining());
            if (lenToCopy > this.partialEscapedUnicode.remaining()) {
                this.resizePartialEscapedUnicode(lenToCopy);
            }
            this.partialEscapedUnicode.put(in.array(), in.arrayOffset() + in.position(), lenToCopy);
            in.position(in.position() + lenToCopy);
            if (this.partialEscapedUnicode.position() < 12) {
                return;
            }
            ByteBuffer toBeParsed = this.partialEscapedUnicode.duplicate();
            toBeParsed.flip();
            this.continueParsingInternal(toBeParsed, false);
            this.partialEscapedUnicode.clear();
        }
        this.continueParsingInternal(in, false);
    }

    private void resizePartialEscapedUnicode(int lenToCopy) {
        int newSize;
        for (newSize = 2 * this.partialEscapedUnicode.capacity(); newSize < this.partialEscapedUnicode.capacity() + lenToCopy; newSize *= 2) {
        }
        byte[] newArray = new byte[newSize];
        System.arraycopy(this.partialEscapedUnicode.array(), this.partialEscapedUnicode.arrayOffset(), newArray, 0, this.partialEscapedUnicode.position());
        ByteBuffer newBuf = ByteBuffer.wrap(newArray);
        newBuf.position(this.partialEscapedUnicode.position());
        this.partialEscapedUnicode.clear();
        this.partialEscapedUnicode = newBuf;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void continueParsingInternal(ByteBuffer in, boolean lastData) throws SnowflakeSQLException {
        while (in.hasRemaining()) {
            if (this.outputPosition >= this.outputDataLength) {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "column chunk longer than expected");
            }
            block0 : switch (this.state) {
                case UNINITIALIZED: {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "parser is in inconsistent state");
                }
                case NEXT_ROW: {
                    switch (in.get()) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block0;
                        }
                        case 91: {
                            this.state = State.WAIT_FOR_VALUE;
                            break block0;
                        }
                    }
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "SFResultJsonParser2Failed: encountered unexpected character 0x%x between rows", in.get(in.position() - 1));
                }
                case ROW_FINISHED: {
                    switch (in.get()) {
                        case 44: {
                            this.state = State.NEXT_ROW;
                            break block0;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block0;
                        }
                    }
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "SFResultJsonParser2Failed: encountered unexpected character 0x%x after array", in.get(in.position() - 1));
                }
                case WAIT_FOR_VALUE: {
                    switch (in.get()) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block0;
                        }
                        case 44: {
                            this.addNullValue();
                            this.state = State.WAIT_FOR_NEXT;
                            in.position(in.position() - 1);
                            break block0;
                        }
                        case 93: {
                            this.addNullValue();
                            this.currentColumn = 0;
                            this.state = State.ROW_FINISHED;
                            break block0;
                        }
                        case 34: {
                            this.outputCurValuePosition = this.outputPosition;
                            this.resultChunk.addOffset(this.outputPosition);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                    }
                    this.outputCurValuePosition = this.outputPosition;
                    this.resultChunk.addOffset(this.outputPosition);
                    this.addByteToOutput(in.get(in.position() - 1));
                    this.state = State.IN_VALUE;
                    break;
                }
                case IN_VALUE: {
                    switch (in.get()) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: {
                            int length = this.outputPosition - this.outputCurValuePosition;
                            if (length == 4 && this.isNull()) {
                                this.resultChunk.setIsNull();
                                this.outputPosition = this.outputCurValuePosition;
                            } else {
                                this.resultChunk.setLastLength(length);
                            }
                            this.state = State.WAIT_FOR_NEXT;
                            in.position(in.position() - 1);
                            break block0;
                        }
                    }
                    this.addByteToOutput(in.get(in.position() - 1));
                    break;
                }
                case IN_STRING: {
                    switch (in.get()) {
                        case 34: {
                            this.resultChunk.setLastLength(this.outputPosition - this.outputCurValuePosition);
                            this.state = State.WAIT_FOR_NEXT;
                            break block0;
                        }
                        case 92: {
                            this.state = State.ESCAPE;
                            break block0;
                        }
                    }
                    int inputPositionStart = in.position() - 1;
                    while (in.hasRemaining()) {
                        byte cur = in.get();
                        if (cur != 34 && cur != 92) continue;
                        in.position(in.position() - 1);
                        break;
                    }
                    this.addByteArrayToOutput(in.array(), in.arrayOffset() + inputPositionStart, in.position() - inputPositionStart);
                    if (!in.hasRemaining() || in.get(in.position()) == 34 || in.get(in.position()) == 92) break;
                    break;
                }
                case ESCAPE: {
                    switch (in.get()) {
                        case 34: {
                            this.addByteToOutput((byte)34);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 92: {
                            this.addByteToOutput((byte)92);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 47: {
                            this.addByteToOutput((byte)47);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 98: {
                            this.addByteToOutput((byte)11);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 102: {
                            this.addByteToOutput((byte)12);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 110: {
                            this.addByteToOutput((byte)10);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 114: {
                            this.addByteToOutput((byte)13);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 116: {
                            this.addByteToOutput((byte)9);
                            this.state = State.IN_STRING;
                            break block0;
                        }
                        case 117: {
                            if (in.remaining() >= 9 || lastData && in.remaining() >= 3) {
                                if (!this.parseCodepoint(in)) {
                                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "SFResultJsonParser2Failed: invalid escaped unicode character");
                                }
                                this.state = State.IN_STRING;
                                break block0;
                            }
                            if (this.partialEscapedUnicode.remaining() < in.remaining() + 2) {
                                this.resizePartialEscapedUnicode(in.remaining() + 2);
                            }
                            this.partialEscapedUnicode.put((byte)92);
                            this.partialEscapedUnicode.put(in.array(), in.arrayOffset() + in.position() - 1, in.remaining() + 1);
                            in.position(in.position() + in.remaining());
                            this.state = State.IN_STRING;
                            return;
                        }
                    }
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "SFResultJsonParser2Failed: encountered unexpected escape character 0x%x", in.get(in.position() - 1));
                }
                case WAIT_FOR_NEXT: {
                    switch (in.get()) {
                        case 44: {
                            ++this.currentColumn;
                            this.resultChunk.nextIndex();
                            if (this.currentColumn >= this.resultChunk.getColCount()) {
                                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "SFResultJsonParser2Failed: Too many columns!");
                            }
                            this.state = State.WAIT_FOR_VALUE;
                            break block0;
                        }
                        case 93: {
                            this.currentColumn = 0;
                            this.resultChunk.nextIndex();
                            this.state = State.ROW_FINISHED;
                            break block0;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block0;
                        }
                    }
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "SFResultJsonParser2Failed: encountered unexpected character 0x%x between columns", in.get(in.position() - 1));
                }
            }
        }
        return;
    }

    private boolean isNull() throws SnowflakeSQLException {
        int pos = this.outputPosition;
        return this.resultChunk.get(--pos) == BNULL[3] && this.resultChunk.get(--pos) == BNULL[2] && this.resultChunk.get(--pos) == BNULL[1] && this.resultChunk.get(--pos) == BNULL[0];
    }

    private int parseQuadhex(ByteBuffer s) {
        int uni_ch = 0;
        for (int i = 0; i < 4; ++i) {
            int hex = s.get();
            if (hex == -1) {
                return -1;
            }
            if (48 <= hex && hex <= 57) {
                hex -= 48;
            } else if (65 <= hex && hex <= 70) {
                hex -= 55;
            } else if (97 <= hex && hex <= 102) {
                hex -= 87;
            } else {
                return -1;
            }
            uni_ch = uni_ch * 16 + hex;
        }
        return uni_ch;
    }

    private void addNullValue() throws SnowflakeSQLException {
        this.resultChunk.addOffset(this.outputPosition);
    }

    private void addByteToOutput(byte c) throws SnowflakeSQLException {
        this.resultChunk.addByte(c, this.outputPosition);
        ++this.outputPosition;
    }

    private void addByteArrayToOutput(byte[] src, int offset, int length) throws SnowflakeSQLException {
        this.resultChunk.addBytes(src, offset, this.outputPosition, length);
        this.outputPosition += length;
    }

    private boolean parseCodepoint(ByteBuffer s) throws SnowflakeSQLException {
        int uni_ch = this.parseQuadhex(s);
        if (uni_ch == -1) {
            return false;
        }
        if (55296 <= uni_ch && uni_ch <= 57343) {
            if (56320 <= uni_ch) {
                return false;
            }
            if (2 >= s.remaining()) {
                return false;
            }
            if (s.get() != 92 || s.get() != 117) {
                return false;
            }
            if (4 > s.remaining()) {
                return false;
            }
            int second = this.parseQuadhex(s);
            if (56320 > second || second > 57343) {
                return false;
            }
            uni_ch = uni_ch - 55296 << 10 | second - 56320 & 0x3FF;
            uni_ch += 65536;
        }
        if (uni_ch < 128) {
            this.addByteToOutput((byte)uni_ch);
        } else {
            if (uni_ch < 2048) {
                this.addByteToOutput((byte)(0xC0 | uni_ch >> 6));
            } else {
                if (uni_ch < 65536) {
                    this.addByteToOutput((byte)(0xE0 | uni_ch >> 12));
                } else {
                    this.addByteToOutput((byte)(0xF0 | uni_ch >> 18));
                    this.addByteToOutput((byte)(0x80 | uni_ch >> 12 & 0x3F));
                }
                this.addByteToOutput((byte)(0x80 | uni_ch >> 6 & 0x3F));
            }
            this.addByteToOutput((byte)(0x80 | uni_ch & 0x3F));
        }
        return true;
    }

    private static enum State {
        UNINITIALIZED,
        NEXT_ROW,
        ROW_FINISHED,
        WAIT_FOR_VALUE,
        IN_VALUE,
        IN_STRING,
        ESCAPE,
        WAIT_FOR_NEXT;

    }
}

