/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.tika.detect.Detector;
import net.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import net.snowflake.client.jdbc.internal.apache.tika.mime.MediaType;
import net.snowflake.client.jdbc.internal.apache.tika.mime.MediaTypeRegistry;

public class CompositeDetector
implements Detector {
    private static final long serialVersionUID = 5980683158436430252L;
    private final MediaTypeRegistry registry;
    private final List<Detector> detectors;

    public CompositeDetector(MediaTypeRegistry registry, List<Detector> detectors) {
        this.registry = registry;
        this.detectors = detectors;
    }

    public CompositeDetector(List<Detector> detectors) {
        this(new MediaTypeRegistry(), detectors);
    }

    public CompositeDetector(Detector ... detectors) {
        this(Arrays.asList(detectors));
    }

    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        MediaType type = MediaType.OCTET_STREAM;
        for (Detector detector : this.getDetectors()) {
            MediaType detected = detector.detect(input, metadata);
            if (!this.registry.isSpecializationOf(detected, type)) continue;
            type = detected;
        }
        return type;
    }

    public List<Detector> getDetectors() {
        return Collections.unmodifiableList(this.detectors);
    }
}

