/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.snowflake.client.jdbc.internal.apache.tika.config.ServiceLoader;
import net.snowflake.client.jdbc.internal.apache.tika.detect.CompositeDetector;
import net.snowflake.client.jdbc.internal.apache.tika.detect.DefaultDetector;
import net.snowflake.client.jdbc.internal.apache.tika.detect.Detector;
import net.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import net.snowflake.client.jdbc.internal.apache.tika.language.translate.DefaultTranslator;
import net.snowflake.client.jdbc.internal.apache.tika.language.translate.Translator;
import net.snowflake.client.jdbc.internal.apache.tika.mime.MediaType;
import net.snowflake.client.jdbc.internal.apache.tika.mime.MediaTypeRegistry;
import net.snowflake.client.jdbc.internal.apache.tika.mime.MimeTypeException;
import net.snowflake.client.jdbc.internal.apache.tika.mime.MimeTypes;
import net.snowflake.client.jdbc.internal.apache.tika.mime.MimeTypesFactory;
import net.snowflake.client.jdbc.internal.apache.tika.parser.AutoDetectParser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.CompositeParser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.DefaultParser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.Parser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.ParserDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TikaConfig {
    private final CompositeParser parser;
    private final Detector detector;
    private final Translator translator;
    private final MimeTypes mimeTypes;

    private static MimeTypes getDefaultMimeTypes(ClassLoader loader) {
        return MimeTypes.getDefaultMimeTypes(loader);
    }

    private static Detector getDefaultDetector(MimeTypes types, ServiceLoader loader) {
        return new DefaultDetector(types, loader);
    }

    private static CompositeParser getDefaultParser(MimeTypes types, ServiceLoader loader) {
        return new DefaultParser(types.getMediaTypeRegistry(), loader);
    }

    private static Translator getDefaultTranslator(ServiceLoader loader) {
        return new DefaultTranslator(loader);
    }

    public TikaConfig(String file) throws TikaException, IOException, SAXException {
        this(new File(file));
    }

    public TikaConfig(File file) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(file));
    }

    public TikaConfig(URL url) throws TikaException, IOException, SAXException {
        this(url, ServiceLoader.getContextClassLoader());
    }

    public TikaConfig(URL url, ClassLoader loader) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(url.toString()).getDocumentElement(), loader);
    }

    public TikaConfig(InputStream stream) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(stream));
    }

    public TikaConfig(Document document) throws TikaException, IOException {
        this(document.getDocumentElement());
    }

    public TikaConfig(Element element) throws TikaException, IOException {
        this(element, new ServiceLoader());
    }

    public TikaConfig(Element element, ClassLoader loader) throws TikaException, IOException {
        this(element, new ServiceLoader(loader));
    }

    private TikaConfig(Element element, ServiceLoader loader) throws TikaException, IOException {
        this.mimeTypes = TikaConfig.typesFromDomElement(element);
        this.detector = TikaConfig.detectorFromDomElement(element, this.mimeTypes, loader);
        this.parser = TikaConfig.parserFromDomElement(element, this.mimeTypes, loader);
        this.translator = TikaConfig.translatorFromDomElement(element, loader);
    }

    public TikaConfig(ClassLoader loader) throws MimeTypeException, IOException {
        ServiceLoader serviceLoader = new ServiceLoader(loader);
        this.mimeTypes = TikaConfig.getDefaultMimeTypes(loader);
        this.detector = TikaConfig.getDefaultDetector(this.mimeTypes, serviceLoader);
        this.parser = TikaConfig.getDefaultParser(this.mimeTypes, serviceLoader);
        this.translator = TikaConfig.getDefaultTranslator(serviceLoader);
    }

    public TikaConfig() throws TikaException, IOException {
        ServiceLoader loader = new ServiceLoader();
        String config = System.getProperty("tika.config");
        if (config == null) {
            config = System.getenv("TIKA_CONFIG");
        }
        if (config == null) {
            this.mimeTypes = TikaConfig.getDefaultMimeTypes(ServiceLoader.getContextClassLoader());
            this.parser = TikaConfig.getDefaultParser(this.mimeTypes, loader);
            this.detector = TikaConfig.getDefaultDetector(this.mimeTypes, loader);
            this.translator = TikaConfig.getDefaultTranslator(loader);
        } else {
            InputStream stream = null;
            File file = new File(config);
            if (file.isFile()) {
                stream = new FileInputStream(file);
            }
            if (stream == null) {
                try {
                    stream = new URL(config).openStream();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (stream == null) {
                stream = loader.getResourceAsStream(config);
            }
            if (stream == null) {
                throw new TikaException("Specified Tika configuration not found: " + config);
            }
            try {
                Element element = TikaConfig.getBuilder().parse(stream).getDocumentElement();
                this.mimeTypes = TikaConfig.typesFromDomElement(element);
                this.parser = TikaConfig.parserFromDomElement(element, this.mimeTypes, loader);
                this.detector = TikaConfig.detectorFromDomElement(element, this.mimeTypes, loader);
                this.translator = TikaConfig.translatorFromDomElement(element, loader);
            }
            catch (SAXException e) {
                throw new TikaException("Specified Tika configuration has syntax errors: " + config, e);
            }
            finally {
                stream.close();
            }
        }
    }

    private static String getText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            StringBuilder builder = new StringBuilder();
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                builder.append(TikaConfig.getText(list.item(i)));
            }
            return builder.toString();
        }
        return "";
    }

    public Parser getParser(MediaType mimeType) {
        return this.parser.getParsers().get(mimeType);
    }

    public Parser getParser() {
        return this.parser;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public MimeTypes getMimeRepository() {
        return this.mimeTypes;
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.mimeTypes.getMediaTypeRegistry();
    }

    public static TikaConfig getDefaultConfig() {
        try {
            return new TikaConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read default configuration", e);
        }
        catch (TikaException e) {
            throw new RuntimeException("Unable to access default configuration", e);
        }
    }

    private static DocumentBuilder getBuilder() throws TikaException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser not available", e);
        }
    }

    private static Element getChild(Element element, String name) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    private static MimeTypes typesFromDomElement(Element element) throws TikaException, IOException {
        Element mtr = TikaConfig.getChild(element, "mimeTypeRepository");
        if (mtr != null && mtr.hasAttribute("resource")) {
            return MimeTypesFactory.create(mtr.getAttribute("resource"));
        }
        return TikaConfig.getDefaultMimeTypes(null);
    }

    private static CompositeParser parserFromDomElement(Element element, MimeTypes mimeTypes, ServiceLoader loader) throws TikaException, IOException {
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        NodeList nodes = element.getElementsByTagName("parser");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            parsers.add(TikaConfig.parserFromParserDomElement(node, mimeTypes, loader));
        }
        if (parsers.isEmpty()) {
            return TikaConfig.getDefaultParser(mimeTypes, loader);
        }
        if (parsers.size() == 1 && parsers.get(0) instanceof CompositeParser) {
            return (CompositeParser)parsers.get(0);
        }
        MediaTypeRegistry registry = mimeTypes.getMediaTypeRegistry();
        return new CompositeParser(registry, parsers);
    }

    private static Parser parserFromParserDomElement(Element parserNode, MimeTypes mimeTypes, ServiceLoader loader) throws TikaException, IOException {
        String name = parserNode.getAttribute("class");
        Parser parser = null;
        try {
            Set<MediaType> parserExclTypes;
            Class<Parser> parserClass = loader.getServiceClass(Parser.class, name);
            if (AutoDetectParser.class.isAssignableFrom(parserClass)) {
                throw new TikaException("AutoDetectParser not supported in a <parser> configuration element: " + name);
            }
            if (CompositeParser.class.isAssignableFrom(parserClass)) {
                Constructor<Parser> c;
                ArrayList<Parser> childParsers = new ArrayList<Parser>();
                NodeList childParserNodes = parserNode.getElementsByTagName("parser");
                if (childParserNodes.getLength() > 0) {
                    for (int i = 0; i < childParserNodes.getLength(); ++i) {
                        childParsers.add(TikaConfig.parserFromParserDomElement((Element)childParserNodes.item(i), mimeTypes, loader));
                    }
                }
                HashSet<Class<Parser>> excludeParsers = new HashSet<Class<Parser>>();
                NodeList excludeParserNodes = parserNode.getElementsByTagName("parser-exclude");
                if (excludeParserNodes.getLength() > 0) {
                    for (int i = 0; i < excludeParserNodes.getLength(); ++i) {
                        Element excl = (Element)excludeParserNodes.item(i);
                        String exclName = excl.getAttribute("class");
                        excludeParsers.add(loader.getServiceClass(Parser.class, exclName));
                    }
                }
                if ((c = null) == null) {
                    try {
                        c = parserClass.getConstructor(MediaTypeRegistry.class, ServiceLoader.class, Collection.class);
                        parser = c.newInstance(mimeTypes.getMediaTypeRegistry(), loader, excludeParsers);
                    }
                    catch (NoSuchMethodException me) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    try {
                        c = parserClass.getConstructor(MediaTypeRegistry.class, List.class, Collection.class);
                        parser = c.newInstance(mimeTypes.getMediaTypeRegistry(), childParsers, excludeParsers);
                    }
                    catch (NoSuchMethodException me) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    parser = parserClass.newInstance();
                }
            } else {
                parser = parserClass.newInstance();
            }
            Set<MediaType> parserTypes = TikaConfig.mediaTypesListFromDomElement(parserNode, "mime");
            if (!parserTypes.isEmpty()) {
                parser = ParserDecorator.withTypes(parser, parserTypes);
            }
            if (!(parserExclTypes = TikaConfig.mediaTypesListFromDomElement(parserNode, "mime-exclude")).isEmpty()) {
                parser = ParserDecorator.withoutTypes(parser, parserExclTypes);
            }
            return parser;
        }
        catch (ClassNotFoundException e) {
            throw new TikaException("Unable to find a parser class: " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new TikaException("Unable to access a parser class: " + name, e);
        }
        catch (InvocationTargetException e) {
            throw new TikaException("Unable to create a parser class: " + name, e);
        }
        catch (InstantiationException e) {
            throw new TikaException("Unable to instantiate a parser class: " + name, e);
        }
    }

    private static Set<MediaType> mediaTypesListFromDomElement(Element node, String tag) throws TikaException, IOException {
        NodeList mimes = node.getElementsByTagName(tag);
        if (mimes.getLength() > 0) {
            HashSet<MediaType> types = new HashSet<MediaType>();
            for (int j = 0; j < mimes.getLength(); ++j) {
                String mime = TikaConfig.getText(mimes.item(j));
                MediaType type = MediaType.parse(mime);
                if (type == null) {
                    throw new TikaException("Invalid media type name: " + mime);
                }
                types.add(type);
            }
            return types;
        }
        return Collections.emptySet();
    }

    private static Detector detectorFromDomElement(Element element, MimeTypes mimeTypes, ServiceLoader loader) throws TikaException, IOException {
        ArrayList<Detector> detectors = new ArrayList<Detector>();
        NodeList nodes = element.getElementsByTagName("detector");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            String name = node.getAttribute("class");
            try {
                Class<Detector> detectorClass = loader.getServiceClass(Detector.class, name);
                detectors.add(detectorClass.newInstance());
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new TikaException("Unable to find a detector class: " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new TikaException("Unable to access a detector class: " + name, e);
            }
            catch (InstantiationException e) {
                throw new TikaException("Unable to instantiate a detector class: " + name, e);
            }
        }
        if (detectors.isEmpty()) {
            return TikaConfig.getDefaultDetector(mimeTypes, loader);
        }
        MediaTypeRegistry registry = mimeTypes.getMediaTypeRegistry();
        return new CompositeDetector(registry, detectors);
    }

    private static Translator translatorFromDomElement(Element element, ServiceLoader loader) throws TikaException, IOException {
        ArrayList<Translator> translators = new ArrayList<Translator>();
        NodeList nodes = element.getElementsByTagName("translator");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            String name = node.getAttribute("class");
            try {
                Class<Translator> translatorClass = loader.getServiceClass(Translator.class, name);
                translators.add(translatorClass.newInstance());
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new TikaException("Unable to find a translator class: " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new TikaException("Unable to access a translator class: " + name, e);
            }
            catch (InstantiationException e) {
                throw new TikaException("Unable to instantiate a translator class: " + name, e);
            }
        }
        if (translators.isEmpty()) {
            return TikaConfig.getDefaultTranslator(loader);
        }
        return (Translator)translators.get(0);
    }
}

