/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.bind;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.bind.BindException;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class BindUploader
implements Closeable {
    private static final SFLogger logger = SFLoggerFactory.getLogger(BindUploader.class);
    private static final String PREFIX = "binding_";
    private static final String STAGE_NAME = "SYSTEM$BIND";
    private static final String DATE_FORMAT = "ES3";
    private static final String TS_FORMAT = "ES9";
    private static final String CREATE_STAGE_STMT = "CREATE TEMPORARY STAGE SYSTEM$BIND file_format=( type=csv date_format=ES3 timestamp_format=ES9 field_optionally_enclosed_by='\"')";
    private static final String PUT_STMT = "PUT 'file://%s%s*' '%s' parallel=10 overwrite=true auto_compress=false source_compression=gzip";
    private static final int PUT_RETRY_COUNT = 3;
    private final SFSession session;
    private final String stagePath;
    private final Path bindDir;
    private boolean closed = false;
    private long fileSize = 0x6400000L;

    private BindUploader(SFSession session, String stageDir, Path bindDir) {
        this.session = session;
        this.stagePath = "@SYSTEM$BIND/" + stageDir;
        this.bindDir = bindDir;
    }

    public static synchronized BindUploader newInstance(SFSession session, String stageDir) throws BindException {
        try {
            Path bindDir = Files.createTempDirectory(PREFIX, new FileAttribute[0]);
            return new BindUploader(session, stageDir, bindDir);
        }
        catch (IOException ex) {
            throw new BindException(String.format("Failed to create temporary directory: %s", ex.getMessage()), BindException.Type.OTHER);
        }
    }

    public void upload(Map<String, ParameterBindingDTO> bindValues) throws BindException {
        if (!this.closed) {
            this.serializeBinds(bindValues);
            this.putBinds();
        }
    }

    private void serializeBinds(Map<String, ParameterBindingDTO> bindValues) throws BindException {
        List<List<String>> columns = this.getColumnValues(bindValues);
        List<String[]> rows = this.buildRows(columns);
        this.writeRowsToCSV(rows);
    }

    private List<List<String>> getColumnValues(Map<String, ParameterBindingDTO> bindValues) throws BindException {
        ArrayList<List<String>> columns = new ArrayList<List<String>>(bindValues.size());
        for (int i = 1; i <= bindValues.size(); ++i) {
            String key = Integer.toString(i);
            if (!bindValues.containsKey(key)) {
                throw new BindException(String.format("Bind map with %d columns should contain key \"%d\"", bindValues.size(), i), BindException.Type.SERIALIZATION);
            }
            ParameterBindingDTO value = bindValues.get(key);
            try {
                List list = (List)value.getValue();
                columns.add(i - 1, list);
                continue;
            }
            catch (ClassCastException ex) {
                throw new BindException("Value in binding DTO could not be cast to a list", BindException.Type.SERIALIZATION);
            }
        }
        return columns;
    }

    private List<String[]> buildRows(List<List<String>> columns) throws BindException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        int numColumns = columns.size();
        if (columns.get(0).isEmpty()) {
            throw new BindException("No binds found in first column", BindException.Type.SERIALIZATION);
        }
        int numRows = columns.get(0).size();
        for (int i = 0; i < numColumns; ++i) {
            int iNumRows = columns.get(i).size();
            if (columns.get(i).size() == numRows) continue;
            throw new BindException(String.format("Column %d has a different number of binds (%d) than column 1 (%d)", i, iNumRows, numRows), BindException.Type.SERIALIZATION);
        }
        for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
            String[] row = new String[numColumns];
            for (int colIdx = 0; colIdx < numColumns; ++colIdx) {
                row[colIdx] = columns.get(colIdx).get(rowIdx);
            }
            rows.add(row);
        }
        return rows;
    }

    private void writeRowsToCSV(List<String[]> rows) throws BindException {
        int numBytes = 0;
        int rowNum = 0;
        int fileCount = 0;
        while (rowNum < rows.size()) {
            File file = this.getFile(++fileCount);
            try {
                OutputStream out = this.openFile(file);
                Throwable throwable = null;
                try {
                    numBytes = 0;
                    while ((long)numBytes < this.fileSize && rowNum < rows.size()) {
                        byte[] csv = this.createCSVRecord(rows.get(rowNum));
                        numBytes += csv.length;
                        out.write(csv);
                        ++rowNum;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException ex) {
                throw new BindException(String.format("Exception encountered while writing to file: %s", ex.getMessage()), BindException.Type.SERIALIZATION);
            }
        }
    }

    private File getFile(int fileNum) {
        return this.bindDir.resolve(Integer.toString(fileNum)).toFile();
    }

    private OutputStream openFile(File file) throws BindException {
        try {
            return new GZIPOutputStream(new FileOutputStream(file));
        }
        catch (IOException ex) {
            throw new BindException(String.format("Failed to create output file %s: %s", file.toString(), ex.getMessage()), BindException.Type.SERIALIZATION);
        }
    }

    private byte[] createCSVRecord(String[] data) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(SnowflakeType.escapeForCSV(data[i]));
        }
        sb.append('\n');
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    private String getPutStmt(String bindDir, String stagePath) {
        return String.format(PUT_STMT, bindDir, File.separator, stagePath).replaceAll("\\\\", "\\\\\\\\");
    }

    private void putBinds() throws BindException {
        this.createStageIfNeeded();
        String putStatement = this.getPutStmt(this.bindDir.toString(), this.stagePath);
        for (int i = 0; i < 3; ++i) {
            try {
                SFStatement statement = new SFStatement(this.session);
                SFBaseResultSet putResult = statement.execute(putStatement, null);
                putResult.next();
                int column = putResult.getMetaData().getColumnIndex(SnowflakeFileTransferAgent.UploadColumns.status.name()) + 1;
                String status = putResult.getString(column);
                if (SnowflakeFileTransferAgent.ResultStatus.UPLOADED.name().equals(status)) {
                    return;
                }
                logger.warn("PUT statement failed. The response had status %s.", status);
                continue;
            }
            catch (SQLException | SFException ex) {
                logger.warn("Exception encountered during PUT operation. ", ex);
            }
        }
        throw new BindException("Failed to PUT files to stage.", BindException.Type.UPLOAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStageIfNeeded() throws BindException {
        if (this.session.getArrayBindStage() != null) {
            return;
        }
        SFSession sFSession = this.session;
        synchronized (sFSession) {
            if (this.session.getArrayBindStage() == null) {
                try {
                    SFStatement statement = new SFStatement(this.session);
                    statement.execute(CREATE_STAGE_STMT, null);
                    this.session.setArrayBindStage(STAGE_NAME);
                }
                catch (SQLException | SFException ex) {
                    this.session.setArrayBindStageThreshold(0);
                    throw new BindException(String.format("Failed to create temporary stage for array binds. %s", ex.getMessage()), BindException.Type.UPLOAD);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                if (Files.isDirectory(this.bindDir, new LinkOption[0])) {
                    for (String fileName : this.bindDir.toFile().list()) {
                        Files.delete(this.bindDir.resolve(fileName));
                    }
                    Files.delete(this.bindDir);
                }
            }
            catch (IOException ex) {
                logger.warn("Exception encountered while trying to clean local directory. ", ex);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public String getStagePath() {
        return this.stagePath;
    }

    public Path getBindDir() {
        return this.bindDir;
    }

    public static int arrayBindValueCount(Map<String, ParameterBindingDTO> bindValues) {
        if (!BindUploader.isArrayBind(bindValues)) {
            return 0;
        }
        ParameterBindingDTO bindSample = bindValues.values().iterator().next();
        List bindSampleValues = (List)bindSample.getValue();
        return bindValues.size() * bindSampleValues.size();
    }

    public static boolean isArrayBind(Map<String, ParameterBindingDTO> bindValues) {
        if (bindValues == null || bindValues.size() == 0) {
            return false;
        }
        ParameterBindingDTO bindSample = bindValues.values().iterator().next();
        return bindSample.getValue() instanceof List;
    }
}

