/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http.apache.client.impl;

import net.snowflake.client.jdbc.internal.amazonaws.http.AmazonHttpClient;
import net.snowflake.client.jdbc.internal.amazonaws.http.IdleConnectionReaper;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.SdkProxyRoutePlanner;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.client.impl.SdkHttpClient;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.utils.ApacheUtils;
import net.snowflake.client.jdbc.internal.amazonaws.http.client.ConnectionManagerFactory;
import net.snowflake.client.jdbc.internal.amazonaws.http.client.HttpClientFactory;
import net.snowflake.client.jdbc.internal.amazonaws.http.conn.ClientConnectionManagerFactory;
import net.snowflake.client.jdbc.internal.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import net.snowflake.client.jdbc.internal.amazonaws.http.protocol.SdkHttpRequestExecutor;
import net.snowflake.client.jdbc.internal.amazonaws.http.settings.HttpClientSettings;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import net.snowflake.client.jdbc.internal.apache.http.conn.HttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            LOG.info("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort());
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }
}

