/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryV2;

import java.io.IOException;
import java.util.LinkedList;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.telemetryV2.TelemetryEvent;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class TelemetryService {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TelemetryService.class);
    private static LinkedList<TelemetryEvent> queue = new LinkedList();
    private static TelemetryService telemetryService = null;
    private static String SERVER_URL = "https://syswm3rhj6.execute-api.us-west-2.amazonaws.com/sfctest/enqueue";
    private static int BATCH_SIZE = 100;
    private static boolean enabled = false;

    public static synchronized TelemetryService getInstance() {
        if (telemetryService == null) {
            telemetryService = new TelemetryService();
            Runtime.getRuntime().addShutdownHook(new TelemetryUploader());
        }
        return telemetryService;
    }

    public synchronized void setServerURL(String url) {
        SERVER_URL = url;
    }

    public synchronized void enable() {
        enabled = true;
    }

    public synchronized void disable() {
        enabled = false;
    }

    public synchronized boolean isEnabled() {
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TelemetryEvent event) {
        if (!enabled) {
            return;
        }
        LinkedList<TelemetryEvent> linkedList = queue;
        synchronized (linkedList) {
            queue.add(event);
            if (queue.size() >= BATCH_SIZE) {
                new TelemetryUploader().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (!enabled) {
            return;
        }
        LinkedList<TelemetryEvent> linkedList = queue;
        synchronized (linkedList) {
            if (!queue.isEmpty()) {
                new TelemetryUploader().start();
            }
        }
    }

    static String logsToString(LinkedList<TelemetryEvent> queue) {
        JSONArray logs = new JSONArray();
        for (TelemetryEvent event : queue) {
            logs.add(event);
        }
        return logs.toString();
    }

    public int size() {
        return queue.size();
    }

    static class TelemetryUploader
    extends Thread {
        TelemetryUploader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!enabled) {
                return;
            }
            LinkedList linkedList = queue;
            synchronized (linkedList) {
                if (queue.isEmpty()) {
                    logger.debug("skip to run telemetry uploader for empty queue");
                } else {
                    this.flushQueue();
                    logger.debug("run telemetry uploader");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void flushQueue() {
            String response = null;
            boolean success = true;
            try {
                HttpPost post = new HttpPost(SERVER_URL);
                post.setEntity(new StringEntity(TelemetryService.logsToString(queue)));
                post.setHeader("Content-type", "application/json");
                response = HttpUtil.executeRequest(post, 10, 0, null);
                logger.debug(response);
            }
            catch (SnowflakeSQLException e) {
                logger.error("Telemetry request failed, SnowflakeSQLException response: {}, exception: {}", response, e.getMessage());
                success = false;
                logger.info("Telemetry request success={} and clean the current queue", success);
                queue.clear();
            }
            catch (IOException e2) {
                logger.error("Telemetry request failed, IOExceptionresponse: {}, exception: {}", response, e2.getMessage());
                success = false;
                {
                    catch (Throwable throwable) {
                        logger.info("Telemetry request success={} and clean the current queue", success);
                        queue.clear();
                        throw throwable;
                    }
                }
                logger.info("Telemetry request success={} and clean the current queue", success);
                queue.clear();
            }
            logger.info("Telemetry request success={} and clean the current queue", success);
            queue.clear();
        }
    }
}

