/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.apache.commons.codec.binary.Base64;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.RSASSASigner;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;

class SessionUtilKeyPair {
    private final String userName;
    private final String accountName;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private static final String ISSUER_FMT = "%s.%s.%s";
    private static final String SUBJECT_FMT = "%s.%s";

    SessionUtilKeyPair(PrivateKey privateKey, String accountName, String userName) throws SFException {
        this.userName = userName.toUpperCase();
        this.accountName = accountName.toUpperCase();
        this.privateKey = privateKey;
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
            try {
                this.publicKey = KeyFactory.getInstance("RSA").generatePublic(rsaPublicKeySpec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new SFException(e, ErrorCode.INTERNAL_ERROR, "Error retrieving public key");
            }
        } else {
            throw new SFException(ErrorCode.INVALID_OR_UNSUPPORTED_PRIVATE_KEY, "Please use java.security.interfaces.RSAPrivateCrtKey.class");
        }
    }

    public String issueJwtToken() throws SFException {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        String sub = String.format(SUBJECT_FMT, this.accountName, this.userName);
        String iss = String.format(ISSUER_FMT, this.accountName, this.userName, this.calculatePublicKeyFingerprint(this.publicKey));
        Date iat = new Date(System.currentTimeMillis());
        Date exp = new Date(iat.getTime() + 60000L);
        JWTClaimsSet claimsSet = builder.issuer(iss).subject(sub).issueTime(iat).expirationTime(exp).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        RSASSASigner signer = new RSASSASigner(this.privateKey);
        try {
            signedJWT.sign(signer);
        }
        catch (JOSEException e) {
            throw new SFException(e, ErrorCode.FAILED_TO_GENERATE_JWT, new Object[0]);
        }
        return signedJWT.serialize();
    }

    private String calculatePublicKeyFingerprint(PublicKey publicKey) throws SFException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] sha256Hash = md.digest(publicKey.getEncoded());
            return "SHA256:" + Base64.encodeBase64String(sha256Hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SFException(e, ErrorCode.INTERNAL_ERROR, "Error when calculating fingerprint");
        }
    }
}

