/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.snowflake.client.jdbc.internal.google.api.MetricDescriptor;
import net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions;
import net.snowflake.client.jdbc.internal.google.api.gax.core.FixedCredentialsProvider;
import net.snowflake.client.jdbc.internal.google.api.gax.core.NoCredentialsProvider;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcTransportChannel;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.FixedTransportChannelProvider;
import net.snowflake.client.jdbc.internal.google.auth.Credentials;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.GoogleCredentials;
import net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3.MetricServiceClient;
import net.snowflake.client.jdbc.internal.google.cloud.monitoring.v3.MetricServiceSettings;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.AggregateByLabelMetricTimeSeriesBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.CloudMetricClient;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.CloudMetricClientImpl;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MetricConfiguration;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MetricTimeSeriesBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.collect.Lists;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.CreateMetricDescriptorRequest;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.ProjectName;
import net.snowflake.client.jdbc.internal.google.monitoring.v3.TimeSeries;
import net.snowflake.client.jdbc.internal.grpc.ManagedChannelBuilder;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.CompletableResultCode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.AggregationTemporality;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoublePointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.HistogramPointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.LongPointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.MetricData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.export.MetricExporter;
import net.snowflake.client.jdbc.internal.threeten.bp.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalMetricExporter
implements MetricExporter {
    private static final Logger logger = LoggerFactory.getLogger(InternalMetricExporter.class);
    private static final String PROJECT_NAME_PREFIX = "projects/";
    private static final int MAX_BATCH_SIZE = 200;
    private final CloudMetricClient metricServiceClient;
    private final String projectId;
    private final String prefix;
    private final MetricDescriptorStrategy metricDescriptorStrategy;
    private final Predicate<AttributeKey<?>> resourceAttributesFilter;
    private final boolean useCreateServiceTimeSeries;
    private final MonitoredResourceDescription monitoredResourceDescription;
    private final boolean instrumentationLibraryLabelsEnabled;

    InternalMetricExporter(String projectId, String prefix, CloudMetricClient client, MetricDescriptorStrategy descriptorStrategy, Predicate<AttributeKey<?>> resourceAttributesFilter, boolean useCreateServiceTimeSeries, MonitoredResourceDescription monitoredResourceDescription, boolean instrumentationLibraryLabelsEnabled) {
        this.projectId = projectId;
        this.prefix = prefix;
        this.metricServiceClient = client;
        this.metricDescriptorStrategy = descriptorStrategy;
        this.resourceAttributesFilter = resourceAttributesFilter;
        this.useCreateServiceTimeSeries = useCreateServiceTimeSeries;
        this.monitoredResourceDescription = monitoredResourceDescription;
        this.instrumentationLibraryLabelsEnabled = instrumentationLibraryLabelsEnabled;
    }

    static InternalMetricExporter createWithConfiguration(MetricConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        String prefix = configuration.getPrefix();
        MetricServiceSettings serviceClientSettings = configuration.getMetricServiceSettings() == null ? InternalMetricExporter.generateMetricServiceSettings(configuration) : configuration.getMetricServiceSettings();
        return new InternalMetricExporter(projectId, prefix, new CloudMetricClientImpl(MetricServiceClient.create(serviceClientSettings)), configuration.getDescriptorStrategy(), configuration.getResourceAttributesFilter(), configuration.getUseServiceTimeSeries(), configuration.getMonitoredResourceDescription(), configuration.getInstrumentationLibraryLabelsEnabled());
    }

    @VisibleForTesting
    static InternalMetricExporter createWithClient(String projectId, String prefix, CloudMetricClient metricServiceClient, MetricDescriptorStrategy descriptorStrategy, Predicate<AttributeKey<?>> resourceAttributesFilter, boolean useCreateServiceTimeSeries, MonitoredResourceDescription monitoredResourceDescription, boolean instrumentationLibraryLabelsEnabled) {
        return new InternalMetricExporter(projectId, prefix, metricServiceClient, descriptorStrategy, resourceAttributesFilter, useCreateServiceTimeSeries, monitoredResourceDescription, instrumentationLibraryLabelsEnabled);
    }

    private static MetricServiceSettings generateMetricServiceSettings(MetricConfiguration configuration) throws IOException {
        MetricServiceSettings.Builder builder = MetricServiceSettings.newBuilder();
        if (configuration.getInsecureEndpoint()) {
            builder.setCredentialsProvider(NoCredentialsProvider.create());
            builder.setTransportChannelProvider(FixedTransportChannelProvider.create(GrpcTransportChannel.create(((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(configuration.getMetricServiceEndpoint()).usePlaintext()).build())));
        } else {
            Credentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
            builder.setCredentialsProvider(FixedCredentialsProvider.create(Preconditions.checkNotNull(credentials, "Credentials not provided.")));
            builder.setEndpoint(configuration.getMetricServiceEndpoint());
        }
        builder.createMetricDescriptorSettings().setSimpleTimeoutNoRetries(Duration.ofMillis(configuration.getDeadline().toMillis()));
        return builder.build();
    }

    private void exportDescriptor(MetricDescriptor descriptor) {
        logger.trace("Creating metric descriptor: {}", (Object)descriptor);
        this.metricServiceClient.createMetricDescriptor(CreateMetricDescriptorRequest.newBuilder().setName(PROJECT_NAME_PREFIX + this.projectId).setMetricDescriptor(descriptor).build());
    }

    @Override
    public AggregationTemporality getAggregationTemporality(@Nonnull InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        AggregateByLabelMetricTimeSeriesBuilder builder = new AggregateByLabelMetricTimeSeriesBuilder(this.projectId, this.prefix, this.resourceAttributesFilter, this.monitoredResourceDescription, this.instrumentationLibraryLabelsEnabled);
        block7: for (MetricData metricData : metrics) {
            switch (metricData.getType()) {
                case LONG_GAUGE: {
                    for (LongPointData longPointData : metricData.getLongGaugeData().getPoints()) {
                        builder.recordPoint(metricData, longPointData);
                    }
                    continue block7;
                }
                case LONG_SUM: {
                    for (LongPointData longPointData : metricData.getLongSumData().getPoints()) {
                        builder.recordPoint(metricData, longPointData);
                    }
                    continue block7;
                }
                case DOUBLE_GAUGE: {
                    for (DoublePointData doublePointData : metricData.getDoubleGaugeData().getPoints()) {
                        builder.recordPoint(metricData, doublePointData);
                    }
                    continue block7;
                }
                case DOUBLE_SUM: {
                    for (DoublePointData doublePointData : metricData.getDoubleSumData().getPoints()) {
                        builder.recordPoint(metricData, doublePointData);
                    }
                    continue block7;
                }
                case HISTOGRAM: {
                    for (HistogramPointData histogramPointData : metricData.getHistogramData().getPoints()) {
                        builder.recordPoint(metricData, histogramPointData);
                    }
                    continue block7;
                }
                default: {
                    logger.error("OpenTelemetry Metric type {} not supported.", (Object)metricData.getType());
                }
            }
        }
        this.exportDescriptors(builder);
        List<TimeSeries> series = builder.getTimeSeries();
        Consumer<List<TimeSeries>> timeSeriesGenerator = timeSeries -> {
            if (this.useCreateServiceTimeSeries) {
                this.metricServiceClient.createServiceTimeSeries(ProjectName.of(this.projectId), (List<TimeSeries>)timeSeries);
            } else {
                this.metricServiceClient.createTimeSeries(ProjectName.of(this.projectId), (List<TimeSeries>)timeSeries);
            }
        };
        this.createTimeSeriesBatch(series, timeSeriesGenerator);
        if (series.size() < metrics.size()) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    private void exportDescriptors(MetricTimeSeriesBuilder timeSeriesBuilder) {
        if (this.useCreateServiceTimeSeries) {
            return;
        }
        try {
            Collection<MetricDescriptor> descriptors = timeSeriesBuilder.getDescriptors();
            if (!descriptors.isEmpty()) {
                this.metricDescriptorStrategy.exportDescriptors(descriptors, this::exportDescriptor);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create metric descriptors", (Throwable)e);
        }
    }

    private void createTimeSeriesBatch(List<TimeSeries> allTimesSeries, Consumer<List<TimeSeries>> timeSeriesGenerator) {
        List<List<TimeSeries>> batches = Lists.partition(allTimesSeries, 200);
        for (List<TimeSeries> timeSeries : batches) {
            timeSeriesGenerator.accept(new ArrayList<TimeSeries>(timeSeries));
        }
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.metricServiceClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }
}

