/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.TextNode;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONStyle;

public class SecretDetector {
    private static final Pattern AWS_KEY_PATTERN = Pattern.compile("(aws_key_id|aws_secret_key|access_key_id|secret_access_key)(\\s*=\\s*)'([^']+)'", 2);
    private static final Pattern AWS_TOKEN_PATTERN = Pattern.compile("(accessToken|tempToken|keySecret)\"\\s*:\\s*\"([a-z0-9/+]{32,}={0,2})\"", 2);
    private static final Pattern SAS_TOKEN_PATTERN = Pattern.compile("(sig|signature|AWSAccessKeyId|password|passcode)=([a-z0-9%/+]{16,})", 2);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(password|passcode|pwd)(['\"\\s:=]+)([a-z0-9!\"#$%&'\\()*+,-./:;<=>?@\\[\\]^_`\\{|\\}~]{6,})", 2);
    private static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("-----BEGIN PRIVATE KEY-----\\\\n([a-z0-9/+=\\\\n]{32,})\\\\n-----END PRIVATE KEY-----", 10);
    private static final Pattern PRIVATE_KEY_DATA_PATTERN = Pattern.compile("\"privateKeyData\": \"([a-z0-9/+=\\\\n]{10,})\"", 10);
    private static final Pattern CONNECTION_TOKEN_PATTERN = Pattern.compile("(token|assertion content)(['\"\\s:=]+)([a-z0-9=/_\\-+]{8,})", 2);
    private static final int MAX_LENGTH = 100000;
    private static String[] SENSITIVE_NAMES = new String[]{"access_key_id", "accesstoken", "aws_key_id", "aws_secret_key", "awsaccesskeyid", "keysecret", "passcode", "password", "privatekey", "privatekeydata", "secret_access_key", "sig", "signature", "temptoken"};
    private static Set<String> SENSITIVE_NAME_SET = new HashSet<String>(Arrays.asList(SENSITIVE_NAMES));

    public static boolean isSensitive(String name) {
        return SENSITIVE_NAME_SET.contains(name.toLowerCase());
    }

    private static boolean isSensitiveParameter(String name) {
        Pattern PASSWORD_IN_NAME = Pattern.compile(".*?(password|pwd|token|proxyuser).*?", 2);
        Matcher matcher = PASSWORD_IN_NAME.matcher(name);
        return SecretDetector.isSensitive(name) || matcher.matches();
    }

    public static String maskParameterValue(String key, String value) {
        if (SecretDetector.isSensitiveParameter(key)) {
            return "****";
        }
        return value;
    }

    private static String filterAWSKeys(String text) {
        Matcher matcher = AWS_KEY_PATTERN.matcher(text.length() <= 100000 ? text : text.substring(0, 100000));
        if (matcher.find()) {
            return matcher.replaceAll("$1$2'****'");
        }
        return text;
    }

    private static String filterSASTokens(String text) {
        Matcher matcher = SAS_TOKEN_PATTERN.matcher(text.length() <= 100000 ? text : text.substring(0, 100000));
        if (matcher.find()) {
            return matcher.replaceAll("$1=****");
        }
        return text;
    }

    private static String filterPassword(String text) {
        Matcher matcher = PASSWORD_PATTERN.matcher(text.length() <= 100000 ? text : text.substring(0, 100000));
        if (matcher.find()) {
            return matcher.replaceAll("$1$2**** ");
        }
        return text;
    }

    private static String filterConnectionTokens(String text) {
        Matcher matcher = CONNECTION_TOKEN_PATTERN.matcher(text.length() <= 100000 ? text : text.substring(0, 100000));
        if (matcher.find()) {
            return matcher.replaceAll("$1$2****");
        }
        return text;
    }

    public static String maskAWSSecret(String sql) {
        return SecretDetector.filterAWSKeys(sql);
    }

    public static String maskSASToken(String text) {
        return SecretDetector.filterSASTokens(text);
    }

    public static String maskSecrets(String text) {
        return SecretDetector.filterAccessTokens(SecretDetector.filterConnectionTokens(SecretDetector.filterPassword(SecretDetector.filterSASTokens(SecretDetector.filterAWSKeys(text)))));
    }

    public static String filterAccessTokens(String message) {
        Matcher gcsMatcher;
        Matcher azureMatcher;
        Matcher awsMatcher = AWS_TOKEN_PATTERN.matcher(message);
        if (awsMatcher.find()) {
            message = awsMatcher.replaceAll("$1\":\"XXXX\"");
        }
        if ((azureMatcher = SAS_TOKEN_PATTERN.matcher(message)).find()) {
            message = azureMatcher.replaceAll("$1=XXXX");
        }
        if ((gcsMatcher = PRIVATE_KEY_PATTERN.matcher(message)).find()) {
            message = gcsMatcher.replaceAll("-----BEGIN PRIVATE KEY-----\\\\nXXXX\\\\n-----END PRIVATE KEY-----");
        }
        if ((gcsMatcher = PRIVATE_KEY_DATA_PATTERN.matcher(message)).find()) {
            message = gcsMatcher.replaceAll("\"privateKeyData\": \"XXXX\"");
        }
        return message;
    }

    public static JSONObject maskJsonObject(JSONObject json) {
        for (Map.Entry entry : json.entrySet()) {
            if (entry.getValue() instanceof String) {
                entry.setValue(SecretDetector.maskSecrets((String)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof JSONArray) {
                SecretDetector.maskJsonArray((JSONArray)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof JSONObject)) continue;
            SecretDetector.maskJsonObject((JSONObject)entry.getValue());
        }
        return json;
    }

    public static JSONArray maskJsonArray(JSONArray array) {
        for (int i = 0; i < array.size(); ++i) {
            Object node = array.get(i);
            if (node instanceof JSONObject) {
                SecretDetector.maskJsonObject((JSONObject)node);
                continue;
            }
            if (node instanceof JSONArray) {
                SecretDetector.maskJsonArray((JSONArray)node);
                continue;
            }
            if (!(node instanceof String)) continue;
            array.set(i, SecretDetector.maskSecrets((String)node));
        }
        return array;
    }

    public static JsonNode maskJacksonNode(JsonNode node) {
        block4: {
            block5: {
                block3: {
                    if (!node.isTextual()) break block3;
                    String maskedText = SecretDetector.maskSecrets(node.textValue());
                    if (!maskedText.equals(node.textValue())) {
                        return new TextNode(maskedText);
                    }
                    break block4;
                }
                if (!node.isObject()) break block5;
                ObjectNode objNode = (ObjectNode)node;
                Iterator<String> fieldNames = objNode.fieldNames();
                while (fieldNames.hasNext()) {
                    String fieldName = fieldNames.next();
                    JsonNode tmpNode = SecretDetector.maskJacksonNode(objNode.get(fieldName));
                    if (!objNode.get(fieldName).isTextual()) continue;
                    objNode.set(fieldName, tmpNode);
                }
                break block4;
            }
            if (!node.isArray()) break block4;
            ArrayNode arrayNode = (ArrayNode)node;
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode tmpNode = SecretDetector.maskJacksonNode(arrayNode.get(i));
                if (!arrayNode.get(i).isTextual()) continue;
                arrayNode.set(i, tmpNode);
            }
        }
        return node;
    }

    public static class SecretDetectorJSONStyle
    extends JSONStyle {
        @Override
        public void objectNext(Appendable out) throws IOException {
            out.append(", ");
        }

        @Override
        public void arrayStop(Appendable out) throws IOException {
            out.append("] ");
        }

        @Override
        public void arrayNextElm(Appendable out) throws IOException {
            out.append(", ");
        }
    }
}

