/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.BasicAgreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.RawAgreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.agreement.X25519Agreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.agreement.X448Agreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.X448PrivateKeyParameters;

public class XDHBasicAgreement
implements BasicAgreement {
    private AsymmetricKeyParameter key;
    private RawAgreement agreement;
    private int fieldSize = 0;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof X25519PrivateKeyParameters) {
            this.fieldSize = 32;
            this.agreement = new X25519Agreement();
        } else if (cipherParameters instanceof X448PrivateKeyParameters) {
            this.fieldSize = 56;
            this.agreement = new X448Agreement();
        } else {
            throw new IllegalArgumentException("key is neither X25519 nor X448");
        }
        this.key = (AsymmetricKeyParameter)cipherParameters;
        this.agreement.init(cipherParameters);
    }

    @Override
    public int getFieldSize() {
        return this.fieldSize;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        byte[] byArray = new byte[this.fieldSize];
        this.agreement.calculateAgreement(cipherParameters, byArray, 0);
        return new BigInteger(1, byArray);
    }
}

