/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerRegistry;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.JsonUtil;
import net.snowflake.client.jdbc.internal.grpc.internal.ServiceConfigUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterManagerLoadBalancer;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public class ClusterManagerLoadBalancerProvider
extends LoadBalancerProvider {
    @Nullable
    private final LoadBalancerRegistry lbRegistry;

    public ClusterManagerLoadBalancerProvider() {
        this(null);
    }

    @VisibleForTesting
    ClusterManagerLoadBalancerProvider(@Nullable LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = lbRegistry;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "cluster_manager_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        LinkedHashMap<String, ServiceConfigUtil.PolicySelection> parsedChildPolicies = new LinkedHashMap<String, ServiceConfigUtil.PolicySelection>();
        try {
            Map<String, ?> childPolicies = JsonUtil.getObject(rawConfig, "childPolicy");
            if (childPolicies == null || childPolicies.isEmpty()) {
                return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No child policy provided for cluster_manager LB policy: " + rawConfig));
            }
            for (String name : childPolicies.keySet()) {
                Map<String, ?> childPolicy = JsonUtil.getObject(childPolicies, name);
                if (childPolicy == null) {
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No config for child " + name + " in cluster_manager LB policy: " + rawConfig));
                }
                List<ServiceConfigUtil.LbConfig> childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.getListOfObjects(childPolicy, "lbPolicy"));
                if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No config specified for child " + name + " in cluster_manager Lb policy: " + rawConfig));
                }
                LoadBalancerRegistry registry = this.lbRegistry != null ? this.lbRegistry : LoadBalancerRegistry.getDefaultRegistry();
                NameResolver.ConfigOrError selectedConfig = ServiceConfigUtil.selectLbPolicyFromList(childConfigCandidates, registry);
                if (selectedConfig.getError() != null) {
                    Status error = selectedConfig.getError();
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withCause(error.getCause()).withDescription(error.getDescription()).augmentDescription("Failed to select config for child " + name));
                }
                parsedChildPolicies.put(name, (ServiceConfigUtil.PolicySelection)selectedConfig.getConfig());
            }
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withCause(e).withDescription("Failed to parse cluster_manager LB config: " + rawConfig));
        }
        return NameResolver.ConfigOrError.fromConfig(new ClusterManagerConfig(parsedChildPolicies));
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterManagerLoadBalancer(helper);
    }

    static class ClusterManagerConfig {
        final Map<String, ServiceConfigUtil.PolicySelection> childPolicies;

        ClusterManagerConfig(Map<String, ServiceConfigUtil.PolicySelection> childPolicies) {
            this.childPolicies = Collections.unmodifiableMap(childPolicies);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClusterManagerConfig)) {
                return false;
            }
            ClusterManagerConfig config = (ClusterManagerConfig)o;
            return Objects.equals(this.childPolicies, config.childPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.childPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("childPolicies", this.childPolicies).toString();
        }
    }
}

