/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import net.snowflake.client.jdbc.internal.google.api.core.ApiClock;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetrySettings;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.HeaderProvider;
import net.snowflake.client.jdbc.internal.google.auth.Credentials;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceFactory;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceRpc;
import net.snowflake.client.jdbc.internal.google.cloud.TransportOptions;
import net.snowflake.client.jdbc.internal.google.cloud.http.HttpTransportOptions;
import net.snowflake.client.jdbc.internal.google.cloud.spi.ServiceRpcFactory;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpRetryAlgorithmManager;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageFactory;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageRetryStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.TransportCompatibility;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.StorageRpcFactory;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.HttpStorageRpc;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.StorageRpc;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
public class HttpStorageOptions
extends StorageOptions {
    private static final long serialVersionUID = -5302637952911052045L;
    private static final String API_SHORT_NAME = "Storage";
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of("https://www.googleapis.com/auth/devstorage.full_control");
    private static final String DEFAULT_HOST = "https://storage.googleapis.com";
    private final HttpRetryAlgorithmManager retryAlgorithmManager;

    private HttpStorageOptions(Builder builder, StorageOptions.StorageDefaults serviceDefaults) {
        super(builder, serviceDefaults);
        this.retryAlgorithmManager = new HttpRetryAlgorithmManager(MoreObjects.firstNonNull(builder.storageRetryStrategy, HttpStorageOptions.defaults().getStorageRetryStrategy()));
    }

    @Override
    protected Set<String> getScopes() {
        return SCOPES;
    }

    @InternalApi
    HttpRetryAlgorithmManager getRetryAlgorithmManager() {
        return this.retryAlgorithmManager;
    }

    @InternalApi
    StorageRpc getStorageRpcV1() {
        return (StorageRpc)this.getRpc();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HttpStorageOptions && this.baseEquals((HttpStorageOptions)obj);
    }

    public static Builder newBuilder() {
        return new Builder().setHost(DEFAULT_HOST);
    }

    public static HttpStorageOptions getDefaultInstance() {
        return HttpStorageOptions.newBuilder().build();
    }

    public static HttpStorageDefaults defaults() {
        return HttpStorageDefaults.INSTANCE;
    }

    @InternalApi
    public static class HttpStorageRpcFactory
    implements StorageRpcFactory,
    Serializable {
        private static final long serialVersionUID = -5896805045709989797L;

        @InternalApi
        @Deprecated
        public HttpStorageRpcFactory() {
        }

        @Override
        public ServiceRpc create(StorageOptions options) {
            if (options instanceof HttpStorageOptions) {
                HttpStorageOptions httpStorageOptions = (HttpStorageOptions)options;
                return new HttpStorageRpc(httpStorageOptions);
            }
            throw new IllegalArgumentException("Only HttpStorageOptions supported");
        }
    }

    @InternalApi
    public static class HttpStorageFactory
    implements StorageFactory,
    Serializable {
        private static final long serialVersionUID = 1063208433681579145L;

        @InternalApi
        @Deprecated
        public HttpStorageFactory() {
        }

        @Override
        public Storage create(StorageOptions options) {
            if (options instanceof HttpStorageOptions) {
                HttpStorageOptions httpStorageOptions = (HttpStorageOptions)options;
                return new StorageImpl(httpStorageOptions);
            }
            throw new IllegalArgumentException("Only HttpStorageOptions supported");
        }
    }

    public static final class HttpStorageDefaults
    extends StorageOptions.StorageDefaults {
        static final HttpStorageDefaults INSTANCE = new HttpStorageDefaults();
        static final StorageFactory STORAGE_FACTORY = new HttpStorageFactory();
        static final StorageRpcFactory STORAGE_RPC_FACTORY = new HttpStorageRpcFactory();

        private HttpStorageDefaults() {
        }

        public StorageFactory getDefaultServiceFactory() {
            return STORAGE_FACTORY;
        }

        public StorageRpcFactory getDefaultRpcFactory() {
            return STORAGE_RPC_FACTORY;
        }

        @Override
        public HttpTransportOptions getDefaultTransportOptions() {
            return HttpTransportOptions.newBuilder().build();
        }

        public StorageRetryStrategy getStorageRetryStrategy() {
            return StorageRetryStrategy.getDefaultStorageRetryStrategy();
        }
    }

    public static class Builder
    extends StorageOptions.Builder {
        private StorageRetryStrategy storageRetryStrategy;

        Builder() {
        }

        Builder(StorageOptions options) {
            super(options);
        }

        @Override
        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Storage.");
            }
            super.setTransportOptions(transportOptions);
            return this;
        }

        @Override
        public Builder setStorageRetryStrategy(StorageRetryStrategy storageRetryStrategy) {
            this.storageRetryStrategy = Objects.requireNonNull(storageRetryStrategy, "storageRetryStrategy must be non null");
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Builder setServiceFactory(ServiceFactory<Storage, StorageOptions> serviceFactory) {
            super.setServiceFactory(serviceFactory);
            return this;
        }

        @Override
        public Builder setClock(ApiClock clock) {
            super.setClock(clock);
            return this;
        }

        @Override
        public Builder setProjectId(String projectId) {
            super.setProjectId(projectId);
            return this;
        }

        @Override
        public Builder setHost(String host) {
            super.setHost(host);
            return this;
        }

        @Override
        public Builder setCredentials(Credentials credentials) {
            super.setCredentials(credentials);
            return this;
        }

        @Override
        public Builder setRetrySettings(RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        @Override
        public Builder setServiceRpcFactory(ServiceRpcFactory<StorageOptions> serviceRpcFactory) {
            super.setServiceRpcFactory(serviceRpcFactory);
            return this;
        }

        @Override
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            super.setHeaderProvider(headerProvider);
            return this;
        }

        @Override
        public Builder setClientLibToken(String clientLibToken) {
            super.setClientLibToken(clientLibToken);
            return this;
        }

        @Override
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @Override
        public HttpStorageOptions build() {
            return new HttpStorageOptions(this, HttpStorageOptions.defaults());
        }
    }
}

