/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Crc32cValue;
import net.snowflake.client.jdbc.internal.google.common.hash.Hashing;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

interface Hasher {
    default public @Nullable Crc32cValue.Crc32cLengthKnown hash(Supplier<ByteBuffer> b) {
        return this.hash(b.get());
    }

    public @Nullable Crc32cValue.Crc32cLengthKnown hash(ByteBuffer var1);

    public void validate(Crc32cValue<?> var1, Supplier<ByteBuffer> var2) throws IOException;

    public @Nullable Crc32cValue.Crc32cLengthKnown nullSafeConcat(Crc32cValue.Crc32cLengthKnown var1, Crc32cValue.Crc32cLengthKnown var2);

    public static Hasher noop() {
        return NoOpHasher.INSTANCE;
    }

    public static Hasher enabled() {
        return GuavaHasher.INSTANCE;
    }

    @Immutable
    public static class GuavaHasher
    implements Hasher {
        private static final GuavaHasher INSTANCE = new GuavaHasher();

        private GuavaHasher() {
        }

        @Override
        public Crc32cValue.Crc32cLengthKnown hash(ByteBuffer b) {
            int remaining = b.remaining();
            return Crc32cValue.of(Hashing.crc32c().hashBytes(b).asInt(), remaining);
        }

        @Override
        public void validate(Crc32cValue<?> expected, Supplier<ByteBuffer> b) throws IOException {
            Crc32cValue.Crc32cLengthKnown actual = this.hash(b);
            if (!actual.eqValue(expected)) {
                throw new IOException(String.format("Mismatch checksum value. Expected %s actual %s", expected.debugString(), actual.debugString()));
            }
        }

        @Override
        public @Nullable Crc32cValue.Crc32cLengthKnown nullSafeConcat(Crc32cValue.Crc32cLengthKnown r1, Crc32cValue.Crc32cLengthKnown r2) {
            if (r1 == null) {
                return r2;
            }
            return r1.concat(r2);
        }
    }

    @Immutable
    public static class NoOpHasher
    implements Hasher {
        private static final NoOpHasher INSTANCE = new NoOpHasher();

        private NoOpHasher() {
        }

        @Override
        public Crc32cValue.Crc32cLengthKnown hash(ByteBuffer b) {
            return null;
        }

        @Override
        public void validate(Crc32cValue<?> expected, Supplier<ByteBuffer> b) {
        }

        @Override
        public @Nullable Crc32cValue.Crc32cLengthKnown nullSafeConcat(Crc32cValue.Crc32cLengthKnown r1, Crc32cValue.Crc32cLengthKnown r2) {
            return null;
        }
    }
}

