/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.trace;

import net.snowflake.client.jdbc.internal.opencensus.common.Clock;
import net.snowflake.client.jdbc.internal.opencensus.internal.ZeroTimeClock;
import net.snowflake.client.jdbc.internal.opencensus.trace.Tracer;
import net.snowflake.client.jdbc.internal.opencensus.trace.config.TraceConfig;
import net.snowflake.client.jdbc.internal.opencensus.trace.export.ExportComponent;
import net.snowflake.client.jdbc.internal.opencensus.trace.propagation.PropagationComponent;

public abstract class TraceComponent {
    public abstract Tracer getTracer();

    public abstract PropagationComponent getPropagationComponent();

    public abstract Clock getClock();

    public abstract ExportComponent getExportComponent();

    public abstract TraceConfig getTraceConfig();

    static TraceComponent newNoopTraceComponent() {
        return new NoopTraceComponent();
    }

    private static final class NoopTraceComponent
    extends TraceComponent {
        private final ExportComponent noopExportComponent = ExportComponent.newNoopExportComponent();

        @Override
        public Tracer getTracer() {
            return Tracer.getNoopTracer();
        }

        @Override
        public PropagationComponent getPropagationComponent() {
            return PropagationComponent.getNoopPropagationComponent();
        }

        @Override
        public Clock getClock() {
            return ZeroTimeClock.getInstance();
        }

        @Override
        public ExportComponent getExportComponent() {
            return this.noopExportComponent;
        }

        @Override
        public TraceConfig getTraceConfig() {
            return TraceConfig.getNoopTraceConfig();
        }

        private NoopTraceComponent() {
        }
    }
}

