/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.JsonUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.RingHashLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.RingHashOptions;

@Internal
public final class RingHashLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long DEFAULT_MIN_RING_SIZE = 1024L;
    @VisibleForTesting
    static final long DEFAULT_MAX_RING_SIZE = 4096L;
    private static final boolean enableRingHash = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH"));

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RingHashLoadBalancer(helper);
    }

    @Override
    public boolean isAvailable() {
        return enableRingHash;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "ring_hash_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        Long minRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, "minRingSize");
        Long maxRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, "maxRingSize");
        long maxRingSizeCap = RingHashOptions.getRingSizeCap();
        if (minRingSize == null) {
            minRingSize = 1024L;
        }
        if (maxRingSize == null) {
            maxRingSize = 4096L;
        }
        if (minRingSize > maxRingSizeCap) {
            minRingSize = maxRingSizeCap;
        }
        if (maxRingSize > maxRingSizeCap) {
            maxRingSize = maxRingSizeCap;
        }
        if (minRingSize <= 0L || maxRingSize <= 0L || minRingSize > maxRingSize) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("Invalid 'mingRingSize'/'maxRingSize'"));
        }
        return NameResolver.ConfigOrError.fromConfig(new RingHashLoadBalancer.RingHashConfig(minRingSize, maxRingSize));
    }
}

