/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.InternalLogId;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.SynchronizationContext;
import net.snowflake.client.jdbc.internal.grpc.internal.ServiceConfigUtil;
import net.snowflake.client.jdbc.internal.grpc.util.ForwardingLoadBalancerHelper;
import net.snowflake.client.jdbc.internal.grpc.util.GracefulSwitchLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterManagerLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsLogger;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsNameResolver;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsSubchannelPickers;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

class ClusterManagerLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final int DELAYED_CHILD_DELETION_TIME_MINUTES = 15;
    private final Map<String, ChildLbState> childLbStates = new HashMap<String, ChildLbState>();
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final XdsLogger logger;
    private boolean resolvingAddresses;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.timeService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timeService");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("cluster_manager-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            boolean bl = this.acceptResolvedAddressesInternal(resolvedAddresses);
            return bl;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    public boolean acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        Map<String, ServiceConfigUtil.PolicySelection> newChildPolicies = config.childPolicies;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", newChildPolicies.keySet());
        for (Map.Entry<String, ServiceConfigUtil.PolicySelection> entry : newChildPolicies.entrySet()) {
            String name = entry.getKey();
            LoadBalancerProvider childPolicyProvider = entry.getValue().getProvider();
            Object childConfig = entry.getValue().getConfig();
            if (!this.childLbStates.containsKey(name)) {
                this.childLbStates.put(name, new ChildLbState(name, childPolicyProvider));
            } else {
                this.childLbStates.get(name).reactivate(childPolicyProvider);
            }
            GracefulSwitchLoadBalancer childLb = this.childLbStates.get(name).lb;
            LoadBalancer.ResolvedAddresses childAddresses = resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(childConfig).build();
            ((LoadBalancer)childLb).handleResolvedAddresses(childAddresses);
        }
        for (String name : this.childLbStates.keySet()) {
            if (newChildPolicies.containsKey(name)) continue;
            this.childLbStates.get(name).deactivate();
        }
        this.updateOverallBalancingState();
        return true;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (ChildLbState state : this.childLbStates.values()) {
            if (state.deactivated) continue;
            gotoTransientFailure = false;
            state.lb.handleNameResolutionError(error);
        }
        if (gotoTransientFailure) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (ChildLbState state : this.childLbStates.values()) {
            state.shutdown();
        }
        this.childLbStates.clear();
    }

    private void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        final HashMap<String, LoadBalancer.SubchannelPicker> childPickers = new HashMap<String, LoadBalancer.SubchannelPicker>();
        for (ChildLbState childLbState : this.childLbStates.values()) {
            if (childLbState.deactivated) continue;
            childPickers.put(childLbState.name, childLbState.currentPicker);
            overallState = ClusterManagerLoadBalancer.aggregateState(overallState, childLbState.currentState);
        }
        if (overallState != null) {
            LoadBalancer.SubchannelPicker picker = new LoadBalancer.SubchannelPicker(){

                @Override
                public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                    String clusterName = args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                    LoadBalancer.SubchannelPicker delegate = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                    if (delegate == null) {
                        return LoadBalancer.PickResult.withError(Status.UNAVAILABLE.withDescription("CDS encountered error: unable to find available subchannel for cluster " + clusterName));
                    }
                    return delegate.pickSubchannel(args);
                }

                public String toString() {
                    return MoreObjects.toStringHelper(this).add("pickers", childPickers).toString();
                }
            };
            this.helper.updateBalancingState(overallState, picker);
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private final class ChildLbState {
        private final String name;
        private final GracefulSwitchLoadBalancer lb;
        private LoadBalancerProvider policyProvider;
        private ConnectivityState currentState = ConnectivityState.CONNECTING;
        private LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;
        private boolean deactivated;
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        ChildLbState(String name, LoadBalancerProvider policyProvider) {
            this.name = name;
            this.policyProvider = policyProvider;
            this.lb = new GracefulSwitchLoadBalancer(new ChildLbStateHelper());
            this.lb.switchTo(policyProvider);
        }

        void deactivate() {
            if (this.deactivated) {
                return;
            }
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ChildLbState.this.shutdown();
                    ClusterManagerLoadBalancer.this.childLbStates.remove(ChildLbState.this.name);
                }
            }
            this.deletionTimer = ClusterManagerLoadBalancer.this.syncContext.schedule(new DeletionTask(), 15L, TimeUnit.MINUTES, ClusterManagerLoadBalancer.this.timeService);
            this.deactivated = true;
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deactivated", this.name);
        }

        void reactivate(LoadBalancerProvider policyProvider) {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
                this.deactivated = false;
                ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} reactivated", this.name);
            }
            if (!this.policyProvider.getPolicyName().equals(policyProvider.getPolicyName())) {
                ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} switching policy from {1} to {2}", this.name, this.policyProvider.getPolicyName(), policyProvider.getPolicyName());
                this.lb.switchTo(policyProvider);
                this.policyProvider = policyProvider;
            }
        }

        void shutdown() {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
            }
            this.lb.shutdown();
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deleted", this.name);
        }

        private final class ChildLbStateHelper
        extends ForwardingLoadBalancerHelper {
            private ChildLbStateHelper() {
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (!ClusterManagerLoadBalancer.this.childLbStates.containsKey(ChildLbState.this.name)) {
                    return;
                }
                ChildLbState.this.currentState = newState;
                ChildLbState.this.currentPicker = newPicker;
                if (!ChildLbState.this.deactivated && !ClusterManagerLoadBalancer.this.resolvingAddresses) {
                    ClusterManagerLoadBalancer.this.updateOverallBalancingState();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return ClusterManagerLoadBalancer.this.helper;
            }
        }
    }
}

