/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.internal.ServiceConfigUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterImplLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.Endpoints;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public final class ClusterImplLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "cluster_impl_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        throw new UnsupportedOperationException("not supported as top-level LB policy");
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterImplLoadBalancer(helper);
    }

    static final class ClusterImplConfig {
        final String cluster;
        @Nullable
        final String edsServiceName;
        @Nullable
        final Bootstrapper.ServerInfo lrsServerInfo;
        @Nullable
        final Long maxConcurrentRequests;
        @Nullable
        final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
        final List<Endpoints.DropOverload> dropCategories;
        final ServiceConfigUtil.PolicySelection childPolicy;

        ClusterImplConfig(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, List<Endpoints.DropOverload> dropCategories, ServiceConfigUtil.PolicySelection childPolicy, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
            this.cluster = Preconditions.checkNotNull(cluster, "cluster");
            this.edsServiceName = edsServiceName;
            this.lrsServerInfo = lrsServerInfo;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.tlsContext = tlsContext;
            this.dropCategories = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(dropCategories, "dropCategories")));
            this.childPolicy = Preconditions.checkNotNull(childPolicy, "childPolicy");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("cluster", this.cluster).add("edsServiceName", this.edsServiceName).add("lrsServerInfo", this.lrsServerInfo).add("maxConcurrentRequests", this.maxConcurrentRequests).add("dropCategories", this.dropCategories).add("childPolicy", this.childPolicy).toString();
        }
    }
}

