/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.snowflake.client.jdbc.internal.grpc.BindableService;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.HandlerRegistry;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.ServerMethodDefinition;
import net.snowflake.client.jdbc.internal.grpc.ServerServiceDefinition;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/933")
public final class MutableHandlerRegistry
extends HandlerRegistry {
    private final ConcurrentMap<String, ServerServiceDefinition> services = new ConcurrentHashMap<String, ServerServiceDefinition>();

    @Nullable
    public ServerServiceDefinition addService(ServerServiceDefinition service) {
        return this.services.put(service.getServiceDescriptor().getName(), service);
    }

    @Nullable
    public ServerServiceDefinition addService(BindableService bindableService) {
        return this.addService(bindableService.bindService());
    }

    public boolean removeService(ServerServiceDefinition service) {
        return this.services.remove(service.getServiceDescriptor().getName(), service);
    }

    @Override
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2222")
    public List<ServerServiceDefinition> getServices() {
        return Collections.unmodifiableList(new ArrayList(this.services.values()));
    }

    @Override
    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
        String serviceName = MethodDescriptor.extractFullServiceName(methodName);
        if (serviceName == null) {
            return null;
        }
        ServerServiceDefinition service = (ServerServiceDefinition)this.services.get(serviceName);
        if (service == null) {
            return null;
        }
        return service.getMethod(methodName);
    }
}

