/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.trace.unsafe;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.grpc.Context;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opencensus.internal.Provider;
import net.snowflake.client.jdbc.internal.opencensus.trace.ContextHandle;
import net.snowflake.client.jdbc.internal.opencensus.trace.ContextManager;
import net.snowflake.client.jdbc.internal.opencensus.trace.Span;
import net.snowflake.client.jdbc.internal.opencensus.trace.unsafe.ContextHandleImpl;
import net.snowflake.client.jdbc.internal.opencensus.trace.unsafe.ContextManagerImpl;

public class ContextHandleUtils {
    private static final Logger LOGGER = Logger.getLogger(ContextHandleUtils.class.getName());
    private static final ContextManager CONTEXT_MANAGER = ContextHandleUtils.loadContextManager(ContextManager.class.getClassLoader());

    private ContextHandleUtils() {
    }

    private static ContextManager loadContextManager(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("io.opentelemetry.opencensusshim.OpenTelemetryContextManager", true, classLoader), ContextManager.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.FINE, "Couldn't load full implementation for OpenTelemetry context manager, now loading original implementation.", e);
            return new ContextManagerImpl();
        }
    }

    public static ContextHandle currentContext() {
        return CONTEXT_MANAGER.currentContext();
    }

    public static ContextHandle withValue(ContextHandle context, @Nullable Span span) {
        return CONTEXT_MANAGER.withValue(context, span);
    }

    public static Span getValue(ContextHandle context) {
        return CONTEXT_MANAGER.getValue(context);
    }

    @Nullable
    public static Context tryExtractGrpcContext(ContextHandle handle) {
        if (handle instanceof ContextHandleImpl) {
            return ((ContextHandleImpl)handle).getContext();
        }
        return null;
    }
}

