/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.log.ArrowLogger;
import net.snowflake.client.jdbc.internal.apache.arrow.log.ArrowLoggerFactory;
import net.snowflake.client.jdbc.internal.apache.arrow.util.AutoCloseables;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorUnloader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.DictionaryProvider;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.WriteChannel;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowBlock;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.IpcOption;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageSerializer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Schema;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.DictionaryUtility;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.validate.MetadataV4UnionChecker;

public abstract class ArrowWriter
implements AutoCloseable {
    protected static final ArrowLogger LOGGER = ArrowLoggerFactory.getLogger(ArrowWriter.class);
    protected final Schema schema;
    protected final WriteChannel out;
    private final VectorUnloader unloader;
    private final List<ArrowDictionaryBatch> dictionaries;
    private boolean started = false;
    private boolean ended = false;
    private boolean dictWritten = false;
    protected IpcOption option;

    protected ArrowWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out) {
        this(root, provider, out, IpcOption.DEFAULT);
    }

    protected ArrowWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, IpcOption option) {
        this.unloader = new VectorUnloader(root);
        this.out = new WriteChannel(out);
        this.option = option;
        ArrayList<Field> fields = new ArrayList<Field>(root.getSchema().getFields().size());
        HashSet<Long> dictionaryIdsUsed = new HashSet<Long>();
        MetadataV4UnionChecker.checkForUnion(root.getSchema().getFields().iterator(), option.metadataVersion);
        for (Field field : root.getSchema().getFields()) {
            fields.add(DictionaryUtility.toMessageFormat(field, provider, dictionaryIdsUsed));
        }
        this.dictionaries = new ArrayList<ArrowDictionaryBatch>(dictionaryIdsUsed.size());
        Iterator<Field> iterator = dictionaryIdsUsed.iterator();
        while (iterator.hasNext()) {
            long id = (Long)((Object)iterator.next());
            Dictionary dictionary = provider.lookup(id);
            FieldVector vector = dictionary.getVector();
            int count = vector.getValueCount();
            VectorSchemaRoot dictRoot = new VectorSchemaRoot(Collections.singletonList(vector.getField()), Collections.singletonList(vector), count);
            VectorUnloader unloader = new VectorUnloader(dictRoot);
            ArrowRecordBatch batch = unloader.getRecordBatch();
            this.dictionaries.add(new ArrowDictionaryBatch(id, batch));
        }
        this.schema = new Schema(fields, root.getSchema().getCustomMetadata());
    }

    public void start() throws IOException {
        this.ensureStarted();
    }

    public void writeBatch() throws IOException {
        this.ensureStarted();
        this.ensureDictionariesWritten();
        try (ArrowRecordBatch batch = this.unloader.getRecordBatch();){
            this.writeRecordBatch(batch);
        }
    }

    protected ArrowBlock writeDictionaryBatch(ArrowDictionaryBatch batch) throws IOException {
        ArrowBlock block = MessageSerializer.serialize(this.out, batch, this.option);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DictionaryRecordBatch at {}, metadata: {}, body: {}", block.getOffset(), block.getMetadataLength(), block.getBodyLength());
        }
        return block;
    }

    protected ArrowBlock writeRecordBatch(ArrowRecordBatch batch) throws IOException {
        ArrowBlock block = MessageSerializer.serialize(this.out, batch, this.option);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("RecordBatch at {}, metadata: {}, body: {}", block.getOffset(), block.getMetadataLength(), block.getBodyLength());
        }
        return block;
    }

    public void end() throws IOException {
        this.ensureStarted();
        this.ensureEnded();
    }

    public long bytesWritten() {
        return this.out.getCurrentPosition();
    }

    private void ensureStarted() throws IOException {
        if (!this.started) {
            this.started = true;
            this.startInternal(this.out);
            MessageSerializer.serialize(this.out, this.schema, this.option);
        }
    }

    private void ensureDictionariesWritten() throws IOException {
        if (!this.dictWritten) {
            this.dictWritten = true;
            try {
                for (ArrowDictionaryBatch batch : this.dictionaries) {
                    this.writeDictionaryBatch(batch);
                }
            }
            finally {
                try {
                    AutoCloseables.close(this.dictionaries);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred while closing dictionaries.", e);
                }
            }
        }
    }

    private void ensureEnded() throws IOException {
        if (!this.ended) {
            this.ended = true;
            this.endInternal(this.out);
        }
    }

    protected void startInternal(WriteChannel out) throws IOException {
    }

    protected void endInternal(WriteChannel out) throws IOException {
    }

    @Override
    public void close() {
        try {
            this.end();
            this.out.close();
            if (!this.dictWritten) {
                AutoCloseables.close(this.dictionaries);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

