/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cert.crmf.bc;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.crmf.EncryptedValue;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.crmf.CRMFException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.KeyWrapper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OutputEncryptor;

public class BcEncryptedValueBuilder
extends EncryptedValueBuilder {
    public BcEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(AsymmetricKeyParameter asymmetricKeyParameter) throws CRMFException, IOException {
        return this.build(PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter));
    }
}

