/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class DateConverter
extends AbstractArrowVectorConverter {
    private DateDayVector dateVector;
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");

    public DateConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.DATE.name(), fieldVector, columnIndex, context);
        this.dateVector = (DateDayVector)fieldVector;
    }

    private Date getDate(int index, TimeZone jvmTz, boolean useDateFormat) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        int val = this.dateVector.getDataBuffer().getInt(index * 4);
        if (jvmTz == null || this.sessionTimeZone == null || !useDateFormat) {
            return ArrowResultUtil.getDate(val);
        }
        return ArrowResultUtil.getDate(val, jvmTz, this.sessionTimeZone);
    }

    @Override
    public Date toDate(int index, TimeZone jvmTz, boolean useDateFormat) throws SFException {
        return this.getDate(index, jvmTz, useDateFormat);
    }

    @Override
    public int toInt(int index) {
        if (this.isNull(index)) {
            return 0;
        }
        int val = this.dateVector.getDataBuffer().getInt(index * 4);
        return val;
    }

    @Override
    public short toShort(int index) throws SFException {
        try {
            return (short)this.toInt(index);
        }
        catch (ClassCastException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "short", this.toInt(index));
        }
    }

    @Override
    public long toLong(int index) {
        return this.toInt(index);
    }

    @Override
    public float toFloat(int index) {
        return this.toInt(index);
    }

    @Override
    public double toDouble(int index) {
        return this.toInt(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return BigDecimal.valueOf(this.toInt(index));
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        Date date = this.toDate(index, tz, true);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getDateFormatter() == null) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.context.getSession(), new SFException(ErrorCode.INTERNAL_ERROR, "missing date formatter"), null, null);
        }
        Date date = this.getDate(index, timeZoneUTC, false);
        return date == null ? null : ResultUtil.getDateAsString(date, this.context.getDateFormatter());
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toDate(index, TimeZone.getDefault(), false);
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        Date val = this.toDate(index, TimeZone.getDefault(), false);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", val);
    }
}

