/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.io.StringWriter;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DecryptRequest;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;

public class DecryptRequestMarshaller
implements Marshaller<Request<DecryptRequest>, DecryptRequest> {
    @Override
    public Request<DecryptRequest> marshall(DecryptRequest decryptRequest) {
        if (decryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DecryptRequest> request = new DefaultRequest<DecryptRequest>(decryptRequest, "AWSKMS");
        String target = "TrentService.Decrypt";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (decryptRequest.getCiphertextBlob() != null) {
                jsonWriter.key("CiphertextBlob").value(decryptRequest.getCiphertextBlob());
            }
            if (decryptRequest.getEncryptionContext() != null && !decryptRequest.getEncryptionContext().isEmpty()) {
                jsonWriter.key("EncryptionContext");
                jsonWriter.object();
                for (Map.Entry<String, String> encryptionContextListValue : decryptRequest.getEncryptionContext().entrySet()) {
                    if (encryptionContextListValue.getValue() == null) continue;
                    jsonWriter.key(encryptionContextListValue.getKey());
                    jsonWriter.value(encryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)decryptRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

