/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http;

import java.io.IOException;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceResponse;
import net.snowflake.client.jdbc.internal.amazonaws.ResponseMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpResponse;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpResponseHandler;
import net.snowflake.client.jdbc.internal.amazonaws.internal.CRC32MismatchException;
import net.snowflake.client.jdbc.internal.amazonaws.transform.JsonUnmarshallerContext;
import net.snowflake.client.jdbc.internal.amazonaws.transform.JsonUnmarshallerContextImpl;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.transform.VoidJsonUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;

public class JsonResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog("net.snowflake.client.jdbc.internal.amazonaws.request");
    private static JsonFactory jsonFactory = new JsonFactory();
    public boolean needsConnectionLeftOpen = false;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidJsonUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        log.trace("Parsing service response JSON");
        String CRC32Checksum = response.getHeaders().get("x-amz-crc32");
        CRC32ChecksumCalculatingInputStream crc32ChecksumInputStream = null;
        JsonParser jsonParser = null;
        if (!this.needsConnectionLeftOpen) {
            if (CRC32Checksum != null) {
                crc32ChecksumInputStream = new CRC32ChecksumCalculatingInputStream(response.getContent());
                jsonParser = jsonFactory.createParser(crc32ChecksumInputStream);
            } else {
                jsonParser = jsonFactory.createParser(response.getContent());
            }
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            JsonUnmarshallerContextImpl unmarshallerContext = new JsonUnmarshallerContextImpl(jsonParser, response);
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            if (CRC32Checksum != null) {
                long serverSideCRC = Long.parseLong(CRC32Checksum);
                long clientSideCRC = crc32ChecksumInputStream.getCRC32Checksum();
                if (clientSideCRC != serverSideCRC) {
                    throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side");
                }
            }
            awsResponse.setResult(result);
            Map<String, String> metadata = ((JsonUnmarshallerContext)unmarshallerContext).getMetadata();
            metadata.put("AWS_REQUEST_ID", response.getHeaders().get("x-amzn-RequestId"));
            awsResponse.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace("Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        finally {
            if (!this.needsConnectionLeftOpen) {
                try {
                    jsonParser.close();
                }
                catch (IOException e) {
                    log.warn("Error closing json parser", e);
                }
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }
}

