/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.logs.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.logs.model.OutputLogEvent;

public class GetLogEventsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<OutputLogEvent> events;
    private String nextForwardToken;
    private String nextBackwardToken;

    public List<OutputLogEvent> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<OutputLogEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public GetLogEventsResult withEvents(OutputLogEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<OutputLogEvent>(events.length));
        }
        for (OutputLogEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public GetLogEventsResult withEvents(Collection<OutputLogEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public String getNextForwardToken() {
        return this.nextForwardToken;
    }

    public void setNextForwardToken(String nextForwardToken) {
        this.nextForwardToken = nextForwardToken;
    }

    public GetLogEventsResult withNextForwardToken(String nextForwardToken) {
        this.nextForwardToken = nextForwardToken;
        return this;
    }

    public String getNextBackwardToken() {
        return this.nextBackwardToken;
    }

    public void setNextBackwardToken(String nextBackwardToken) {
        this.nextBackwardToken = nextBackwardToken;
    }

    public GetLogEventsResult withNextBackwardToken(String nextBackwardToken) {
        this.nextBackwardToken = nextBackwardToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getNextForwardToken() != null) {
            sb.append("NextForwardToken: " + this.getNextForwardToken() + ",");
        }
        if (this.getNextBackwardToken() != null) {
            sb.append("NextBackwardToken: " + this.getNextBackwardToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextForwardToken() == null ? 0 : this.getNextForwardToken().hashCode());
        hashCode = 31 * hashCode + (this.getNextBackwardToken() == null ? 0 : this.getNextBackwardToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsResult)) {
            return false;
        }
        GetLogEventsResult other = (GetLogEventsResult)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getNextForwardToken() == null ^ this.getNextForwardToken() == null) {
            return false;
        }
        if (other.getNextForwardToken() != null && !other.getNextForwardToken().equals(this.getNextForwardToken())) {
            return false;
        }
        if (other.getNextBackwardToken() == null ^ this.getNextBackwardToken() == null) {
            return false;
        }
        return other.getNextBackwardToken() == null || other.getNextBackwardToken().equals(this.getNextBackwardToken());
    }

    public GetLogEventsResult clone() {
        try {
            return (GetLogEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

