/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.Base64Variant;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.FormatSchema;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonEncoding;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.PrettyPrinter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.Version;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.Versioned;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.CharacterEscapes;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.SegmentedStringWriter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.TypeReference;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.util.ByteArrayBuilder;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.util.Instantiatable;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.MapperFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationConfig;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.ContextAttributes;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.MapperConfigBase;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.PackageVersion;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.FilterProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.SerializerFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.TypeFactory;

public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = -7040667122552707164L;
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _generatorFactory;
    protected final JavaType _rootType;
    protected final JsonSerializer<Object> _rootSerializer;
    protected final PrettyPrinter _prettyPrinter;
    protected final FormatSchema _schema;
    protected final CharacterEscapes _characterEscapes;
    protected final boolean _cfgBigDecimalAsPlain;

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._cfgBigDecimalAsPlain = this._config.isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN);
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        if (javaType != null) {
            javaType = javaType.withStaticTyping();
        }
        this._rootType = javaType;
        this._prettyPrinter = prettyPrinter;
        this._schema = null;
        this._characterEscapes = null;
        this._rootSerializer = this._prefetchRootSerializer(serializationConfig, javaType);
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._cfgBigDecimalAsPlain = this._config.isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN);
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._rootType = null;
        this._rootSerializer = null;
        this._prettyPrinter = null;
        this._schema = null;
        this._characterEscapes = null;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._cfgBigDecimalAsPlain = this._config.isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN);
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._rootType = null;
        this._rootSerializer = null;
        this._prettyPrinter = null;
        this._schema = formatSchema;
        this._characterEscapes = null;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, JavaType javaType, JsonSerializer<Object> jsonSerializer, PrettyPrinter prettyPrinter, FormatSchema formatSchema, CharacterEscapes characterEscapes) {
        this._config = serializationConfig;
        this._cfgBigDecimalAsPlain = this._config.isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN);
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._rootType = javaType;
        this._rootSerializer = jsonSerializer;
        this._prettyPrinter = prettyPrinter;
        this._schema = formatSchema;
        this._characterEscapes = characterEscapes;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._cfgBigDecimalAsPlain = this._config.isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN);
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._schema = objectWriter._schema;
        this._characterEscapes = objectWriter._characterEscapes;
        this._rootType = objectWriter._rootType;
        this._rootSerializer = objectWriter._rootSerializer;
        this._prettyPrinter = objectWriter._prettyPrinter;
    }

    protected ObjectWriter(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        this._config = objectWriter._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, jsonFactory.requiresPropertyOrdering());
        this._cfgBigDecimalAsPlain = objectWriter._cfgBigDecimalAsPlain;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._schema = objectWriter._schema;
        this._characterEscapes = objectWriter._characterEscapes;
        this._rootType = objectWriter._rootType;
        this._rootSerializer = objectWriter._rootSerializer;
        this._prettyPrinter = objectWriter._prettyPrinter;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.with(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.without(serializationFeature, serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        SerializationConfig serializationConfig = this._config.withoutFeatures(serializationFeatureArray);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = this._config.with(dateFormat);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(new DefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        return new ObjectWriter(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == this._prettyPrinter) {
            return this;
        }
        if (prettyPrinter == null) {
            prettyPrinter = NULL_PRETTY_PRINTER;
        }
        return new ObjectWriter(this, this._config, this._rootType, this._rootSerializer, prettyPrinter, this._schema, this._characterEscapes);
    }

    public ObjectWriter withRootName(String string) {
        SerializationConfig serializationConfig = this._config.withRootName(string);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withSchema(FormatSchema formatSchema) {
        if (this._schema == formatSchema) {
            return this;
        }
        this._verifySchemaType(formatSchema);
        return new ObjectWriter(this, this._config, this._rootType, this._rootSerializer, this._prettyPrinter, formatSchema, this._characterEscapes);
    }

    public ObjectWriter withType(JavaType javaType) {
        javaType = javaType.withStaticTyping();
        JsonSerializer<Object> jsonSerializer = this._prefetchRootSerializer(this._config, javaType);
        return new ObjectWriter(this, this._config, javaType, jsonSerializer, this._prettyPrinter, this._schema, this._characterEscapes);
    }

    public ObjectWriter withType(Class<?> clazz) {
        return this.withType(this._config.constructType(clazz));
    }

    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.withType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectWriter withView(Class<?> clazz) {
        MapperConfigBase mapperConfigBase = this._config.withView((Class)clazz);
        return mapperConfigBase == this._config ? this : new ObjectWriter(this, (SerializationConfig)mapperConfigBase);
    }

    public ObjectWriter with(Locale locale) {
        SerializationConfig serializationConfig = this._config.with(locale);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(TimeZone timeZone) {
        SerializationConfig serializationConfig = this._config.with(timeZone);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(Base64Variant base64Variant) {
        SerializationConfig serializationConfig = this._config.with(base64Variant);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter with(CharacterEscapes characterEscapes) {
        if (this._characterEscapes == characterEscapes) {
            return this;
        }
        return new ObjectWriter(this, this._config, this._rootType, this._rootSerializer, this._prettyPrinter, this._schema, characterEscapes);
    }

    public ObjectWriter with(JsonFactory jsonFactory) {
        if (jsonFactory == this._generatorFactory) {
            return this;
        }
        return new ObjectWriter(this, jsonFactory);
    }

    public ObjectWriter with(ContextAttributes contextAttributes) {
        SerializationConfig serializationConfig = this._config.with(contextAttributes);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withAttributes(Map<Object, Object> map) {
        SerializationConfig serializationConfig = (SerializationConfig)this._config.withAttributes(map);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withAttribute(Object object, Object object2) {
        SerializationConfig serializationConfig = (SerializationConfig)this._config.withAttribute(object, object2);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter withoutAttribute(Object object) {
        SerializationConfig serializationConfig = (SerializationConfig)this._config.withoutAttribute(object);
        return serializationConfig == this._config ? this : new ObjectWriter(this, serializationConfig);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._generatorFactory.isEnabled(feature);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    @Deprecated
    public JsonFactory getJsonFactory() {
        return this._generatorFactory;
    }

    public JsonFactory getFactory() {
        return this._generatorFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._rootSerializer != null;
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configureJsonGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, this._config);
        } else {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public void writeValue(File file, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._generatorFactory.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._generatorFactory.createGenerator(writer), object);
    }

    public String writeValueAsString(Object object) throws JsonProcessingException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._generatorFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._generatorFactory.createGenerator(segmentedStringWriter), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) throws JsonProcessingException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._generatorFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._generatorFactory.createGenerator(byteArrayBuilder, JsonEncoding.UTF8), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider(this._config).acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider(this._config).hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        return this._serializerProvider(this._config).hasSerializerFor(clazz, atomicReference);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._generatorFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._generatorFactory.getFormatName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configureJsonGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object, this._config);
            return;
        }
        boolean bl = false;
        try {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(this._config).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable closeable = (Closeable)object;
        try {
            if (this._rootType == null) {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator = null;
            jsonGenerator2.close();
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (jsonGenerator != null) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable closeable = (Closeable)object;
        try {
            if (this._rootType == null) {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            } else {
                this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object, this._rootType, this._rootSerializer);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected JsonSerializer<Object> _prefetchRootSerializer(SerializationConfig serializationConfig, JavaType javaType) {
        if (javaType == null || !this._config.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
            return null;
        }
        try {
            return this._serializerProvider(serializationConfig).findTypedValueSerializer(javaType, true, null);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    private void _configureJsonGenerator(JsonGenerator jsonGenerator) {
        if (this._prettyPrinter != null) {
            PrettyPrinter prettyPrinter = this._prettyPrinter;
            if (prettyPrinter == NULL_PRETTY_PRINTER) {
                jsonGenerator.setPrettyPrinter(null);
            } else {
                if (prettyPrinter instanceof Instantiatable) {
                    prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
                }
                jsonGenerator.setPrettyPrinter(prettyPrinter);
            }
        } else if (this._config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (this._characterEscapes != null) {
            jsonGenerator.setCharacterEscapes(this._characterEscapes);
        }
        if (this._schema != null) {
            jsonGenerator.setSchema(this._schema);
        }
        if (this._cfgBigDecimalAsPlain) {
            jsonGenerator.enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        }
    }
}

