/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeBasicDataSource
implements DataSource {
    private String url;
    private String serverName;
    private String user;
    private String password;
    private int portNumber = 0;
    private Properties properties = new Properties();
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeBasicDataSource.class);

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.properties.put("user", username);
        this.properties.put("password", password);
        try {
            Connection con = DriverManager.getConnection(this.getUrl(), this.properties);
            if (logger.isTraceEnabled()) {
                logger.trace("Created a connection for {} at {}", this.user, this.getUrl());
            }
            return con;
        }
        catch (SQLException e) {
            logger.error("Failed to create a connection for {} at {}: {}", this.user, this.getUrl(), e);
            throw e;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        try {
            return Integer.parseInt(this.properties.getProperty("loginTimeout"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.properties.put("loginTimeout", (Object)seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDatabaseName(String databaseName) {
        this.properties.put("db", databaseName);
    }

    public void setSchema(String schema) {
        this.properties.put("schema", schema);
    }

    public void setWarehouse(String warehouse) {
        this.properties.put("warehouse", warehouse);
    }

    public void setRole(String role) {
        this.properties.put("role", role);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setAccount(String account) {
        this.properties.put("account", account);
    }

    public void setSsl(boolean ssl) {
        this.properties.put("ssl", String.valueOf(ssl));
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        StringBuilder url = new StringBuilder(100);
        url.append("jdbc:snowflake://");
        url.append(this.serverName);
        if (this.portNumber != 0) {
            url.append(":").append(this.portNumber);
        }
        return url.toString();
    }

    static {
        try {
            Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load net.snowflake.client.jdbc.SnowflakeDriver. Please check if you have proper Snowflake JDBC Driver jar on the classpath", e);
        }
    }
}

