/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal;

import java.net.URI;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceClient;
import net.snowflake.client.jdbc.internal.amazonaws.auth.RegionAwareSigner;
import net.snowflake.client.jdbc.internal.amazonaws.auth.Signer;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.RequestHandler2;
import net.snowflake.client.jdbc.internal.amazonaws.http.ExecutionContext;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.util.AwsHostNameUtils;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class S3ExecutionContext
extends ExecutionContext {
    private static final Log log = LogFactory.getLog(AmazonS3Client.class);
    private Signer signer;

    public S3ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        super(requestHandler2s, isMetricEnabled, awsClient);
    }

    @Override
    public void setSigner(Signer signer) {
        this.signer = signer;
    }

    @Override
    public Signer getSignerByURI(URI uri) {
        AmazonWebServiceClient awsClient = this.getAwsClient();
        if (awsClient != null && awsClient.getSignerRegionOverride() != null) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName(uri.getHost(), "s3"));
            }
            catch (RuntimeException e) {
                log.warn("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region", e);
            }
        }
        return this.signer;
    }
}

