/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.io.StringWriter;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.CreateGrantRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GrantConstraints;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;

public class CreateGrantRequestMarshaller
implements Marshaller<Request<CreateGrantRequest>, CreateGrantRequest> {
    @Override
    public Request<CreateGrantRequest> marshall(CreateGrantRequest createGrantRequest) {
        if (createGrantRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateGrantRequest> request = new DefaultRequest<CreateGrantRequest>(createGrantRequest, "AWSKMS");
        String target = "TrentService.CreateGrant";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            GrantConstraints constraints;
            ListWithAutoConstructFlag operationsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createGrantRequest.getKeyId() != null) {
                jsonWriter.key("KeyId").value(createGrantRequest.getKeyId());
            }
            if (createGrantRequest.getGranteePrincipal() != null) {
                jsonWriter.key("GranteePrincipal").value(createGrantRequest.getGranteePrincipal());
            }
            if (createGrantRequest.getRetiringPrincipal() != null) {
                jsonWriter.key("RetiringPrincipal").value(createGrantRequest.getRetiringPrincipal());
            }
            if (!((operationsList = (ListWithAutoConstructFlag)createGrantRequest.getOperations()) == null || operationsList.isAutoConstruct() && operationsList.isEmpty())) {
                jsonWriter.key("Operations");
                jsonWriter.array();
                for (String operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    jsonWriter.value(operationsListValue);
                }
                jsonWriter.endArray();
            }
            if ((constraints = createGrantRequest.getConstraints()) != null) {
                jsonWriter.key("Constraints");
                jsonWriter.object();
                if (constraints.getEncryptionContextSubset() != null && !constraints.getEncryptionContextSubset().isEmpty()) {
                    jsonWriter.key("EncryptionContextSubset");
                    jsonWriter.object();
                    for (Map.Entry<String, String> encryptionContextSubsetListValue : constraints.getEncryptionContextSubset().entrySet()) {
                        if (encryptionContextSubsetListValue.getValue() == null) continue;
                        jsonWriter.key(encryptionContextSubsetListValue.getKey());
                        jsonWriter.value(encryptionContextSubsetListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                if (constraints.getEncryptionContextEquals() != null && !constraints.getEncryptionContextEquals().isEmpty()) {
                    jsonWriter.key("EncryptionContextEquals");
                    jsonWriter.object();
                    for (Map.Entry<String, String> encryptionContextEqualsListValue : constraints.getEncryptionContextEquals().entrySet()) {
                        if (encryptionContextEqualsListValue.getValue() == null) continue;
                        jsonWriter.key(encryptionContextEqualsListValue.getKey());
                        jsonWriter.value(encryptionContextEqualsListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)createGrantRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

