/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class JavaTypeDeserializer
extends StdScalarDeserializer<JavaType> {
    private static final long serialVersionUID = 1L;
    public static final JavaTypeDeserializer instance = new JavaTypeDeserializer();

    public JavaTypeDeserializer() {
        super(JavaType.class);
    }

    @Override
    public JavaType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (JavaType)this.getEmptyValue();
            }
            return deserializationContext.getTypeFactory().constructFromCanonical(string);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (JavaType)jsonParser.getEmbeddedObject();
        }
        throw deserializationContext.mappingException(this._valueClass);
    }
}

