/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.SerializedString;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.EnumValues;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;

@JacksonStdImpl
public class EnumMapSerializer
extends ContainerSerializer<EnumMap<? extends Enum<?>, ?>>
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final BeanProperty _property;
    protected final EnumValues _keyEnums;
    protected final JavaType _valueType;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;

    public EnumMapSerializer(JavaType javaType, boolean bl, EnumValues enumValues, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(EnumMap.class, false);
        this._property = null;
        this._staticTyping = bl || javaType != null && javaType.isFinal();
        this._valueType = javaType;
        this._keyEnums = enumValues;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
    }

    public EnumMapSerializer(EnumMapSerializer enumMapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        super(enumMapSerializer);
        this._property = beanProperty;
        this._staticTyping = enumMapSerializer._staticTyping;
        this._valueType = enumMapSerializer._valueType;
        this._keyEnums = enumMapSerializer._keyEnums;
        this._valueTypeSerializer = enumMapSerializer._valueTypeSerializer;
        this._valueSerializer = jsonSerializer;
    }

    public EnumMapSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new EnumMapSerializer(this._valueType, this._staticTyping, this._keyEnums, typeSerializer, this._valueSerializer);
    }

    public EnumMapSerializer withValueSerializer(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        if (this._property == beanProperty && jsonSerializer == this._valueSerializer) {
            return this;
        }
        return new EnumMapSerializer(this, beanProperty, jsonSerializer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = serializerProvider.getAnnotationIntrospector().findContentSerializer(annotatedMember)) != null) {
            jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._valueSerializer;
        }
        if ((jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            if (this._staticTyping) {
                return this.withValueSerializer(beanProperty, serializerProvider.findValueSerializer(this._valueType, beanProperty));
            }
        } else {
            jsonSerializer = serializerProvider.handleSecondaryContextualization(jsonSerializer, beanProperty);
        }
        if (jsonSerializer != this._valueSerializer) {
            return this.withValueSerializer(beanProperty, jsonSerializer);
        }
        return this;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(EnumMap<? extends Enum<?>, ?> enumMap) {
        return enumMap == null || enumMap.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumMap<? extends Enum<?>, ?> enumMap) {
        return enumMap.size() == 1;
    }

    @Override
    public void serialize(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartObject();
        if (!enumMap.isEmpty()) {
            this.serializeContents(enumMap, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForObject(enumMap, jsonGenerator);
        if (!enumMap.isEmpty()) {
            this.serializeContents(enumMap, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForObject(enumMap, jsonGenerator);
    }

    protected void serializeContents(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._valueSerializer != null) {
            this.serializeContentsUsing(enumMap, jsonGenerator, serializerProvider, this._valueSerializer);
            return;
        }
        JsonSerializer<Object> jsonSerializer = null;
        Class<?> clazz = null;
        EnumValues enumValues = this._keyEnums;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (Map.Entry<Enum<?>, ?> entry : enumMap.entrySet()) {
            JsonSerializer<Object> jsonSerializer2;
            Class<?> clazz2;
            Object obj = entry.getValue();
            if (bl && obj == null) continue;
            Enum<?> enum_ = entry.getKey();
            if (enumValues == null) {
                clazz2 = (StdSerializer)serializerProvider.findValueSerializer(enum_.getDeclaringClass(), this._property);
                enumValues = ((EnumSerializer)((Object)clazz2)).getEnumValues();
            }
            jsonGenerator.writeFieldName(enumValues.serializedValueFor(enum_));
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            clazz2 = obj.getClass();
            if (clazz2 == clazz) {
                jsonSerializer2 = jsonSerializer;
            } else {
                jsonSerializer = jsonSerializer2 = serializerProvider.findValueSerializer(clazz2, this._property);
                clazz = clazz2;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer2.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, enumMap, entry.getKey().name());
            }
        }
    }

    protected void serializeContentsUsing(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        EnumValues enumValues = this._keyEnums;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (Map.Entry<Enum<?>, ?> entry : enumMap.entrySet()) {
            Object obj = entry.getValue();
            if (bl && obj == null) continue;
            Enum<?> enum_ = entry.getKey();
            if (enumValues == null) {
                StdSerializer stdSerializer = (StdSerializer)serializerProvider.findValueSerializer(enum_.getDeclaringClass(), this._property);
                enumValues = ((EnumSerializer)stdSerializer).getEnumValues();
            }
            jsonGenerator.writeFieldName(enumValues.serializedValueFor(enum_));
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, enumMap, entry.getKey().name());
            }
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        Type[] typeArray;
        ObjectNode objectNode = this.createSchemaNode("object", true);
        if (type instanceof ParameterizedType && (typeArray = ((ParameterizedType)type).getActualTypeArguments()).length == 2) {
            JavaType javaType = serializerProvider.constructType(typeArray[0]);
            JavaType javaType2 = serializerProvider.constructType(typeArray[1]);
            ObjectNode objectNode2 = JsonNodeFactory.instance.objectNode();
            Class<?> clazz = javaType.getRawClass();
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(javaType2.getRawClass(), this._property);
                JsonNode jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, null) : JsonSchema.getDefaultSchemaNode();
                objectNode2.put(serializerProvider.getConfig().getAnnotationIntrospector().findEnumValue(enum_), jsonNode);
            }
            objectNode.put("properties", objectNode2);
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        EnumValues enumValues;
        if (jsonFormatVisitorWrapper == null) {
            return;
        }
        JsonObjectFormatVisitor jsonObjectFormatVisitor = jsonFormatVisitorWrapper.expectObjectFormat(javaType);
        if (jsonObjectFormatVisitor == null) {
            return;
        }
        JavaType javaType2 = javaType.containedType(1);
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null && javaType2 != null) {
            jsonSerializer = jsonFormatVisitorWrapper.getProvider().findValueSerializer(javaType2, this._property);
        }
        if (javaType2 == null) {
            javaType2 = jsonFormatVisitorWrapper.getProvider().constructType((Type)((Object)Object.class));
        }
        if ((enumValues = this._keyEnums) == null) {
            JavaType javaType3 = javaType.containedType(0);
            if (javaType3 == null) {
                throw new IllegalStateException("Can not resolve Enum type of EnumMap: " + javaType);
            }
            JsonSerializer<Object> jsonSerializer2 = jsonFormatVisitorWrapper.getProvider().findValueSerializer(javaType3, this._property);
            if (!(jsonSerializer2 instanceof EnumSerializer)) {
                throw new IllegalStateException("Can not resolve Enum type of EnumMap: " + javaType);
            }
            enumValues = ((EnumSerializer)jsonSerializer2).getEnumValues();
        }
        for (Map.Entry entry : enumValues.internalMap().entrySet()) {
            String string = ((SerializedString)entry.getValue()).getValue();
            if (jsonSerializer == null) {
                jsonSerializer = jsonFormatVisitorWrapper.getProvider().findValueSerializer(entry.getKey().getClass(), this._property);
            }
            jsonObjectFormatVisitor.property(string, jsonSerializer, javaType2);
        }
    }
}

