/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.EnumMap;

public class EnumMapDeserializer
extends StdDeserializer<EnumMap<?, ?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1518773374647478964L;
    protected final JavaType _mapType;
    protected final Class<?> _enumClass;
    protected JsonDeserializer<Enum<?>> _keyDeserializer;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    @Deprecated
    public EnumMapDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2) {
        this(javaType, jsonDeserializer, jsonDeserializer2, null);
    }

    public EnumMapDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, TypeDeserializer typeDeserializer) {
        super(EnumMap.class);
        this._mapType = javaType;
        this._enumClass = javaType.getKeyType().getRawClass();
        this._keyDeserializer = jsonDeserializer;
        this._valueDeserializer = jsonDeserializer2;
        this._valueTypeDeserializer = typeDeserializer;
    }

    @Deprecated
    public EnumMapDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2) {
        return this.withResolved(jsonDeserializer, jsonDeserializer2, null);
    }

    public EnumMapDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, TypeDeserializer typeDeserializer) {
        if (jsonDeserializer == this._keyDeserializer && jsonDeserializer2 == this._valueDeserializer && typeDeserializer == this._valueTypeDeserializer) {
            return this;
        }
        return new EnumMapDeserializer(this._mapType, jsonDeserializer, jsonDeserializer2, this._valueTypeDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        JsonDeserializer<Object> jsonDeserializer2 = this._keyDeserializer;
        if (jsonDeserializer2 == null) {
            jsonDeserializer2 = deserializationContext.findContextualValueDeserializer(this._mapType.getKeyType(), beanProperty);
        }
        jsonDeserializer = (jsonDeserializer = this._valueDeserializer) == null ? deserializationContext.findContextualValueDeserializer(this._mapType.getContentType(), beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        return this.withResolved(jsonDeserializer2, jsonDeserializer, typeDeserializer);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw deserializationContext.mappingException(EnumMap.class);
        }
        EnumMap<?, ?> enumMap = this.constructMap();
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            Object object;
            Enum<?> enum_ = this._keyDeserializer.deserialize(jsonParser, deserializationContext);
            if (enum_ == null) {
                if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    object = null;
                    try {
                        if (jsonParser.hasCurrentToken()) {
                            object = jsonParser.getText();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw deserializationContext.weirdStringException((String)object, this._enumClass, "value not one of declared Enum instance names");
                }
                jsonParser.nextToken();
                jsonParser.skipChildren();
                continue;
            }
            object = jsonParser.nextToken();
            Object object2 = object == JsonToken.VALUE_NULL ? null : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
            enumMap.put(enum_, object2);
        }
        return enumMap;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    private EnumMap<?, ?> constructMap() {
        return new EnumMap(this._enumClass);
    }
}

