/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.tika.language.translate;

import com.snowflake.client.jdbc.internal.apache.tika.config.ServiceLoader;
import com.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import com.snowflake.client.jdbc.internal.apache.tika.language.translate.Translator;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultTranslator
implements Translator {
    private final transient ServiceLoader loader;

    public DefaultTranslator(ServiceLoader loader) {
        this.loader = loader;
    }

    private static List<Translator> getDefaultTranslators(ServiceLoader loader) {
        List<Translator> translators = loader.loadStaticServiceProviders(Translator.class);
        Collections.sort(translators, new Comparator<Translator>(){

            @Override
            public int compare(Translator t1, Translator t2) {
                boolean tika2;
                String n1 = t1.getClass().getName();
                String n2 = t2.getClass().getName();
                boolean tika1 = n1.startsWith("com.snowflake.client.jdbc.internal.apache.tika.");
                if (tika1 == (tika2 = n2.startsWith("com.snowflake.client.jdbc.internal.apache.tika."))) {
                    return n1.compareTo(n2);
                }
                if (tika1) {
                    return -1;
                }
                return 1;
            }
        });
        return translators;
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        return DefaultTranslator.getDefaultTranslators(this.loader).get(0).translate(text, sourceLanguage, targetLanguage);
    }

    @Override
    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        return DefaultTranslator.getDefaultTranslators(this.loader).get(0).translate(text, targetLanguage);
    }

    @Override
    public boolean isAvailable() {
        return DefaultTranslator.getDefaultTranslators(this.loader).get(0).isAvailable();
    }
}

