/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc;

import com.snowflake.client.core.SFException;
import com.snowflake.client.core.SFSession;
import com.snowflake.client.core.SFSessionProperty;
import com.snowflake.client.jdbc.ErrorCode;
import com.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import com.snowflake.client.jdbc.SnowflakeDriver;
import com.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import com.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import com.snowflake.client.jdbc.SnowflakeSQLException;
import com.snowflake.client.jdbc.SnowflakeStatementV1;
import com.snowflake.client.jdbc.internal.apache.commons.lang3.StringUtils;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import com.snowflake.gscommon.core.ResourceBundleManager;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SnowflakeConnectionV1
implements Connection {
    static final Logger logger = Logger.getLogger(SnowflakeConnectionV1.class.getName());
    private static final String JDBC_PROTOCOL_PREFIX = "jdbc:snowflake";
    private static final String NATIVE_PROTOCOL = "http";
    private static final String SSL_NATIVE_PROTOCOL = "https";
    private boolean isClosed = true;
    private String sessionToken;
    private String masterToken;
    private String userName;
    private String password;
    private String accountName;
    private String databaseName;
    private String schemaName;
    private String warehouse;
    protected Level tracingLevel = Level.INFO;
    private String serverUrl;
    private boolean sslOn = true;
    private boolean passcodeInPassword = false;
    private String passcode;
    private String role;
    private String authenticator;
    private List<SQLWarning> sqlWarnings = new LinkedList<SQLWarning>();
    private String newClientForUpdate;
    private Map<String, Object> sessionParameters = new HashMap<String, Object>();
    private AtomicInteger _injectedDelay = new AtomicInteger(0);
    private String databaseVersion = null;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    private int loginTimeout = DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() : 60;
    private int networkTimeoutInMilli = 0;
    private int queryTimeout = 0;
    private boolean useProxy = false;
    private AtomicInteger sequenceId = new AtomicInteger(0);
    private Map sessionProperties = new HashMap(1);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static String IMPLEMENTATION_VERSION_TESTING = "2147483647.0.0";
    private static Long SVN_REVISION_TESTING = Long.MAX_VALUE;
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("com.snowflake.common_error_messages");
    boolean internalTesting = false;
    private Properties clientInfo = new Properties();
    private int transactionIsolation = 0;
    private int injectSocketTimeout = 0;
    private int injectClientPause = 0;
    private String injectFileUploadFailure = null;
    private boolean useV1QueryAPI = false;
    private boolean retryQuery = false;
    private SFSession sfSession;

    public SnowflakeConnectionV1(String url, Properties info) throws SQLException {
        this.processParameters(url, info);
        if (this.userName == null || this.userName.isEmpty()) {
            throw new SQLException(errorResourceBundleManager.getLocalizedMessage(ErrorCode.MISSING_USERNAME.getMessageCode().toString()));
        }
        if (this.password == null || this.userName.isEmpty()) {
            throw new SQLException(errorResourceBundleManager.getLocalizedMessage(ErrorCode.MISSING_PASSWORD.getMessageCode().toString()));
        }
        this.serverUrl = this.serverUrl.replace(JDBC_PROTOCOL_PREFIX, this.sslOn ? SSL_NATIVE_PROTOCOL : NATIVE_PROTOCOL);
        logger.log(Level.FINER, "Connecting to: " + this.serverUrl + " with " + "userName=" + this.userName + " accountName=" + this.accountName + " databaseName=" + this.databaseName + " schemaName=" + this.schemaName + " warehouse=" + this.warehouse + " ssl=" + this.sslOn);
        this.sfSession = new SFSession();
        try {
            this.initSessionProperties();
            this.sfSession.open();
            this.databaseVersion = this.sfSession.getDatabaseVersion();
            this.databaseMajorVersion = this.sfSession.getDatabaseMajorVersion();
            this.databaseMinorVersion = this.sfSession.getDatabaseMinorVersion();
            this.newClientForUpdate = this.sfSession.getNewClientForUpdate();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        this.isClosed = false;
    }

    private void initSessionProperties() throws SFException {
        this.sfSession.addProperty(SFSessionProperty.SERVER_URL.getPropertyKey(), this.serverUrl);
        this.sfSession.addProperty(SFSessionProperty.USER.getPropertyKey(), this.userName);
        this.sfSession.addProperty(SFSessionProperty.PASSWORD.getPropertyKey(), this.password);
        this.sfSession.addProperty(SFSessionProperty.ACCOUNT.getPropertyKey(), this.accountName);
        if (this.databaseName != null) {
            this.sfSession.addProperty(SFSessionProperty.DATABASE.getPropertyKey(), this.databaseName);
        }
        if (this.schemaName != null) {
            this.sfSession.addProperty(SFSessionProperty.SCHEMA.getPropertyKey(), this.schemaName);
        }
        if (this.warehouse != null) {
            this.sfSession.addProperty(SFSessionProperty.WAREHOUSE.getPropertyKey(), this.warehouse);
        }
        if (this.role != null) {
            this.sfSession.addProperty(SFSessionProperty.ROLE.getPropertyKey(), this.role);
        }
        if (this.authenticator != null) {
            this.sfSession.addProperty(SFSessionProperty.AUTHENTICATOR.getPropertyKey(), this.authenticator);
        }
        this.sfSession.addProperty(SFSessionProperty.APP_ID.getPropertyKey(), "JDBC");
        if (this.internalTesting) {
            this.sfSession.addProperty(SFSessionProperty.APP_VERSION.getPropertyKey(), IMPLEMENTATION_VERSION_TESTING);
            this.sfSession.addProperty(SFSessionProperty.APP_BUILD_ID.getPropertyKey(), String.valueOf(SVN_REVISION_TESTING));
        } else {
            this.sfSession.addProperty(SFSessionProperty.APP_VERSION.getPropertyKey(), SnowflakeDriver.implementVersion);
            this.sfSession.addProperty(SFSessionProperty.APP_BUILD_ID.getPropertyKey(), String.valueOf(SnowflakeDriver.svnRevision));
        }
        this.sfSession.addProperty(SFSessionProperty.LOGIN_TIMEOUT.getPropertyKey(), this.loginTimeout);
        this.sfSession.addProperty(SFSessionProperty.NETWORK_TIMEOUT.getPropertyKey(), this.networkTimeoutInMilli);
        this.sfSession.addProperty(SFSessionProperty.USE_PROXY.getPropertyKey(), this.useProxy);
        this.sfSession.addProperty(SFSessionProperty.INJECT_SOCKET_TIMEOUT.getPropertyKey(), this.injectSocketTimeout);
        this.sfSession.addProperty(SFSessionProperty.INJECT_CLIENT_PAUSE.getPropertyKey(), this.injectClientPause);
        this.sfSession.addProperty(SFSessionProperty.PASSCODE.getPropertyKey(), this.passcode);
        this.sfSession.addProperty(SFSessionProperty.PASSCODE_IN_PASSWORD.getPropertyKey(), this.passcodeInPassword);
        for (String param_name : this.sessionParameters.keySet()) {
            Object param_value = this.sessionParameters.get(param_name);
            this.sfSession.addProperty(param_name, param_value);
        }
    }

    private void processParameters(String url, Properties info) {
        this.serverUrl = url;
        int queryParamsIndex = url.indexOf("/?");
        if (queryParamsIndex > 0) {
            String queryParams = url.substring(queryParamsIndex + 2);
            String[] tokens = StringUtils.split(queryParams, "=&");
            this.serverUrl = this.serverUrl.substring(0, queryParamsIndex);
            logger.log(Level.FINE, "server url: {0}", this.serverUrl);
            if (tokens.length % 2 != 0) {
                throw new IllegalArgumentException("Missing value for some query param");
            }
            for (int paramIdx = 0; paramIdx < tokens.length; paramIdx += 2) {
                if ("user".equalsIgnoreCase(tokens[paramIdx])) {
                    this.userName = tokens[paramIdx + 1];
                    logger.log(Level.FINE, "user name: {0}", this.userName);
                    continue;
                }
                if ("password".equalsIgnoreCase(tokens[paramIdx])) {
                    this.password = tokens[paramIdx + 1];
                    continue;
                }
                if ("account".equalsIgnoreCase(tokens[paramIdx])) {
                    this.accountName = tokens[paramIdx + 1];
                    logger.log(Level.FINE, "account: {0}", this.accountName);
                    continue;
                }
                if ("db".equalsIgnoreCase(tokens[paramIdx]) || "database".equalsIgnoreCase(tokens[paramIdx])) {
                    this.databaseName = tokens[paramIdx + 1];
                    logger.log(Level.FINE, "db: {0}", this.databaseName);
                    continue;
                }
                if ("schema".equalsIgnoreCase(tokens[paramIdx])) {
                    this.schemaName = tokens[paramIdx + 1];
                    logger.log(Level.FINE, "schema: {0}", this.schemaName);
                    continue;
                }
                if ("ssl".equalsIgnoreCase(tokens[paramIdx])) {
                    this.sslOn = !"off".equalsIgnoreCase(tokens[paramIdx + 1]) && !"false".equalsIgnoreCase(tokens[paramIdx + 1]);
                    logger.log(Level.FINE, "ssl: {0}", tokens[paramIdx + 1]);
                    continue;
                }
                if ("passcodeInPassword".equalsIgnoreCase(tokens[paramIdx])) {
                    this.passcodeInPassword = "on".equalsIgnoreCase(tokens[paramIdx + 1]) || "true".equalsIgnoreCase(tokens[paramIdx + 1]);
                    logger.log(Level.FINE, "passcodeInPassword: {0}", tokens[paramIdx + 1]);
                    continue;
                }
                if ("passcode".equalsIgnoreCase(tokens[paramIdx])) {
                    this.passcode = tokens[paramIdx + 1];
                    continue;
                }
                if ("role".equalsIgnoreCase(tokens[paramIdx])) {
                    this.role = tokens[paramIdx + 1];
                    logger.log(Level.FINE, "role: {0}", this.role);
                    continue;
                }
                if ("authenticator".equalsIgnoreCase(tokens[paramIdx])) {
                    this.authenticator = tokens[paramIdx + 1];
                    continue;
                }
                if ("internal".equalsIgnoreCase(tokens[paramIdx])) {
                    this.internalTesting = "true".equalsIgnoreCase(tokens[paramIdx + 1]);
                    continue;
                }
                if ("warehouse".equalsIgnoreCase(tokens[paramIdx])) {
                    this.warehouse = tokens[paramIdx + 1];
                    logger.log(Level.FINE, "warehouse: {0}", this.warehouse);
                    continue;
                }
                if ("loginTimeout".equalsIgnoreCase(tokens[paramIdx])) {
                    this.loginTimeout = Integer.parseInt(tokens[paramIdx + 1]);
                    logger.log(Level.FINE, "login timeout: {0}", this.loginTimeout);
                    continue;
                }
                if ("networkTimeout".equalsIgnoreCase(tokens[paramIdx])) {
                    this.networkTimeoutInMilli = Integer.parseInt(tokens[paramIdx + 1]) * 1000;
                    logger.log(Level.FINE, "network timeout in milli: {0}", this.networkTimeoutInMilli);
                    continue;
                }
                if ("queryTimeout".equalsIgnoreCase(tokens[paramIdx])) {
                    this.queryTimeout = Integer.parseInt(tokens[paramIdx + 1]);
                    logger.log(Level.FINE, "queryTimeout: {0}", this.queryTimeout);
                    continue;
                }
                if ("useProxy".equalsIgnoreCase(tokens[paramIdx])) {
                    this.useProxy = "on".equalsIgnoreCase(tokens[paramIdx + 1]) || "true".equalsIgnoreCase(tokens[paramIdx + 1]);
                    logger.log(Level.FINE, "useProxy: {0}", tokens[paramIdx + 1]);
                    continue;
                }
                if ("injectSocketTimeout".equalsIgnoreCase(tokens[paramIdx])) {
                    this.injectSocketTimeout = Integer.parseInt(tokens[paramIdx + 1]);
                    logger.log(Level.FINE, "injectSocketTimeout: {0}", this.injectSocketTimeout);
                    continue;
                }
                if ("injectClientPause".equalsIgnoreCase(tokens[paramIdx])) {
                    this.injectClientPause = Integer.parseInt(tokens[paramIdx + 1]);
                    logger.log(Level.FINE, "injectClientPause: {0}", this.injectClientPause);
                    continue;
                }
                if ("useV1QueryAPI".equalsIgnoreCase(tokens[paramIdx])) {
                    if ("on".equalsIgnoreCase(tokens[paramIdx + 1]) || "true".equalsIgnoreCase(tokens[paramIdx + 1])) {
                        this.useV1QueryAPI = true;
                    }
                    logger.log(Level.FINE, "useV1QueryAPI: {0}", tokens[paramIdx + 1]);
                    continue;
                }
                if ("retryQuery".equalsIgnoreCase(tokens[paramIdx])) {
                    if ("on".equalsIgnoreCase(tokens[paramIdx + 1]) || "true".equalsIgnoreCase(tokens[paramIdx + 1])) {
                        this.retryQuery = true;
                    }
                    logger.log(Level.FINE, "retryQuery: {0}", tokens[paramIdx + 1]);
                    continue;
                }
                if ("tracing".equalsIgnoreCase(tokens[paramIdx])) {
                    String tracingLevelStr = tokens[paramIdx + 1].toUpperCase();
                    logger.log(Level.FINE, "tracing level specified in connection url: {0}", tracingLevelStr);
                    this.tracingLevel = Level.parse(tracingLevelStr);
                    if (this.tracingLevel == null) continue;
                    Logger snowflakeLogger = Logger.getLogger("com.snowflake");
                    snowflakeLogger.setLevel(this.tracingLevel);
                    continue;
                }
                String param_name = tokens[paramIdx];
                String param_value = tokens[paramIdx + 1];
                logger.log(Level.FINE, "parameter {0} set to {1}", new Object[]{param_name, param_value});
                this.sessionParameters.put(param_name, param_value);
            }
        }
        for (Object key : info.keySet()) {
            if (key.equals("user")) {
                this.userName = info.getProperty("user");
                logger.log(Level.FINE, "user name property: {0}", this.userName);
                continue;
            }
            if (key.equals("password")) {
                this.password = info.getProperty("password");
                continue;
            }
            if (key.equals("account")) {
                this.accountName = info.getProperty("account");
                logger.log(Level.FINE, "account name property: {0}", this.accountName);
                continue;
            }
            if (key.equals("db")) {
                this.databaseName = info.getProperty("db");
                logger.log(Level.FINE, "database name property: {0}", this.databaseName);
                continue;
            }
            if (key.equals("database")) {
                this.databaseName = info.getProperty("database");
                logger.log(Level.FINE, "database name property: {0}", this.databaseName);
                continue;
            }
            if (key.equals("schema")) {
                this.schemaName = info.getProperty("schema");
                logger.log(Level.FINE, "schema name property: {0}", this.schemaName);
                continue;
            }
            if (key.equals("warehouse")) {
                this.warehouse = info.getProperty("warehouse");
                logger.log(Level.FINE, "warehouse property: {0}", this.warehouse);
                continue;
            }
            if (key.equals("role")) {
                this.role = info.getProperty("role");
                logger.log(Level.FINE, "role property: {0}", this.role);
                continue;
            }
            if (key.equals("authenticator")) {
                this.authenticator = info.getProperty("authenticator");
                logger.log(Level.FINE, "authenticator property: {0}", this.authenticator);
                continue;
            }
            if (key.equals("ssl")) {
                this.sslOn = !"off".equalsIgnoreCase(info.getProperty("ssl")) && !"false".equalsIgnoreCase(info.getProperty("ssl"));
                logger.log(Level.FINE, "ssl property: {0}", info.getProperty("ssl"));
                continue;
            }
            if (key.equals("passcodeInPassword")) {
                this.passcodeInPassword = "on".equalsIgnoreCase(info.getProperty("passcodeInPassword")) || "true".equalsIgnoreCase(info.getProperty("passcodeInPassword"));
                continue;
            }
            if (key.equals("passcode")) {
                this.passcode = info.getProperty("passcode");
                continue;
            }
            if (key.equals("internal")) {
                this.internalTesting = "true".equalsIgnoreCase(info.getProperty("internal"));
                continue;
            }
            if (key.equals("loginTimeout")) {
                this.loginTimeout = Integer.parseInt(info.getProperty("loginTimeout"));
                continue;
            }
            if (key.equals("netowrkTimeout")) {
                this.networkTimeoutInMilli = Integer.parseInt(info.getProperty("networkTimeout")) * 1000;
                continue;
            }
            if (key.equals("queryTimeout")) {
                this.queryTimeout = Integer.parseInt(info.getProperty("queryTimeout"));
                continue;
            }
            if (key.equals("injectSocketTimeout")) {
                this.injectSocketTimeout = Integer.parseInt(info.getProperty("injectSocketTimeout"));
                continue;
            }
            if (key.equals("injectClientPause")) {
                this.injectClientPause = Integer.parseInt(info.getProperty("injectClientPause"));
                continue;
            }
            if (key.equals("useV1QueryAPI")) {
                String val = info.getProperty("useV1QueryAPI");
                if ("on".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val)) {
                    this.useV1QueryAPI = true;
                }
                logger.log(Level.FINE, "useV1QueryAPI property: {0}", val);
                continue;
            }
            if (key.equals("retryQuery")) {
                String val = info.getProperty("retryQuery");
                if ("on".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val)) {
                    this.retryQuery = true;
                }
                logger.log(Level.FINE, "retryQuery property: {0}", val);
                continue;
            }
            if (key.equals("tracing")) {
                this.tracingLevel = Level.parse(info.getProperty("tracing").toUpperCase());
                if (this.tracingLevel != null) {
                    Logger snowflakeLogger = Logger.getLogger("com.snowflake");
                    snowflakeLogger.setLevel(this.tracingLevel);
                }
                logger.log(Level.FINE, "tracingLevel property: {0}", info.getProperty("tracing"));
                continue;
            }
            String param_name = key.toString();
            Object param_value = info.get(key);
            this.sessionParameters.put(param_name, param_value);
            logger.log(Level.FINE, "parameter {0} set to {1}", new Object[]{param_name, param_value.toString()});
        }
        if (this.accountName == null && this.serverUrl != null && this.serverUrl.indexOf(".") > 0 && this.serverUrl.indexOf("://") > 0) {
            this.accountName = this.serverUrl.substring(this.serverUrl.indexOf("://") + 3, this.serverUrl.indexOf("."));
            logger.log(Level.FINE, "set account name to {0}", this.accountName);
        }
    }

    private void executeImmediate(String stmtText) throws SQLException {
        try (Statement statement = this.createStatement();){
            statement.execute(stmtText);
        }
    }

    public String getNewClientForUpdate() {
        return this.newClientForUpdate;
    }

    public void setNewClientForUpdate(String newClientForUpdate) {
        this.newClientForUpdate = newClientForUpdate;
    }

    public int getAndIncrementSequenceId() {
        return this.sequenceId.getAndIncrement();
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    protected String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public Statement createStatement() throws SQLException {
        SnowflakeStatementV1 statement = new SnowflakeStatementV1(this);
        statement.setQueryTimeout(this.queryTimeout);
        return statement;
    }

    @Override
    public void close() throws SQLException {
        logger.log(Level.FINER, " public void close() throws SQLException");
        if (this.isClosed) {
            return;
        }
        try {
            if (this.sfSession != null) {
                this.sfSession.close();
                this.sfSession = null;
            }
            this.isClosed = true;
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.log(Level.FINER, " public boolean isClosed() throws SQLException");
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        logger.log(Level.FINER, " public DatabaseMetaData getMetaData() throws SQLException");
        return new SnowflakeDatabaseMetaData(this);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        logger.log(Level.FINER, " public CallableStatement prepareCall(String sql) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.log(Level.FINER, " public CallableStatement prepareCall(String sql, int resultSetType,");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.log(Level.FINER, " public CallableStatement prepareCall(String sql, int resultSetType,");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        logger.log(Level.FINER, " public String nativeSQL(String sql) throws SQLException");
        return sql;
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        logger.log(Level.FINER, " public void setAutoCommit(boolean isAutoCommit) throws SQLException");
        try {
            this.executeImmediate("alter session set autocommit=" + Boolean.toString(isAutoCommit));
        }
        catch (SnowflakeSQLException sse) {
            if (sse.getSQLState().equals("0A000")) {
                logger.log(Level.FINER, "Autocommit API is not supported for this connection.");
            }
            throw sse;
        }
    }

    private List<String> queryGSMetaData(String querySQL, List<String> columnNames) throws SQLException {
        Throwable throwable = null;
        try (Statement statement = this.createStatement();){
            Throwable throwable2;
            ResultSet rs;
            block26: {
                ArrayList<String> arrayList;
                block27: {
                    block28: {
                        statement.execute(querySQL);
                        rs = statement.getResultSet();
                        throwable2 = null;
                        if (rs == null || !rs.next()) break block26;
                        ArrayList<String> columnValues = new ArrayList<String>();
                        for (String columnName : columnNames) {
                            columnValues.add(rs.getString(columnName));
                        }
                        arrayList = columnValues;
                        if (rs == null) break block27;
                        if (throwable2 == null) break block28;
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    rs.close();
                }
                return arrayList;
            }
            try {
                try {
                    try {
                        throw new SQLException(errorResourceBundleManager.getLocalizedMessage(ErrorCode.BAD_RESPONSE.getMessageCode().toString()));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (rs != null) {
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            rs.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        logger.log(Level.FINER, " public boolean getAutoCommit() throws SQLException");
        return this.sfSession.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        logger.log(Level.FINER, " public void commit() throws SQLException");
        this.executeImmediate("commit");
    }

    @Override
    public void rollback() throws SQLException {
        logger.log(Level.FINER, " public void rollback() throws SQLException");
        this.executeImmediate("rollback");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        logger.log(Level.FINER, " public void rollback(Savepoint savepoint) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        logger.log(Level.FINER, " public void setReadOnly(boolean readOnly) throws SQLException");
        if (readOnly) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.log(Level.FINER, " public boolean isReadOnly() throws SQLException");
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        logger.log(Level.FINER, " public void setCatalog(String catalog) throws SQLException");
        this.databaseName = catalog;
        this.executeImmediate("use database \"" + this.databaseName + "\"");
    }

    @Override
    public String getCatalog() throws SQLException {
        logger.log(Level.FINER, " public String getCatalog() throws SQLException");
        String querySQL = "select current_database() as db";
        List<String> queryResults = this.queryGSMetaData(querySQL, Arrays.asList("DB"));
        return queryResults.get(0);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        logger.log(Level.FINER, " public void setTransactionIsolation(int level) throws SQLException. level = {0}", level);
        if (level != 0 && level != 2) {
            throw new SQLFeatureNotSupportedException("Transaction Isolation " + Integer.toString(level) + " not supported.", ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        this.transactionIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        logger.log(Level.FINER, " public int getTransactionIsolation() throws SQLException");
        return this.transactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.log(Level.FINER, " public SQLWarning getWarnings() throws SQLException");
        if (this.sqlWarnings != null && !this.sqlWarnings.isEmpty()) {
            return this.sqlWarnings.get(0);
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.log(Level.FINER, " public void clearWarnings() throws SQLException");
        if (this.sqlWarnings != null) {
            this.sqlWarnings.clear();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.log(Level.FINER, " public Statement createStatement(int resultSetType, int resultSetConcurrency)");
        logger.log(Level.FINER, "resultSetType=" + resultSetType + "; resultSetConcurrency=" + resultSetConcurrency);
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.log(Level.FINER, " public Statement createStatement(int resultSetType, int resultSetConcurrency,");
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.log(Level.FINER, " public PreparedStatement prepareStatement(String sql) throws SQLException");
        return new SnowflakePreparedStatementV1(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        logger.log(Level.FINER, " public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        logger.log(Level.FINER, " public PreparedStatement prepareStatement(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        logger.log(Level.FINER, " public PreparedStatement prepareStatement(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.log(Level.FINER, " public PreparedStatement prepareStatement(String sql, int resultSetType,");
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            logger.log(Level.SEVERE, "result set type ({0}) or result set concurrency ({1}) not supported", new Object[]{resultSetType, resultSetConcurrency});
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.log(Level.FINER, " public PreparedStatement prepareStatement(String sql, int resultSetType,");
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        logger.log(Level.FINER, " public Map<String, Class<?>> getTypeMap() throws SQLException");
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        logger.log(Level.FINER, " public void setTypeMap(Map<String, Class<?>> map) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        logger.log(Level.FINER, " public void setHoldability(int holdability) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        logger.log(Level.FINER, " public int getHoldability() throws SQLException");
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        logger.log(Level.FINER, " public Savepoint setSavepoint() throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        logger.log(Level.FINER, " public Savepoint setSavepoint(String name) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        logger.log(Level.FINER, " public void releaseSavepoint(Savepoint savepoint) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        logger.log(Level.FINER, " public Blob createBlob() throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        logger.log(Level.FINER, " public Clob createClob() throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        logger.log(Level.FINER, " public NClob createNClob() throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        logger.log(Level.FINER, " public SQLXML createSQLXML() throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        logger.log(Level.FINER, " public boolean isValid(int timeout) throws SQLException");
        return !this.isClosed;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        logger.log(Level.FINER, " public void setClientInfo(Properties properties)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
        if (this.sfSession != null) {
            this.sfSession.setClientInfo(properties);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        logger.fine(" public void setClientInfo(String name, String value)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.setProperty(name, value);
        if (this.sfSession != null) {
            this.sfSession.setClientInfo(name, value);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        logger.log(Level.FINER, " public Properties getClientInfo() throws SQLException");
        if (this.sfSession != null) {
            return this.sfSession.getClientInfo();
        }
        if (this.clientInfo != null) {
            Properties copy = new Properties();
            copy.putAll((Map<?, ?>)this.clientInfo);
            return copy;
        }
        return null;
    }

    @Override
    public String getClientInfo(String name) {
        if (this.sfSession != null) {
            return this.sfSession.getClientInfo(name);
        }
        logger.log(Level.FINER, " public String getClientInfo(String name)");
        if (this.clientInfo != null) {
            return this.clientInfo.getProperty(name);
        }
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        logger.log(Level.FINER, " public Array createArrayOf(String typeName, Object[] elements)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        logger.log(Level.FINER, " public Struct createStruct(String typeName, Object[] attributes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        logger.log(Level.FINER, " public void setSchema(String schema) throws SQLException");
        this.schemaName = schema;
        if (this.databaseName == null) {
            this.executeImmediate("use schema \"" + this.schemaName + "\"");
        } else {
            this.executeImmediate("use schema \"" + this.databaseName + "\".\"" + this.schemaName + "\"");
        }
    }

    @Override
    public String getSchema() throws SQLException {
        logger.log(Level.FINER, " public String getSchema() throws SQLException");
        String querySQL = "select current_schema() as schema";
        List<String> queryResults = this.queryGSMetaData(querySQL, Arrays.asList("SCHEMA"));
        return queryResults.get(0);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        logger.log(Level.FINER, " public void abort(Executor executor) throws SQLException");
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        logger.log(Level.FINER, " public void setNetworkTimeout(Executor executor, int milliseconds)");
        this.networkTimeoutInMilli = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        logger.log(Level.FINER, " public int getNetworkTimeout() throws SQLException");
        return this.networkTimeoutInMilli;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.log(Level.FINER, " public boolean isWrapperFor(Class<?> iface) throws SQLException");
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.log(Level.FINER, " public <T> T unwrap(Class<T> iface) throws SQLException");
        if (!iface.isInstance(this)) {
            throw new RuntimeException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    void setSFSessionProperty(String propertyName, boolean b) {
        this.sessionProperties.put(propertyName, b);
    }

    public Object getSFSessionProperty(String propertyName) {
        return this.sessionProperties.get(propertyName);
    }

    public static int getMajorVersion() {
        return SnowflakeDriver.majorVersion;
    }

    public static int getMinorVersion() {
        return SnowflakeDriver.minorVersion;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getURL() {
        return this.serverUrl;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void uploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName, long streamSize) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, streamSize, false);
    }

    public void compressAndUploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, 0L, true);
    }

    private void uploadStreamInternal(String stageName, String destPrefix, InputStream inputStream, String destFileName, long streamSize, boolean compressData) throws SQLException {
        logger.log(Level.FINER, "upload data from stream: stageName={0}, destPrefix={1}, destFileName={2}", new Object[]{stageName, destPrefix, destFileName});
        if (stageName == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null");
        }
        if (destFileName == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null");
        }
        SnowflakeStatementV1 stmt = new SnowflakeStatementV1(this);
        StringBuilder putCommand = new StringBuilder();
        putCommand.append("put file:///tmp/placeholder ");
        if (!stageName.startsWith("@")) {
            putCommand.append("@");
        }
        putCommand.append(stageName);
        if (destPrefix != null) {
            if (!destPrefix.startsWith("/")) {
                putCommand.append("/");
            }
            putCommand.append(destPrefix);
        }
        SnowflakeFileTransferAgent transferAgent = null;
        transferAgent = new SnowflakeFileTransferAgent(putCommand.toString(), this.sfSession, stmt.getSfStatement());
        transferAgent.setSourceStream(inputStream);
        transferAgent.setDestFileNameForStreamSource(destFileName);
        transferAgent.setSourceStreamSize(streamSize);
        transferAgent.setCompressSourceFromStream(compressData);
        transferAgent.setOverwrite(true);
        transferAgent.execute();
        stmt.close();
    }

    public void setInjectedDelay(int delay) {
        if (this.sfSession != null) {
            this.sfSession.setInjectedDelay(delay);
        }
        this._injectedDelay.set(delay);
    }

    void injectedDelay() {
        int d = this._injectedDelay.get();
        if (d != 0) {
            this._injectedDelay.set(0);
            try {
                logger.log(Level.FINEST, "delayed for {0}", d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getInjectSocketTimeout() {
        return this.injectSocketTimeout;
    }

    public void setInjectSocketTimeout(int injectSocketTimeout) {
        if (this.sfSession != null) {
            this.sfSession.setInjectSocketTimeout(injectSocketTimeout);
        }
        this.injectSocketTimeout = injectSocketTimeout;
    }

    public boolean isUseV1QueryAPI() {
        return this.useV1QueryAPI;
    }

    public void setUseV1QueryAPI(boolean useV1QueryAPI) {
        this.useV1QueryAPI = useV1QueryAPI;
    }

    public boolean isRetryQuery() {
        return this.retryQuery;
    }

    public void setRetryQuery(boolean retryQuery) {
        this.retryQuery = retryQuery;
    }

    public int getInjectClientPause() {
        return this.injectClientPause;
    }

    public void setInjectClientPause(int injectClientPause) {
        if (this.sfSession != null) {
            this.sfSession.setInjectClientPause(injectClientPause);
        }
        this.injectClientPause = injectClientPause;
    }

    public void setInjectFileUploadFailure(String fileToFail) {
        if (this.sfSession != null) {
            this.sfSession.setInjectFileUploadFailure(fileToFail);
        }
        this.injectFileUploadFailure = fileToFail;
    }

    public String getInjectFileUploadFailure() {
        return this.injectFileUploadFailure;
    }

    public SFSession getSfSession() {
        return this.sfSession;
    }
}

