/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.loader;

import com.snowflake.client.loader.FileUploader;
import com.snowflake.client.loader.Loader;
import com.snowflake.client.loader.Operation;
import com.snowflake.client.loader.StreamLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class BufferStage {
    private static final Logger LOGGER = Logger.getLogger(BufferStage.class.getName());
    static final int FILE_BUCKET_SIZE = 64;
    static final long FILE_SIZE = 50000000L;
    private State _state;
    private final File _directory;
    private final String _location;
    private final String _stamp;
    private final Operation _op;
    private volatile boolean _terminate = false;
    private String _id;
    private int _currentSize = 0;
    private int _rowCount = 0;
    private int _fileCount = 0;
    private static AtomicLong MARK = new AtomicLong(1L);
    private StreamLoader _loader;
    private OutputStream _outstream = null;
    private File _file = null;
    private ArrayList<FileUploader> _uploaders = new ArrayList();
    private static SimpleDateFormat _sdf = new SimpleDateFormat("yyyyMMdd'_'HHmmss'_'SSS");
    private static byte[] newLineBytes = "\n".getBytes(StandardCharsets.UTF_8);

    public BufferStage() {
        this._state = State.REMOVED;
        this._terminate = true;
        this._directory = null;
        this._location = null;
        this._stamp = null;
        this._op = null;
    }

    public BufferStage(StreamLoader loader, Operation op) {
        LOGGER.log(Level.FINER, String.format("Operation: %s", new Object[]{op}));
        this._state = State.CREATED;
        this._loader = loader;
        this._stamp = _sdf.format(new Date());
        long mark = MARK.getAndIncrement() % 10000000L;
        this._location = BufferStage.escapeFileSeparatorChar(this._loader.getTable()) + File.separatorChar + op.name() + File.separatorChar + this._stamp + "_" + this._loader.getNoise() + '_' + mark;
        this._id = BufferStage.escapeFileSeparatorChar(this._loader.getTable()) + "_" + this._stamp + '_' + mark;
        String localStageDirectory = this._loader.getBase() + File.separatorChar + this._location;
        this._directory = new File(localStageDirectory);
        if (!this._directory.mkdirs()) {
            RuntimeException ex = new RuntimeException("Could not initialize staging area @" + localStageDirectory);
            this._loader.abort(ex);
            throw ex;
        }
        this._op = op;
        this.openFile();
    }

    private synchronized void openFile() {
        try {
            String fName = this._directory.getAbsolutePath() + File.separatorChar + "stream_" + this._stamp + this._fileCount + ".gz";
            LOGGER.log(Level.FINER, String.format("openFile: %s", fName));
            FileOutputStream outputFile = new FileOutputStream(fName);
            this._outstream = new GZIPOutputStream((OutputStream)outputFile, 65536, true);
            this._file = new File(fName);
            ++this._fileCount;
        }
        catch (FileNotFoundException ex) {
            this._loader.abort(new Loader.ConnectionError(ex.getMessage()));
        }
        catch (IOException ex) {
            this._loader.abort(new Loader.ConnectionError(ex.getMessage()));
        }
    }

    public boolean stageData(byte[] line, boolean newLine) throws IOException {
        if (this._rowCount % 10000 == 0) {
            LOGGER.log(Level.FINER, String.format("rowCount: %s, currentSize: %s", this._rowCount, this._currentSize));
        }
        this._outstream.write(line);
        this._currentSize += line.length;
        if (newLine) {
            this._outstream.write(newLineBytes);
        }
        ++this._rowCount;
        if ((long)this._currentSize >= 50000000L) {
            LOGGER.log(Level.FINER, String.format("currentSize: %s, Threshold: %s, fileCount: %s, fileBucketSize: %s", this._currentSize, 50000000L, this._fileCount, 64));
            this._outstream.flush();
            this._outstream.close();
            FileUploader fu = new FileUploader(this._loader, this._location, this._file);
            fu.upload();
            this._uploaders.add(fu);
            this.openFile();
            this._currentSize = 0;
        }
        return this._fileCount > 64;
    }

    void completeUploading() throws InterruptedException, IOException {
        LOGGER.log(Level.FINER, String.format("CurrentSize: %s", this._currentSize));
        if (this._currentSize > 0) {
            this._outstream.flush();
            this._outstream.close();
            FileUploader fu = new FileUploader(this._loader, this._location, this._file);
            fu.upload();
            fu.join();
        }
        for (FileUploader fu : this._uploaders) {
            fu.join();
        }
        this._directory.deleteOnExit();
        if (this._rowCount == 0) {
            this.setState(State.EMPTY);
        }
    }

    public String getRemoteLocation() {
        return this.remoteSeparator(this._location);
    }

    public Operation getOp() {
        return this._op;
    }

    public boolean isTerminate() {
        return this._terminate;
    }

    public void setTerminate(boolean terminate) {
        this._terminate = terminate;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String _id) {
        this._id = _id;
    }

    public State state() {
        return this._state;
    }

    public void setState(State state) {
        if (this._state != state) {
            this._state = state;
        }
    }

    public int getRowCount() {
        return this._rowCount;
    }

    private String remoteSeparator(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replace("\\", "/");
        }
        return fname;
    }

    private static final String escapeFileSeparatorChar(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replaceAll(File.separator + File.separator, "_");
        }
        return fname.replaceAll(File.separator, "_");
    }

    public static enum State {
        CREATED,
        LOADING,
        LOADED,
        EMPTY,
        UPLOADED,
        VALIDATED,
        VALIDATED_CLEANED,
        ERROR,
        PROCESSED,
        CLEANED,
        REMOVED;

    }
}

