/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.Base64Variant;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonLocation;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParseException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonStreamContext;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.ObjectCodec;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.Version;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.base.ParserMinimalBase;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.PackageVersion;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.BinaryNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.NodeCursor;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.POJONode;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected NodeCursor _nodeCursor;
    protected JsonToken _nextToken;
    protected boolean _startContainer;
    protected boolean _closed;

    public TreeTraversingParser(JsonNode jsonNode) {
        this(jsonNode, null);
    }

    public TreeTraversingParser(JsonNode jsonNode, ObjectCodec objectCodec) {
        super(0);
        this._objectCodec = objectCodec;
        if (jsonNode.isArray()) {
            this._nextToken = JsonToken.START_ARRAY;
            this._nodeCursor = new NodeCursor.Array(jsonNode, null);
        } else if (jsonNode.isObject()) {
            this._nextToken = JsonToken.START_OBJECT;
            this._nodeCursor = new NodeCursor.Object(jsonNode, null);
        } else {
            this._nodeCursor = new NodeCursor.RootValue(jsonNode, null);
        }
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        if (this._nextToken != null) {
            this._currToken = this._nextToken;
            this._nextToken = null;
            return this._currToken;
        }
        if (this._startContainer) {
            this._startContainer = false;
            if (!this._nodeCursor.currentHasChildren()) {
                this._currToken = this._currToken == JsonToken.START_OBJECT ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                return this._currToken;
            }
            this._nodeCursor = this._nodeCursor.iterateChildren();
            this._currToken = this._nodeCursor.nextToken();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        if (this._nodeCursor == null) {
            this._closed = true;
            return null;
        }
        this._currToken = this._nodeCursor.nextToken();
        if (this._currToken != null) {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        this._currToken = this._nodeCursor.endToken();
        this._nodeCursor = this._nodeCursor.getParent();
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._startContainer = false;
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._startContainer = false;
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String getCurrentName() {
        return this._nodeCursor == null ? null : this._nodeCursor.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        if (this._nodeCursor != null) {
            this._nodeCursor.overrideCurrentName(string);
        }
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    @Override
    public String getText() {
        if (this._closed) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this._nodeCursor.getCurrentName();
            }
            case VALUE_STRING: {
                return this.currentNode().textValue();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode().numberValue());
            }
            case VALUE_EMBEDDED_OBJECT: {
                JsonNode jsonNode = this.currentNode();
                if (jsonNode == null || !jsonNode.isBinary()) break;
                return jsonNode.asText();
            }
        }
        return this._currToken == null ? null : this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        JsonNode jsonNode = this.currentNumericNode();
        return jsonNode == null ? null : jsonNode.numberType();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return this.currentNumericNode().bigIntegerValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        return this.currentNumericNode().decimalValue();
    }

    @Override
    public double getDoubleValue() throws IOException, JsonParseException {
        return this.currentNumericNode().doubleValue();
    }

    @Override
    public float getFloatValue() throws IOException, JsonParseException {
        return (float)this.currentNumericNode().doubleValue();
    }

    @Override
    public long getLongValue() throws IOException, JsonParseException {
        return this.currentNumericNode().longValue();
    }

    @Override
    public int getIntValue() throws IOException, JsonParseException {
        return this.currentNumericNode().intValue();
    }

    @Override
    public Number getNumberValue() throws IOException, JsonParseException {
        return this.currentNumericNode().numberValue();
    }

    @Override
    public Object getEmbeddedObject() {
        JsonNode jsonNode;
        if (!this._closed && (jsonNode = this.currentNode()) != null) {
            if (jsonNode.isPojo()) {
                return ((POJONode)jsonNode).getPojo();
            }
            if (jsonNode.isBinary()) {
                return ((BinaryNode)jsonNode).binaryValue();
            }
        }
        return null;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode != null) {
            Object object;
            byte[] byArray = jsonNode.binaryValue();
            if (byArray != null) {
                return byArray;
            }
            if (jsonNode.isPojo() && (object = ((POJONode)jsonNode).getPojo()) instanceof byte[]) {
                return (byte[])object;
            }
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        byte[] byArray = this.getBinaryValue(base64Variant);
        if (byArray != null) {
            outputStream.write(byArray, 0, byArray.length);
            return byArray.length;
        }
        return 0;
    }

    protected JsonNode currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JsonNode currentNumericNode() throws JsonParseException {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode == null || !jsonNode.isNumber()) {
            JsonToken jsonToken = jsonNode == null ? null : jsonNode.asToken();
            throw this._constructError("Current token (" + (Object)((Object)jsonToken) + ") not numeric, can not use numeric value accessors");
        }
        return jsonNode;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }
}

