/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.core;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.NumberInput;

public class JsonPointer {
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected final String _asString;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = "";
        this._matchingElementIndex = -1;
        this._asString = "";
    }

    protected JsonPointer(String string, String string2, JsonPointer jsonPointer) {
        this._asString = string;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = JsonPointer._parseInt(string2);
    }

    public static JsonPointer compile(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        if (string.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + string + "\"");
        }
        return JsonPointer._parseTail(string);
    }

    public static JsonPointer valueOf(String string) {
        return JsonPointer.compile(string);
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer matchProperty(String string) {
        if (this._nextSegment == null || !this._matchingPropertyName.equals(string)) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer matchElement(int n) {
        if (n != this._matchingElementIndex || n < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public String toString() {
        return this._asString;
    }

    public int hashCode() {
        return this._asString.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonPointer)) {
            return false;
        }
        return this._asString.equals(((JsonPointer)object)._asString);
    }

    private static final int _parseInt(String string) {
        int n = string.length();
        if (n == 0) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            if ((c = string.charAt(i++)) <= '9' && c >= '0') continue;
            return -1;
        }
        return NumberInput.parseInt(string);
    }

    protected static JsonPointer _parseTail(String string) {
        int n = string.length();
        int n2 = 1;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/') {
                return new JsonPointer(string, string.substring(1, n2), JsonPointer._parseTail(string.substring(n2)));
            }
            if (c != '~' || ++n2 >= n) continue;
            return JsonPointer._parseQuotedTail(string, n2);
        }
        return new JsonPointer(string, string.substring(1), EMPTY);
    }

    protected static JsonPointer _parseQuotedTail(String string, int n) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, n2));
        if (n > 2) {
            stringBuilder.append(string, 1, n - 1);
        }
        JsonPointer._appendEscape(stringBuilder, string.charAt(n++));
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '/') {
                return new JsonPointer(string, stringBuilder.toString(), JsonPointer._parseTail(string.substring(n)));
            }
            if (c == '~' && ++n < n2) {
                JsonPointer._appendEscape(stringBuilder, string.charAt(n++));
                continue;
            }
            stringBuilder.append(c);
        }
        return new JsonPointer(string, stringBuilder.toString(), EMPTY);
    }

    private static void _appendEscape(StringBuilder stringBuilder, char c) {
        if (c == '0') {
            c = (char)126;
        } else if (c == '1') {
            c = (char)47;
        } else {
            stringBuilder.append('~');
        }
        stringBuilder.append(c);
    }
}

