/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.core;

import com.snowflake.client.core.IncidentUtil;
import com.snowflake.client.core.SFException;
import com.snowflake.client.core.SFSession;
import com.snowflake.client.core.SFStatementType;
import com.snowflake.client.core.SessionUtil;
import com.snowflake.client.jdbc.ErrorCode;
import com.snowflake.client.jdbc.SnowflakeChunkDownloader;
import com.snowflake.client.jdbc.SnowflakeColumnMetadata;
import com.snowflake.client.jdbc.SnowflakeSQLException;
import com.snowflake.client.jdbc.SnowflakeUtil;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.gscommon.core.SFBinaryFormat;
import com.snowflake.gscommon.core.SFTime;
import com.snowflake.gscommon.core.SFTimestamp;
import com.snowflake.gscommon.core.SnowflakeDateTimeFormat;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResultUtil {
    static final Logger logger = Logger.getLogger(ResultUtil.class.getName());
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    private static final Map<String, Object> defaultParameters;

    public static ResultOutput processResult(ResultInput resultData) throws SnowflakeSQLException {
        JsonNode numberOfBindsNode;
        ResultOutput resultOutput = new ResultOutput();
        logger.log(Level.FINER, "Entering processResult");
        JsonNode rootNode = resultData.resultJSON;
        SnowflakeUtil.checkErrorAndThrowException(rootNode);
        resultOutput.queryId = rootNode.path("data").path("queryId").asText();
        resultOutput.statementTypeId = rootNode.path("data").path("statementTypeId").asLong();
        resultOutput.totalRowCountTruncated = rootNode.path("data").path("totalTruncated").asBoolean();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "query id:" + resultOutput.queryId);
        }
        resultOutput.parameters = SessionUtil.getCommonParams(rootNode.path("data").path("parameters"));
        Integer numCols = rootNode.path("data").path("rowtype").size();
        if (numCols == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to get number of columns.");
        }
        resultOutput.columnCount = numCols;
        for (int i = 0; i < resultOutput.columnCount; ++i) {
            JsonNode colNode = rootNode.path("data").path("rowtype").path(i);
            SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata(colNode);
            resultOutput.resultColumnMetadata.add(columnMetadata);
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.log(Level.FINER, "Get column metadata: " + columnMetadata.toString());
        }
        resultOutput.currentChunkRowset = rootNode.path("data").path("rowset");
        if (resultOutput.currentChunkRowset == null || resultOutput.currentChunkRowset.isMissingNode()) {
            resultOutput.currentChunkRowCount = 0;
        }
        resultOutput.currentChunkRowCount = resultOutput.currentChunkRowset.size();
        logger.log(Level.FINE, "First chunk row count: {0}", resultOutput.currentChunkRowCount);
        JsonNode chunksNode = rootNode.path("data").path("chunks");
        if (!chunksNode.isMissingNode()) {
            resultOutput.chunkCount = chunksNode.size();
            JsonNode qrmkNode = rootNode.path("data").path("qrmk");
            String qrmk = qrmkNode.isMissingNode() ? null : qrmkNode.textValue();
            JsonNode chunkHeaders = rootNode.path("data").path("chunkHeaders");
            if (resultOutput.chunkCount > 0L) {
                logger.log(Level.FINER, "#chunks={0}, initialize chunk downloader", resultOutput.chunkCount);
                Integer resultPrefetchSlots = 2;
                if (resultOutput.parameters.get("CLIENT_RESULT_PREFETCH_SLOTS") != null) {
                    resultPrefetchSlots = (Integer)resultOutput.parameters.get("CLIENT_RESULT_PREFETCH_SLOTS");
                }
                Integer resultPrefetchThreads = 1;
                if (resultOutput.parameters.get("CLIENT_RESULT_PREFETCH_THREADS") != null) {
                    resultPrefetchThreads = (Integer)resultOutput.parameters.get("CLIENT_RESULT_PREFETCH_THREADS");
                }
                Boolean useJsonParser = Boolean.TRUE;
                if (resultOutput.parameters.get("JDBC_USE_JSON_PARSER") != null) {
                    useJsonParser = (Boolean)resultOutput.parameters.get("JDBC_USE_JSON_PARSER");
                }
                resultOutput.chunkDownloader = new SnowflakeChunkDownloader(resultOutput.columnCount, chunksNode, resultPrefetchSlots, resultPrefetchThreads, qrmk, chunkHeaders, resultData.networkTimeoutInMilli, useJsonParser);
            }
        }
        String sqlTimestampFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIMESTAMP_OUTPUT_FORMAT");
        resultOutput.timestampNTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_ntz", "TIMESTAMP_NTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        resultOutput.timestampLTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_ltz", "TIMESTAMP_LTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        resultOutput.timestampTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_tz", "TIMESTAMP_TZ_OUTPUT_FORMAT", sqlTimestampFormat);
        String sqlDateFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "DATE_OUTPUT_FORMAT");
        resultOutput.dateFormatter = new SnowflakeDateTimeFormat(sqlDateFormat);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "sql date format: " + sqlDateFormat + ", java date format: " + resultOutput.dateFormatter.toSimpleDateTimePattern());
        }
        String sqlTimeFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIME_OUTPUT_FORMAT");
        resultOutput.timeFormatter = new SnowflakeDateTimeFormat(sqlTimeFormat);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "sql time format: " + sqlTimeFormat + ", java time format: " + resultOutput.timeFormatter.toSimpleDateTimePattern());
        }
        String timeZoneName = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIMEZONE");
        resultOutput.timeZone = TimeZone.getTimeZone(timeZoneName);
        resultOutput.honorClientTZForTimestampNTZ = (Boolean)ResultUtil.effectiveParamValue(resultOutput.parameters, "CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ");
        logger.log(Level.FINER, "Honoring client TZ for timestamp_ntz? {0}", resultOutput.honorClientTZForTimestampNTZ);
        String binaryFmt = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "BINARY_OUTPUT_FORMAT");
        resultOutput.binaryFormatter = SFBinaryFormat.get(binaryFmt);
        JsonNode versionNode = rootNode.path("data").path("version");
        if (!versionNode.isMissingNode()) {
            resultOutput.resultVersion = versionNode.longValue();
        }
        if (!(numberOfBindsNode = rootNode.path("data").path("numberOfBinds")).isMissingNode()) {
            resultOutput.numberOfBinds = numberOfBindsNode.intValue();
        }
        logger.log(Level.FINER, "result version={0}", resultOutput.resultVersion);
        return resultOutput;
    }

    private static Object effectiveParamValue(Map<String, Object> parameters, String paramName) {
        String upper = paramName.toUpperCase();
        Object value = parameters.get(upper);
        if (value != null) {
            return value;
        }
        value = defaultParameters.get(upper);
        if (value != null) {
            return value;
        }
        logger.log(Level.FINE, "Unknown Common Parameter: {0}", paramName);
        return null;
    }

    private static SnowflakeDateTimeFormat specializedFormatter(Map<String, Object> parameters, String id, String param, String defaultFormat) {
        String sqlFormat = SnowflakeDateTimeFormat.effectiveSpecializedTimestampFormat((String)ResultUtil.effectiveParamValue(parameters, param), defaultFormat);
        SnowflakeDateTimeFormat formatter = new SnowflakeDateTimeFormat(sqlFormat);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "sql " + id + " format: " + sqlFormat + ", java " + id + " format: " + formatter.toSimpleDateTimePattern());
        }
        return formatter;
    }

    public static Timestamp adjustTimestamp(Timestamp timestamp) {
        long milliToAdjust = ResultUtil.calculateMilliToAdjust(timestamp);
        if (milliToAdjust != 0L) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "adjust timestamp by " + milliToAdjust / 86400000L + " days");
            }
            Timestamp newTimestamp = new Timestamp(timestamp.getTime() + milliToAdjust);
            newTimestamp.setNanos(timestamp.getNanos());
            return newTimestamp;
        }
        return timestamp;
    }

    public static long calculateMilliToAdjust(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        if (date.getTime() < -12220156800000L) {
            if (month == 0 || month == 1 && dayOfMonth <= 28) {
                --year;
            }
            int hundreds = year / 100;
            int differenceInDays = hundreds - hundreds / 4 - 2;
            return differenceInDays * 86400000;
        }
        return 0L;
    }

    private static BigDecimal parseSecondsSinceEpoch(String secondsSinceEpochStr, int scale) {
        BigDecimal secondsSinceEpoch = new BigDecimal(secondsSinceEpochStr);
        return secondsSinceEpoch.scaleByPowerOfTen(scale);
    }

    public static SFTimestamp getSFTimestamp(Object obj, int scale, int internalColumnType, long resultVersion, TimeZone sessionTZ, SFSession session) throws SFException {
        logger.log(Level.FINER, "public Timestamp getTimestamp(int columnIndex)");
        try {
            TimeZone tz;
            BigDecimal fractionsSinceEpoch;
            if (obj == null) {
                return null;
            }
            switch (internalColumnType) {
                case 93: {
                    fractionsSinceEpoch = ResultUtil.parseSecondsSinceEpoch(obj.toString(), scale);
                    tz = timeZoneUTC;
                    break;
                }
                case 50001: {
                    String timestampStr = obj.toString();
                    if (resultVersion > 0L) {
                        logger.log(Level.FINEST, "Handle timestamp with timezone new encoding: {0}", timestampStr);
                        int indexForSeparator = timestampStr.indexOf(32);
                        String secondsSinceEpochStr = timestampStr.substring(0, indexForSeparator);
                        String timezoneIndexStr = timestampStr.substring(indexForSeparator + 1);
                        fractionsSinceEpoch = ResultUtil.parseSecondsSinceEpoch(secondsSinceEpochStr, scale);
                        tz = SFTimestamp.convertTimezoneIndexToTimeZone(Integer.parseInt(timezoneIndexStr));
                        break;
                    }
                    logger.log(Level.FINEST, "Handle timestamp with timezone old encoding: {0}", timestampStr);
                    fractionsSinceEpoch = ResultUtil.parseSecondsSinceEpoch(timestampStr, scale);
                    tz = null;
                    break;
                }
                default: {
                    assert (internalColumnType == 50000);
                    fractionsSinceEpoch = ResultUtil.parseSecondsSinceEpoch(obj.toString(), scale);
                    tz = sessionTZ;
                }
            }
            return SFTimestamp.fromBinary(fractionsSinceEpoch, scale, tz);
        }
        catch (NumberFormatException ex) {
            SFException sfe = IncidentUtil.generateIncidentWithException(session, null, null, ErrorCode.IO_ERROR, "Invalid timestamp value: " + obj.toString());
            throw sfe;
        }
    }

    public static SFTime getSFTime(Object obj, int scale, SFSession session) throws SFException {
        if (obj == null) {
            return null;
        }
        try {
            long fractionsSinceMidnight = ResultUtil.parseSecondsSinceEpoch(obj.toString(), scale).longValue();
            return SFTime.fromFractionalSeconds(fractionsSinceMidnight, scale);
        }
        catch (NumberFormatException ex) {
            SFException sfe = IncidentUtil.generateIncidentWithException(session, null, null, ErrorCode.INTERNAL_ERROR, "Invalid time value: " + obj.toString());
            throw sfe;
        }
    }

    public static String getSFTimeAsString(SFTime sft, int scale, SnowflakeDateTimeFormat timeFormatter) {
        return timeFormatter.format(sft, scale);
    }

    public static String getBooleanAsString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.toString().equals("1")) {
            return "TRUE";
        }
        if (obj.toString().equals("0")) {
            return "FALSE";
        }
        return obj.toString();
    }

    public static String getSFTimestampAsString(SFTimestamp sfTS, int columnType, int scale, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter, SFSession session) throws SFException {
        SnowflakeDateTimeFormat formatter = columnType == 93 ? timestampNTZFormatter : (columnType == 50000 ? timestampLTZFormatter : timestampTZFormatter);
        if (formatter == null) {
            SFException sfe = IncidentUtil.generateIncidentWithException(session, null, null, ErrorCode.INTERNAL_ERROR, "missing timestamp formatter");
            throw sfe;
        }
        Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(sfTS.getTimestamp());
        String timestampStr = formatter.format(adjustedTimestamp, sfTS.getTimeZone(), scale);
        return timestampStr;
    }

    public static String getDateAsString(Date date, SnowflakeDateTimeFormat dateFormatter) {
        String dateStr = dateFormatter.format((java.util.Date)date, timeZoneUTC);
        return dateStr;
    }

    private static Date adjustDate(Date date) {
        long milliToAdjust = ResultUtil.calculateMilliToAdjust(date);
        if (milliToAdjust != 0L) {
            Date newDate = new Date(date.getTime() + milliToAdjust);
            return newDate;
        }
        return date;
    }

    public static Date getDate(Object obj, TimeZone tz, SFSession session) throws SFException {
        try {
            if (obj == null) {
                return null;
            }
            long milliSecsSinceEpoch = Long.valueOf(obj.toString()) * 86400000L;
            SFTimestamp tsInUTC = SFTimestamp.fromDate(new Date(milliSecsSinceEpoch), 0, TimeZone.getTimeZone("UTC"));
            SFTimestamp tsInClientTZ = tsInUTC.moveToTimeZone(tz);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "getDate: tz offset=" + tsInClientTZ.getTimeZone().getOffset(tsInClientTZ.getTime()));
            }
            Date preDate = new Date(tsInClientTZ.getTime());
            Date newDate = ResultUtil.adjustDate(preDate);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Adjust date from {0} to {1}", new Object[]{preDate.toString(), newDate.toString()});
            }
            return newDate;
        }
        catch (NumberFormatException ex) {
            SFException sfe = IncidentUtil.generateIncidentWithException(session, null, null, ErrorCode.INTERNAL_ERROR, "Invalid date value: " + obj.toString());
            throw sfe;
        }
    }

    public static int calculateUpdateCount(ResultSet resultSet, long statementTypeId) throws SQLException {
        int updateCount = 0;
        if (SFStatementType.isDML(statementTypeId)) {
            while (resultSet.next()) {
                if (statementTypeId == 13824L) {
                    updateCount = (int)((long)updateCount + resultSet.getLong(4));
                    continue;
                }
                if (statementTypeId != 12544L && statementTypeId != 12800L && statementTypeId != 13056L && statementTypeId != 13312L && statementTypeId != 13568L) continue;
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    updateCount = (int)((long)updateCount + resultSet.getLong(i + 1));
                }
            }
        } else {
            updateCount = SFStatementType.isDDL(statementTypeId) ? 0 : -1;
        }
        return updateCount;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TIMEZONE", "America/Los_Angeles");
        map.put("TIMESTAMP_OUTPUT_FORMAT", "DY, DD MON YYYY HH24:MI:SS TZHTZM");
        map.put("TIMESTAMP_NTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_LTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_TZ_OUTPUT_FORMAT", "");
        map.put("DATE_OUTPUT_FORMAT", "YYYY-MM-DD");
        map.put("TIME_OUTPUT_FORMAT", "HH24:MI:SS");
        map.put("CLIENT_RESULT_PREFETCH_SLOTS", 2);
        map.put("CLIENT_RESULT_PREFETCH_THREADS", 1);
        map.put("CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ", Boolean.TRUE);
        map.put("JDBC_EXECUTE_RETURN_COUNT_FOR_DML", Boolean.FALSE);
        map.put("JDBC_SHARING_WITH_CANONICAL", Boolean.FALSE);
        map.put("JDBC_REWRITE_WITH_CANONICAL", Boolean.TRUE);
        map.put("CLIENT_DISABLE_INCIDENTS", Boolean.TRUE);
        map.put("BINARY_OUTPUT_FORMAT", "HEX");
        defaultParameters = map;
    }

    public static class ResultOutput {
        long chunkCount;
        String queryId;
        long statementTypeId;
        boolean totalRowCountTruncated;
        Map<String, Object> parameters = new HashMap<String, Object>();
        int columnCount;
        private List<SnowflakeColumnMetadata> resultColumnMetadata = new ArrayList<SnowflakeColumnMetadata>();
        private JsonNode currentChunkRowset = null;
        int currentChunkRowCount;
        long resultVersion;
        int numberOfBinds;
        SnowflakeChunkDownloader chunkDownloader;
        SnowflakeDateTimeFormat timestampNTZFormatter;
        SnowflakeDateTimeFormat timestampLTZFormatter;
        SnowflakeDateTimeFormat timestampTZFormatter;
        SnowflakeDateTimeFormat dateFormatter;
        SnowflakeDateTimeFormat timeFormatter;
        TimeZone timeZone;
        boolean honorClientTZForTimestampNTZ;
        SFBinaryFormat binaryFormatter;

        public long getChunkCount() {
            return this.chunkCount;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public long getStatementTypeId() {
            return this.statementTypeId;
        }

        public boolean isTotalRowCountTruncated() {
            return this.totalRowCountTruncated;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public List<SnowflakeColumnMetadata> getResultColumnMetadata() {
            return this.resultColumnMetadata;
        }

        public JsonNode getCurrentChunkRowset() {
            return this.currentChunkRowset;
        }

        public int getCurrentChunkRowCount() {
            return this.currentChunkRowCount;
        }

        public long getResultVersion() {
            return this.resultVersion;
        }

        public int getNumberOfBinds() {
            return this.numberOfBinds;
        }

        public SnowflakeChunkDownloader getChunkDownloader() {
            return this.chunkDownloader;
        }

        public SnowflakeDateTimeFormat getTimestampNTZFormatter() {
            return this.timestampNTZFormatter;
        }

        public SnowflakeDateTimeFormat getTimestampLTZFormatter() {
            return this.timestampLTZFormatter;
        }

        public SnowflakeDateTimeFormat getTimestampTZFormatter() {
            return this.timestampTZFormatter;
        }

        public SnowflakeDateTimeFormat getDateFormatter() {
            return this.dateFormatter;
        }

        public SnowflakeDateTimeFormat getTimeFormatter() {
            return this.timeFormatter;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public boolean isHonorClientTZForTimestampNTZ() {
            return this.honorClientTZForTimestampNTZ;
        }

        public SFBinaryFormat getBinaryFormatter() {
            return this.binaryFormatter;
        }
    }

    public static class ResultInput {
        JsonNode resultJSON;
        int connectionTimeout;
        int socketTimeout;
        int networkTimeoutInMilli;
        boolean useProxy;

        public ResultInput setResultJSON(JsonNode resultJSON) {
            this.resultJSON = resultJSON;
            return this;
        }

        public ResultInput setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public ResultInput setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ResultInput setNetworkTimeoutInMilli(int networkTimeoutInMilli) {
            this.networkTimeoutInMilli = networkTimeoutInMilli;
            return this;
        }

        public ResultInput setUseProxy(boolean useProxy) {
            this.useProxy = useProxy;
            return this;
        }
    }
}

