/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl.conn;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.commons.logging.Log;
import net.snowflake.ingest.internal.apache.commons.logging.LogFactory;
import net.snowflake.ingest.internal.apache.http.HttpException;
import net.snowflake.ingest.internal.apache.http.HttpMessage;
import net.snowflake.ingest.internal.apache.http.HttpResponseFactory;
import net.snowflake.ingest.internal.apache.http.NoHttpResponseException;
import net.snowflake.ingest.internal.apache.http.ProtocolException;
import net.snowflake.ingest.internal.apache.http.StatusLine;
import net.snowflake.ingest.internal.apache.http.annotation.ThreadSafe;
import net.snowflake.ingest.internal.apache.http.impl.io.AbstractMessageParser;
import net.snowflake.ingest.internal.apache.http.io.SessionInputBuffer;
import net.snowflake.ingest.internal.apache.http.message.LineParser;
import net.snowflake.ingest.internal.apache.http.message.ParserCursor;
import net.snowflake.ingest.internal.apache.http.params.HttpParams;
import net.snowflake.ingest.internal.apache.http.util.Args;
import net.snowflake.ingest.internal.apache.http.util.CharArrayBuffer;

@Deprecated
@ThreadSafe
public class DefaultResponseParser
extends AbstractMessageParser<HttpMessage> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;
    private final int maxGarbageLines;

    public DefaultResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        Args.notNull(responseFactory, "Response factory");
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
        this.maxGarbageLines = this.getMaxGarbageLines(params);
    }

    protected int getMaxGarbageLines(HttpParams params) {
        return params.getIntParameter("http.connection.max-status-line-garbage", Integer.MAX_VALUE);
    }

    @Override
    protected HttpMessage parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        int count = 0;
        ParserCursor cursor = null;
        while (true) {
            this.lineBuf.clear();
            int i = sessionBuffer.readLine(this.lineBuf);
            if (i == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            cursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
            if (i == -1 || count >= this.maxGarbageLines) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Garbage in response: " + this.lineBuf.toString());
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

