/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shibboleth.utilities.java.support.security.impl.RandomIdentifierGenerationStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RandomIdentifierGenerationStrategyTest {
    @Test
    public void testGenerateIdentifier() {
        Pattern ncNamePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_\\-\\.]+$");
        RandomIdentifierGenerationStrategy strat = new RandomIdentifierGenerationStrategy();
        int howMany = 1000;
        HashSet<String> values = new HashSet<String>(1000);
        for (int iteration = 1; iteration <= 1000; ++iteration) {
            String value = strat.generateIdentifier();
            if (values.contains(value)) {
                Assert.fail((String)("duplicate value " + value + " on iteration " + iteration));
            }
            values.add(value);
            Matcher match = ncNamePattern.matcher(value);
            if (match.matches()) continue;
            Assert.fail((String)("value " + value + " is not a valid NCName on iteration " + iteration));
        }
    }
}

