/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpCookie;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.net.SameSiteCookieHeaderFilter;
import org.springframework.mock.web.MockCookie;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.util.ReflectionTestUtils;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SameSiteCookieHeaderFilterTest {
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;

    @BeforeMethod
    public void setUp() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setMethod("POST");
        mockRequest.setRequestURI("/foo");
        this.request = mockRequest;
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockResponse.addHeader("Set-Cookie", "JSESSIONID=jyohu8ttc3dp1g3yqe8g8ff7y;Path=/idp;Secure;HttpOnly");
        mockResponse.addHeader("Set-Cookie", "shib_idp_session_ss=AAdzZWNyZXQyzL1Rzi9ROe3%2BGk%2B6%2B;Path=/idp;HttpOnly");
        mockResponse.addHeader("Set-Cookie", "shib_idp_session=8ee460bc0b3695c477b2b5f3e192ddf7297baa7ee01bd2bcf24695f8c21cb3a2;Path=/idp;HttpOnly");
        mockResponse.addHeader("Set-Cookie", "existing_same_site=already-same-site;Path=/idp;HttpOnly;SameSite=None");
        mockResponse.addHeader("Set-Cookie", "ignore_copy_over=copy-over;Path=/idp;HttpOnly");
        this.response = mockResponse;
    }

    @AfterMethod
    public void tearDown() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @Test
    public void testNullInitValues() {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        filter.setSameSiteCookies(null);
        filter.setDefaultValue(null);
    }

    @Test
    public void testEmptyCookieNameInitValue() {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{""});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.None, noneCookies);
        filter.setSameSiteCookies(cookies);
        this.testSameSiteMapSize("sameSiteCookies", 0, (Filter)filter);
    }

    @Test
    public void testInitValues() {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"});
        List<String> laxCookies = List.of(new String[]{"another-cookie-lax"});
        List<String> strictCookies = List.of(new String[]{"another-cookie-strict"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.None, noneCookies);
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.Lax, laxCookies);
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.Strict, strictCookies);
        filter.setSameSiteCookies(cookies);
        this.testSameSiteMapSize("sameSiteCookies", 6, (Filter)filter);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDuplicateInitValues() {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"});
        List<String> laxCookies = List.of(new String[]{"JSESSIONID"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.None, noneCookies);
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.Lax, laxCookies);
        filter.setSameSiteCookies(cookies);
    }

    @Test
    public void testEmptySameSiteCookieMap() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        filter.setSameSiteCookies(null);
        TestRedirectServlet redirectServlet = new TestRedirectServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)redirectServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        List headers = this.response.getHeaders("Set-Cookie");
        Assert.assertEquals((int)headers.size(), (int)5);
    }

    @Test
    public void testEmptySameSiteCookieMapAndNullDefault() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        filter.setSameSiteCookies(null);
        filter.setDefaultValue(SameSiteCookieHeaderFilter.SameSiteValue.Null);
        TestRedirectServlet redirectServlet = new TestRedirectServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)redirectServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        List headers = this.response.getHeaders("Set-Cookie");
        Assert.assertEquals((int)headers.size(), (int)5);
    }

    @Test
    public void testEmptySameSiteCookieMapWithDefault() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        filter.setSameSiteCookies(null);
        filter.setDefaultValue(SameSiteCookieHeaderFilter.SameSiteValue.Strict);
        TestRedirectServlet redirectServlet = new TestRedirectServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)redirectServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        List headers = this.response.getHeaders("Set-Cookie");
        Assert.assertEquals((int)headers.size(), (int)5);
        this.testExpectedHeadersInResponse(SameSiteCookieHeaderFilter.SameSiteValue.Strict.getValue(), (MockHttpServletResponse)mockRedirectChain.getResponse(), List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "ignore_copy_over"}), Collections.emptyList(), 5);
    }

    @Test
    public void testRedirectResponseSameSiteNone() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.None, noneCookies);
        filter.setSameSiteCookies(cookies);
        TestRedirectServlet redirectServlet = new TestRedirectServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)redirectServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        this.testExpectedHeadersInResponse("None", (MockHttpServletResponse)mockRedirectChain.getResponse(), List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"}), List.of(new String[]{"ignore_copy_over"}), 5);
    }

    @Test
    public void testRedirectResponseSameSiteNoneWithDefault() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"shib_idp_session", "shib_idp_session_ss", "existing_same_site"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.None, noneCookies);
        filter.setSameSiteCookies(cookies);
        filter.setDefaultValue(SameSiteCookieHeaderFilter.SameSiteValue.None);
        TestRedirectServlet redirectServlet = new TestRedirectServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)redirectServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        this.testExpectedHeadersInResponse("None", (MockHttpServletResponse)mockRedirectChain.getResponse(), List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site", "ignore_copy_over"}), Collections.emptyList(), 5);
    }

    @Test
    public void testRedirectResponseSameSiteLax() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.Lax, noneCookies);
        filter.setSameSiteCookies(cookies);
        TestRedirectServlet redirectServlet = new TestRedirectServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)redirectServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        this.testExpectedHeadersInResponse("Lax", (MockHttpServletResponse)mockRedirectChain.getResponse(), List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss"}), List.of(new String[]{"ignore_copy_over"}), 5);
    }

    @Test
    public void testRedirectResponseSameSiteStrict() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.Strict, noneCookies);
        filter.setSameSiteCookies(cookies);
        TestRedirectServlet redirectServlet = new TestRedirectServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)redirectServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        this.testExpectedHeadersInResponse("Strict", (MockHttpServletResponse)mockRedirectChain.getResponse(), List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss"}), List.of(new String[]{"ignore_copy_over"}), 5);
    }

    @Test
    public void testGetOutputStreamResponse() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.None, noneCookies);
        filter.setSameSiteCookies(cookies);
        TestOutputStreamServlet outputStreamServlet = new TestOutputStreamServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)outputStreamServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        this.testExpectedHeadersInResponse("None", (MockHttpServletResponse)mockRedirectChain.getResponse(), List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"}), List.of(new String[]{"ignore_copy_over"}), 5);
    }

    @Test
    public void testPrintWriterResponse() throws IOException, ServletException {
        SameSiteCookieHeaderFilter filter = new SameSiteCookieHeaderFilter();
        HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>> cookies = new HashMap<SameSiteCookieHeaderFilter.SameSiteValue, List<String>>();
        List<String> noneCookies = List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"});
        cookies.put(SameSiteCookieHeaderFilter.SameSiteValue.None, noneCookies);
        filter.setSameSiteCookies(cookies);
        TestPrintWriterServlet printWriterServlet = new TestPrintWriterServlet();
        MockFilterChain mockRedirectChain = new MockFilterChain((Servlet)printWriterServlet, new Filter[]{filter});
        mockRedirectChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertTrue((boolean)(mockRedirectChain.getResponse() instanceof MockHttpServletResponse));
        this.testExpectedHeadersInResponse("None", (MockHttpServletResponse)mockRedirectChain.getResponse(), List.of(new String[]{"JSESSIONID", "shib_idp_session", "shib_idp_session_ss", "existing_same_site"}), List.of(new String[]{"ignore_copy_over"}), 5);
    }

    private void testSameSiteMapSize(String fieldName, int expectedSize, Filter filter) {
        Object sameSiteSet = ReflectionTestUtils.getField((Object)filter, (String)fieldName);
        Assert.assertNotNull((Object)sameSiteSet);
        Assert.assertTrue((boolean)(sameSiteSet instanceof Map));
        Assert.assertEquals((int)((Map)sameSiteSet).size(), (int)expectedSize);
    }

    private void testExpectedHeadersInResponse(String sameSiteValue, MockHttpServletResponse response, List<String> cookiesWithSamesite, List<String> cookiesWithoutSameSite, int numberOfHeaders) {
        List headers = response.getHeaders("Set-Cookie");
        Assert.assertEquals((int)headers.size(), (int)numberOfHeaders);
        for (String header : headers) {
            List<HttpCookie> cookies = HttpCookie.parse(header);
            Assert.assertNotNull(cookies);
            Assert.assertTrue((cookies.size() == 1 ? 1 : 0) != 0);
            Cookie cookie = response.getCookie(cookies.get(0).getName());
            Assert.assertNotNull((Object)cookie);
            Assert.assertTrue((boolean)(cookie instanceof MockCookie));
            MockCookie mockCookie = (MockCookie)cookie;
            if (cookiesWithSamesite.contains(mockCookie.getName())) {
                Assert.assertNotNull((Object)mockCookie.getSameSite());
                Assert.assertEquals((String)mockCookie.getSameSite(), (String)sameSiteValue);
                continue;
            }
            if (!cookiesWithoutSameSite.contains(mockCookie.getName())) continue;
            Assert.assertNull((Object)mockCookie.getSameSite());
        }
    }

    public class TestPrintWriterServlet
    implements Servlet {
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Assert.assertNotNull((Object)req, (String)"HttpServletRequest was null");
            Assert.assertNotNull((Object)res, (String)"HttpServletResponse was null");
            PrintWriter writer = ((HttpServletResponse)res).getWriter();
            writer.flush();
        }

        public void init(ServletConfig config) throws ServletException {
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
        }
    }

    public class TestOutputStreamServlet
    implements Servlet {
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Assert.assertNotNull((Object)req, (String)"HttpServletRequest was null");
            Assert.assertNotNull((Object)res, (String)"HttpServletResponse was null");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)((HttpServletResponse)res).getOutputStream(), "UTF-8");
            ((Writer)out).flush();
        }

        public void init(ServletConfig config) throws ServletException {
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
        }
    }

    public class TestRedirectServlet
    implements Servlet {
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Assert.assertNotNull((Object)req, (String)"HttpServletRequest was null");
            Assert.assertNotNull((Object)res, (String)"HttpServletResponse was null");
            ((HttpServletResponse)res).sendRedirect("/redirect");
        }

        public void init(ServletConfig config) throws ServletException {
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
        }
    }
}

