/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.codec;

import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Base64SupportTest {
    private static final String PLAIN_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean malesuada, eros tempor aliquam ullamcorper, mauris velit iaculis metus, quis vulputate diam quam";
    private static final String UNCHUNCKED_ENCODED_TEXT = "TG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gQWVuZWFuIG1hbGVzdWFkYSwgZXJvcyB0ZW1wb3IgYWxpcXVhbSB1bGxhbWNvcnBlciwgbWF1cmlzIHZlbGl0IGlhY3VsaXMgbWV0dXMsIHF1aXMgdnVscHV0YXRlIGRpYW0gcXVhbQ==";
    private static final String CHUNCKED_ENCODED_TEXT = "TG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4g\nQWVuZWFuIG1hbGVzdWFkYSwgZXJvcyB0ZW1wb3IgYWxpcXVhbSB1bGxhbWNvcnBlciwgbWF1cmlz\nIHZlbGl0IGlhY3VsaXMgbWV0dXMsIHF1aXMgdnVscHV0YXRlIGRpYW0gcXVhbQ==";
    private static final String URLSAFE_UNCHUNCKED_ENCODED_TEXT = "TG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gQWVuZWFuIG1hbGVzdWFkYSwgZXJvcyB0ZW1wb3IgYWxpcXVhbSB1bGxhbWNvcnBlciwgbWF1cmlzIHZlbGl0IGlhY3VsaXMgbWV0dXMsIHF1aXMgdnVscHV0YXRlIGRpYW0gcXVhbQ";
    private static byte[] PLAIN_BYTES;
    private static final String UNCHUNCKED_ENCODED_BYTES = "FPucA9l+";
    private static final String URLSAFE_UNCHUNCKED_ENCODED_BYTES = "FPucA9l-";
    private static final String INVALID_BASE64_TRAILING = "AB==";
    private static final String INVALID_BASE64 = "ZE=";
    private static final String EMPTY_STRING = "";

    @BeforeClass
    public void setUp() throws DecoderException {
        PLAIN_BYTES = Hex.decodeHex((char[])"14fb9c03d97e".toCharArray());
    }

    @Test
    public void testEncode() throws EncodingException {
        Assert.assertEquals((String)Base64Support.encode((byte[])PLAIN_TEXT.getBytes(), (boolean)false), (String)UNCHUNCKED_ENCODED_TEXT);
        Assert.assertEquals((String)Base64Support.encode((byte[])PLAIN_TEXT.getBytes(), (boolean)true), (String)CHUNCKED_ENCODED_TEXT);
        Assert.assertEquals((String)Base64Support.encode((byte[])PLAIN_BYTES, (boolean)false), (String)UNCHUNCKED_ENCODED_BYTES);
    }

    @Test
    public void testEncodeEmptyByteArray() throws EncodingException {
        String encoded = Base64Support.encode((byte[])new byte[0], (boolean)false);
        Assert.assertNotNull((Object)encoded);
        Assert.assertEquals((String)encoded, (String)EMPTY_STRING);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEncodeNullInput() throws EncodingException {
        Base64Support.encode(null, (boolean)false);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testDecodeNullInput() throws DecodingException {
        Base64Support.decode(null);
    }

    @Test
    public void testDecode() throws DecodingException {
        Assert.assertEquals((String)new String(Base64Support.decode((String)UNCHUNCKED_ENCODED_TEXT)), (String)PLAIN_TEXT);
        Assert.assertEquals((String)new String(Base64Support.decode((String)CHUNCKED_ENCODED_TEXT)), (String)PLAIN_TEXT);
        Assert.assertEquals((byte[])Base64Support.decode((String)UNCHUNCKED_ENCODED_BYTES), (byte[])PLAIN_BYTES);
    }

    @Test(expectedExceptions={DecodingException.class})
    public void testDecodeInvalidInput() throws DecodingException {
        Base64Support.decode((String)INVALID_BASE64);
    }

    @Test
    public void testEmptyDecodedOutput() throws DecodingException {
        byte[] decoded = Base64Support.decode((String)EMPTY_STRING);
        Assert.assertNotNull((Object)decoded);
        Assert.assertTrue((decoded.length == 0 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={DecodingException.class})
    public void testDecodeInvalidTrailingBitsInput() throws DecodingException {
        Base64Support.decode((String)INVALID_BASE64_TRAILING);
    }

    @Test
    public void testEncodeURLSafe() throws EncodingException {
        Assert.assertEquals((String)Base64Support.encodeURLSafe((byte[])PLAIN_TEXT.getBytes()), (String)URLSAFE_UNCHUNCKED_ENCODED_TEXT);
        Assert.assertEquals((String)Base64Support.encodeURLSafe((byte[])PLAIN_BYTES), (String)URLSAFE_UNCHUNCKED_ENCODED_BYTES);
    }

    @Test
    public void testDecodeURLSafe() throws DecodingException {
        Assert.assertEquals((String)new String(Base64Support.decodeURLSafe((String)URLSAFE_UNCHUNCKED_ENCODED_TEXT)), (String)PLAIN_TEXT);
        Assert.assertEquals((byte[])Base64Support.decodeURLSafe((String)URLSAFE_UNCHUNCKED_ENCODED_BYTES), (byte[])PLAIN_BYTES);
    }
}

