/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.logic.TransformAndCheckFunction;
import net.shibboleth.utilities.java.support.logic.TrimOrNullStringFunction;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TransformAndCheckFunctionTest {
    private final List<String> excludes = Arrays.asList("one", "2", "iii");

    @Test
    public void testConstructorFails() {
        TransformAndCheckFunction f = null;
        boolean thrown = false;
        try {
            f = new TransformAndCheckFunction((Function)this.nullValue(), (java.util.function.Predicate)((Object)new MyPredicate()), true);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Null function should throw");
        thrown = false;
        try {
            f = new TransformAndCheckFunction((Function)TrimOrNullStringFunction.INSTANCE, (java.util.function.Predicate)this.nullValue(), true);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Null predicate should throw");
        Assert.assertNull((Object)f, (String)"silence compiler warning");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testApply() {
        TransformAndCheckFunction f = new TransformAndCheckFunction((Function)TrimOrNullStringFunction.INSTANCE, (java.util.function.Predicate)((Object)new MyPredicate()), false);
        Assert.assertFalse((boolean)((Optional)f.apply(" two")).isPresent(), (String)"Should not be present since the predicate failed");
        Assert.assertEquals((String)((String)((Optional)f.apply(" iii ")).get()), (String)"iii", (String)"present and trimmed");
        f = new TransformAndCheckFunction((Function)TrimOrNullStringFunction.INSTANCE, (java.util.function.Predicate)((Object)new MyPredicate()), true);
        Assert.assertEquals((String)((String)((Optional)f.apply(" iii ")).get()), (String)"iii", (String)"present and trimmed");
        f.apply(" two");
    }

    private <T> T nullValue() {
        return null;
    }

    private class MyPredicate
    implements Predicate<String> {
        private MyPredicate() {
        }

        public boolean test(String input) {
            for (String s : TransformAndCheckFunctionTest.this.excludes) {
                if (!s.equals(input)) continue;
                return true;
            }
            return false;
        }
    }
}

