/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.security.DataExpiredException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import net.shibboleth.utilities.java.support.test.resource.TestResourceConverter;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DataSealerTest {
    private Resource keystoreResource;
    private Resource versionResource;
    private Resource version2Resource;
    @Nonnull
    @NotEmpty
    private final String THE_DATA = "THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA";
    private final Duration THE_DELAY = Duration.ofMillis(500L);

    @BeforeClass
    public void initializeKeystoreResource() {
        ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/security/SealerKeyStore.jks");
        Assert.assertTrue((boolean)resource.exists());
        this.keystoreResource = TestResourceConverter.of((org.springframework.core.io.Resource)resource);
        resource = new ClassPathResource("/net/shibboleth/utilities/java/support/security/SealerKeyStore.kver");
        Assert.assertTrue((boolean)resource.exists());
        this.versionResource = TestResourceConverter.of((org.springframework.core.io.Resource)resource);
        resource = new ClassPathResource("/net/shibboleth/utilities/java/support/security/SealerKeyStore.kver2");
        Assert.assertTrue((boolean)resource.exists());
        this.version2Resource = TestResourceConverter.of((org.springframework.core.io.Resource)resource);
    }

    private DataSealer createDataSealer() throws DataSealerException, ComponentInitializationException {
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("kpassword");
        strategy.setKeystorePassword("password");
        strategy.setKeystoreResource(this.keystoreResource);
        strategy.setKeyVersionResource(this.versionResource);
        strategy.initialize();
        DataSealer sealer = new DataSealer();
        sealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        sealer.initialize();
        return sealer;
    }

    private DataSealer createDataSealer2() throws DataSealerException, ComponentInitializationException {
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("kpassword");
        strategy.setKeystorePassword("password");
        strategy.setKeystoreResource(this.keystoreResource);
        strategy.setKeyVersionResource(this.version2Resource);
        strategy.initialize();
        DataSealer sealer = new DataSealer();
        sealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        sealer.initialize();
        return sealer;
    }

    @Test
    public void encodeDecode() throws DataSealerException, ComponentInitializationException {
        DataSealer sealer = this.createDataSealer();
        String encoded = sealer.wrap("THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA");
        StringBuffer alias = new StringBuffer();
        Assert.assertEquals((String)sealer.unwrap(encoded, alias), (String)"THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA");
        Assert.assertEquals((String)alias.toString(), (String)"secret1");
    }

    @Test
    public void encodeDecodeWithExp() throws DataSealerException, ComponentInitializationException {
        DataSealer sealer = this.createDataSealer();
        String encoded = sealer.wrap("THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA", Instant.now().plusSeconds(50L));
        StringBuffer alias = new StringBuffer();
        Assert.assertEquals((String)sealer.unwrap(encoded, alias), (String)"THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA");
        Assert.assertEquals((String)alias.toString(), (String)"secret1");
    }

    @Test
    public void encodeDecodeSecondKey() throws DataSealerException, ComponentInitializationException {
        DataSealer sealer = this.createDataSealer();
        DataSealer sealer2 = this.createDataSealer2();
        StringBuffer alias = new StringBuffer();
        String encoded = sealer.wrap("THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA", Instant.now().plusSeconds(50L));
        Assert.assertEquals((String)sealer.unwrap(encoded, alias), (String)"THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA");
        Assert.assertEquals((String)alias.toString(), (String)"secret1");
        alias.setLength(0);
        Assert.assertEquals((String)sealer2.unwrap(encoded, alias), (String)"THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA");
        Assert.assertEquals((String)alias.toString(), (String)"secret1");
    }

    @Test
    public void timeOut() throws DataSealerException, InterruptedException, ComponentInitializationException {
        DataSealer sealer = this.createDataSealer();
        String encoded = sealer.wrap("THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA", Instant.now().plus(this.THE_DELAY));
        Thread.sleep(this.THE_DELAY.toMillis() + 150L);
        try {
            sealer.unwrap(encoded);
            Assert.fail((String)"Should have timed out");
        }
        catch (DataExpiredException dataExpiredException) {
            // empty catch block
        }
    }

    @Test
    public void encodeDecodeLong() throws DataSealerException, ComponentInitializationException {
        DataSealer sealer = this.createDataSealer();
        char[] buffer = new char[1000000];
        Arrays.fill(buffer, 'x');
        String longData = new String(buffer);
        String encoded = sealer.wrap(longData, Instant.now().plusSeconds(50L));
        StringBuffer alias = new StringBuffer();
        Assert.assertEquals((String)sealer.unwrap(encoded, alias), (String)longData);
        Assert.assertEquals((String)alias.toString(), (String)"secret1");
    }

    @Test
    public void badValues() throws DataSealerException, ComponentInitializationException {
        DataSealer sealer = new DataSealer();
        try {
            sealer.initialize();
            Assert.fail((String)"no strategy");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        sealer = this.createDataSealer();
        try {
            sealer.unwrap("");
            Assert.fail((String)"no data");
        }
        catch (DataSealerException dataSealerException) {
            // empty catch block
        }
        try {
            sealer.unwrap("RandomGarbage");
            Assert.fail((String)"random data");
        }
        catch (DataSealerException dataSealerException) {
            // empty catch block
        }
        String wrapped = sealer.wrap("THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATATHIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA THIS IS SOME TEST DATA", Instant.now().plusSeconds(3600L));
        String corrupted = wrapped.substring(0, 25) + "A" + wrapped.substring(27);
        try {
            sealer.unwrap(corrupted);
            Assert.fail((String)"corrupted data");
        }
        catch (DataSealerException dataSealerException) {
            // empty catch block
        }
        try {
            sealer.wrap((String)this.nullValue(), Instant.ofEpochMilli(10L));
            Assert.fail((String)"no data");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private <T> T nullValue() {
        return null;
    }
}

